﻿using System;
using System.Data;
using System.Configuration;
using System.Text;
using System.Data.SqlClient;
using nspLable.Manage;
using Consultative;
using nspLable.Function;
using System.IO;
using System.Web;
using System.Web.Compilation;
using Base.Core;
using nspLable.Function.Systems;
using Base;
using SqlOperate;

namespace nspLable.Function.Systems
{
    /// <summary>
    /// 资讯标签类
    /// </summary>
    public partial class clsNewslable
    {
        /// <summary>
        /// SY_NewsList(string Array) 资讯图文列表
        /// </summary>
        /// <param name="Array">
        /// WhichType---(哪种形式显示图片。1为上下，2为左右,3为幻灯片)
        /// PicWidth---（图片宽度）
        /// PicHeight---（图片高度）
        /// FrameUrl---（图片边框）
        /// Num--(显示条数)
        /// isTitle---（是否显示标题）[1显示，0不显示]
        /// TitleSize--（标题字数）
        /// TitleClass---（标题样式）
        /// Target---（链接目标）
        /// ConterSize---（内容字数）
        /// RowsNum---（每行显示几条）
        /// TypeID（信息大类）---[0为全部]
        /// NewsAttribute（文章属性）----[0为全部，1为推荐，2热点，3为固顶，4，其它]
        /// </param>
        /// <returns></returns>
        public static string SY_NewsList_Pic(TSystemLable Array)
        {

            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 13) goto Err;

            int WhichType = Convert.ToInt32(strContent[0].ToString());
            int picWidth = Convert.ToInt32(strContent[1].ToString());
            int picHight = Convert.ToInt32(strContent[2].ToString());
            string FrameUrl = strContent[3].ToString();
            string isTitle = strContent[4].ToString();
            string TitleClass = strContent[5].ToString();
            int TitleSize = Convert.ToInt32(strContent[6].ToString());
            int ConterSize = 0;
            if (Base.Common.CheckNum(strContent[7].ToString()))
            {
                ConterSize = Convert.ToInt32(strContent[7].ToString());
            }
            string Target = strContent[8].ToString();
            int Num = Convert.ToInt32(strContent[9].ToString());
            int RowsNum = Convert.ToInt32(strContent[10].ToString());
            int TypeID = Convert.ToInt32(strContent[11].ToString());
            string NewsAttribute = strContent[12].ToString();

            //临时字符串
            StringBuilder strWhere = new StringBuilder();
            string strSelect;
            //读取几条信息
            if (Num <= 0)
                strSelect = " top 1 * ";
            else
                strSelect = " top " + Num + " * ";

            //资讯类型 
            strWhere.Append(" where 1=1 and Picture<>'' and Picture<>'../../Images/System/wutu.gif'");
            if (WhichType == 3)
            {
                strWhere.Append(" AND IsHotspot=1");
            }
            else
            {
                strWhere.Append(" AND IsHotspot=0");
            }
            if (TypeID != 0)
            {
                if (TypeID < 0)
                {
                    if (HttpContext.Current.Request.QueryString["ID"] != "")
                    {
                        TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                        strWhere.Append(" and TypeID = ");
                        strWhere.Append(TypeID);
                    }
                }
                else
                {
                    strWhere.Append(" and TypeID = ");
                    strWhere.Append(TypeID);
                }
            }

            if (HttpContext.Current.Request.QueryString["ID"] != null)
            {
                strSelect = " * ";
                TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                strWhere.Length = 0;
                strWhere.Append(" where ID = ");
                strWhere.Append(TypeID);
                strWhere.Append(" and Picture<>'../../Images/System/wutu.gif' and Picture<>''");
            }else
                strSelect = " top " + Num + " * ";

            // 资讯属性
            //if (NewsAttribute != "")
            //{
            //    strWhere.Append("and Attribute like '%");
            //    strWhere.Append(NewsAttribute);
            //    strWhere.Append("%' ");
            //}

            DataTable NewsList = Function.GetDataTable(strSelect, strWhere.ToString(), "W_Consultative", " order by ID desc");
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td >");
            if (WhichType == 3)
            {
                strBuilder = ExType(strBuilder, NewsList, picWidth, picHight);
            }
            for (int i = 0; i < NewsList.Rows.Count; i++)
            {
                if (i > Num) break; //如果超过显示的条数则跳出。
                switch (WhichType)
                {
                    case 1:  //上下结构
                        strBuilder.Append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\"><tr><td>");
                        if (NewsList.Rows[i]["ChangeDirectionLink"].ToString()=="")
                        {
                            strBuilder.Append(@"<a href='{PB_WebURL}News/detail-");
                            strBuilder.Append(NewsList.Rows[i]["ID"].ToString());
                            strBuilder.Append(Base.BasePage.Config.Rewrite);
                            strBuilder.Append("");
                        }
                        else
                        {
                            string js = @"<Script language='JavaScript'>window.location.replace('{0}');</Script>";
                            js = string.Format(js, NewsList.Rows[i]["ChangeDirectionLink"].ToString());
                            HttpContext.Current.Response.Write(js);                           
                           // strBuilder.Append(@"<a href='" + NewsList.Rows[i]["ChangeDirectionLink"] + "");
                        }
                        strBuilder.Append(@" ' Target='" + Target + "'");
                        strBuilder.Append(@" >");
                        strBuilder.Append("<img width='");
                        strBuilder.Append(picWidth);
                        strBuilder.Append(@"' height='");
                        strBuilder.Append(picHight + "'");
                        if (FrameUrl != "" || FrameUrl != null)
                        {
                            strBuilder.Append(" class='" + FrameUrl + "' ");
                        }
                        strBuilder.Append(@" src='");
                        strBuilder.Append(Function.ProcessImageUrl(NewsList.Rows[i]["Picture"].ToString()));
                        strBuilder.Append(@"'></a>");
                        if (isTitle == "1") //是否显示标题
                        {
                            strBuilder.Append("</td></tr><tr><td align=\"center\" style=' padding-top: 3px;'>");
                            if (NewsList.Rows[i]["ChangeDirectionLink"].ToString().Equals(string.Empty))
                            {
                                strBuilder.Append(@"<a href='{PB_WebURL}News/detail-");
                                strBuilder.Append(NewsList.Rows[i]["ID"].ToString());
                                strBuilder.Append(Base.BasePage.Config.Rewrite);
                                strBuilder.Append("");
                            }
                            else
                            {
                                strBuilder.Append(@"<a href='" + NewsList.Rows[i]["ChangeDirectionLink"] + "");
                            }
                            strBuilder.Append(@" ' Target='");
                            strBuilder.Append(Target + "'");
                            if (TitleClass != "" || TitleClass != null)
                            {
                                strBuilder.Append(" class='" + TitleClass + "'");
                            }
                            strBuilder.Append(@">");

                            if (TitleSize > 0)
                                strBuilder.Append(Function.GetString(NewsList.Rows[i]["title"].ToString(), TitleSize));
                            else
                                strBuilder.Append(NewsList.Rows[i]["title"].ToString());
                            strBuilder.Append(@"</a>");
                        }
                        strBuilder.Append(@"</td></tr></table>");
                        break;
                    case 2: //左右结构
                        strBuilder.Append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td rowspan='2'>");
                        if (NewsList.Rows[i]["ChangeDirectionLink"].ToString().Equals(string.Empty))
                        {
                            strBuilder.Append(@"<a href='{PB_WebURL}News/detail-");
                            strBuilder.Append(NewsList.Rows[i]["ID"].ToString());
                            strBuilder.Append(Base.BasePage.Config.Rewrite);
                            strBuilder.Append("");
                        }
                        else
                        {
                            strBuilder.Append(@"<a href='" + NewsList.Rows[i]["ChangeDirectionLink"] + "");
                        }
                        strBuilder.Append(@" ' Target='" + Target + "'");
                        strBuilder.Append(@" >");
                        strBuilder.Append("<img width='" + picWidth + "'");
                        strBuilder.Append(@" height='");
                        strBuilder.Append(picHight + "'");
                        if (FrameUrl != "" || FrameUrl != null)
                        {
                            strBuilder.Append(" class='" + FrameUrl + "' ");
                        }
                        strBuilder.Append(@" src='");
                        strBuilder.Append(Function.ProcessImageUrl(NewsList.Rows[i]["Picture"].ToString()));
                        strBuilder.Append(@"'></a></td><td>");
                        if (NewsList.Rows[i]["ChangeDirectionLink"].ToString().Equals(string.Empty))
                        {
                            strBuilder.Append(@"<a href='{PB_WebURL}News/detail-");
                            strBuilder.Append(NewsList.Rows[i]["ID"].ToString());
                            strBuilder.Append(Base.BasePage.Config.Rewrite);
                            strBuilder.Append("");
                        }
                        else
                        {
                            strBuilder.Append(@"<a href='" + NewsList.Rows[i]["ChangeDirectionLink"] + "");
                        }
                        strBuilder.Append(@" ' Target='");
                        strBuilder.Append(Target + "'");
                        if (TitleClass != "" || TitleClass != null)
                        {
                            strBuilder.Append(" class='" + TitleClass + "'");
                        }
                        strBuilder.Append(@">");
                        if (TitleSize > 0) //设置标题字数
                            if (NewsList.Rows[i]["Title"].ToString().Length > TitleSize)
                                strBuilder.Append(NewsList.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                            else
                                strBuilder.Append(NewsList.Rows[i]["Title"].ToString());
                        else
                            strBuilder.Append(NewsList.Rows[i]["title"].ToString());
                        strBuilder.Append(@"</a>");
                        strBuilder.Append("</td></tr><tr><td valign=\"top\" class=\"info_cont\">");
                        if (ConterSize > 0) //设置导读字数
                            strBuilder.Append(Function.GetString(NewsList.Rows[i]["Reading"].ToString(), ConterSize));
                        else
                            strBuilder.Append(NewsList.Rows[i]["Reading"].ToString());
                        strBuilder.Append(@"</td></tr></table>");
                        break;
                }
                if (((i + 1) % RowsNum) == 0)  //换行
                {
                    if (i == (Num - 1))
                    {
                        strBuilder.Append(@"</td></tr>");
                    }
                    else
                    {
                        strBuilder.Append(@"</td></tr><tr><td>");
                    }
                }
                else
                {

                    strBuilder.Append(@"</td><td>");
                }
            }
            strBuilder.Append(@"</table>");
            return strBuilder.ToString();

        Err:
            return Function.ErrInfo(0);
        }

        /// <summary>
        /// 幻灯片处理
        /// </summary>
        private static StringBuilder ExType(StringBuilder strBuilder, DataTable NewsList, int picWidth, int picHight)
        {
            strBuilder.Append("\n <script type=\"text/javascript\"> \n ");
            strBuilder.Append(" var interval_time=0; \n");
            strBuilder.Append(" var focus_width= " + picWidth + "; \n ");
            strBuilder.Append(" var focus_height=" + picHight + "; \n ");
            strBuilder.Append(" var text_height=24; \n ");
            strBuilder.Append(" var text_align=\"center\"; \n ");
            strBuilder.Append(" var swf_height=focus_height+text_height; \n ");
            strBuilder.Append(" var pics= \" ");
            if (NewsList.Rows.Count > 0)
            {
                for (int i = 0; i < NewsList.Rows.Count; i++)
                {
                    if (i != (NewsList.Rows.Count - 1))
                        strBuilder.Append(Function.ProcessImageUrl(NewsList.Rows[i]["Picture"].ToString()) + "|");
                    else
                        strBuilder.Append(Function.ProcessImageUrl(NewsList.Rows[i]["Picture"].ToString()));
                }
            }
            strBuilder.Append(" \" \n var links=\" ");
            if (NewsList.Rows.Count > 0)
            {
                for (int i = 0; i < NewsList.Rows.Count; i++)
                {
                    if (i != (NewsList.Rows.Count - 1))
                        strBuilder.Append("{PB_WebURL}News/detail-" + NewsList.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite + "|");
                    else
                        strBuilder.Append("{PB_WebURL}News/detail-" + NewsList.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite);
                }
            }
            strBuilder.Append(" \" \n var texts=\" ");
            if (NewsList.Rows.Count > 0)
            {
                for (int i = 0; i < NewsList.Rows.Count; i++)
                {
                    if (i != (NewsList.Rows.Count - 1))
                        strBuilder.Append(NewsList.Rows[i]["Title"].ToString() + "|");
                    else
                        strBuilder.Append(NewsList.Rows[i]["Title"].ToString());
                }
            }
            strBuilder.Append(" \" \n ");
            strBuilder.Append("document.write('<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" ");
            strBuilder.Append("codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0 \"");
            strBuilder.Append(" width=\"'+ focus_width +'\" height=\"'+ swf_height +'\">'); \n ");
            strBuilder.Append("document.write('<param name=\"allowScriptAccess\" value=\"sameDomain\" /><param name=\"movie\"");
            strBuilder.Append("value=\"{PB_WebUrl}Images/pixviewer.swf\" /><param name=\"quality\" value=\"high\" /><param name=\"bgcolor\" value=\"#F0F0F0\">');");
            strBuilder.Append(" \n document.write('<param name=\"menu\" value=\"false\"><param name=wmode value=\"opaque\">'); \n ");
            strBuilder.Append("document.write('<param name=\"FlashVars\" value=\"pics='+pics+'&links='+links+'&texts='+texts+'&borderwidth='+focus_width+'&borderheight='");
            strBuilder.Append("+focus_height+'&textheight='+text_height+'\">'); \n ");
            strBuilder.Append("document.write('<embed src=\"{PB_WebUrl}Images/pixviewer.swf\" wmode=\"opaque\"");
            strBuilder.Append("FlashVars=\"pics='+pics+'&links='+links+'&texts='+texts+'&borderwidth='+focus_width+'&borderheig");
            strBuilder.Append("ht='+focus_height+'&textheight='+text_height+'\" menu=\"false\" bgcolor=\"#F0F0F0\" quality=\"high\"");
            strBuilder.Append("width=\"'+ focus_width +'\" height=\"'+ focus_height +'\" allowScriptAccess=\"sameDomain\"");
            strBuilder.Append("type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\"/>');");
            strBuilder.Append(" \n document.write('</object>');");
            strBuilder.Append(" \n </script>");
            return strBuilder;
        }

        /// <summary>
        /// 资讯文字标签
        /// </summary>
        /// <param name="Array">
        /// Num	显示条数	
        /// RowsNum	每行显示几条	
        /// isType	是否显示类型[0不显示，1显示]	
        /// TitleLenght 标题字数	
        /// TitleClass	class	
        /// target	链接目标	
        /// isDate	是否显示日期[0不显示，1显示]	
        /// DateClass	日期样式	
        /// TypeID	信息类别ID，0为全部	
        /// NewsAttribute	文章属性[0为全部，1为推荐，2热点，3为固顶，4，其它]	
        /// </param>
        /// <returns></returns>
        public static string SY_NewsList_Str(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 11) goto Err;
            int Num = Convert.ToInt32(strContent[0].ToString());
            int RowsNum = Convert.ToInt32(strContent[1].ToString());
            string isType = strContent[2].ToString();
            int TitleLenght = Convert.ToInt32(strContent[3].ToString());
            string TitleClass = strContent[4].ToString();
            string target = strContent[5].ToString();
            string isDate = strContent[6].ToString();
            string DateClass = strContent[7].ToString();
            int TypeID = Convert.ToInt32(strContent[8].ToString());
            string NewsAttribute = strContent[9].ToString();
            string TitleSpace = strContent[10].ToString();
            //临时字符串
            StringBuilder strWhere = new StringBuilder();
            string strSelect;
            //读取几条信息
            if (Num <= 0)
                strSelect = " top 1 ";
            else
                strSelect = " top " + Num + " *";

            //资讯类型 
            strWhere.Append("where 1=1");
            if (TypeID != 0)
            {
                if (TypeID < 0)
                {
                    if (HttpContext.Current.Request.QueryString["ID"] != "")
                    {
                        strWhere.Append("and TypeID = ");
                        strWhere.Append(Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]));
                    }
                }
                else
                {
                    strWhere.Append("and TypeID = ");
                    strWhere.Append(TypeID);
                    strWhere.Append(" or W_ConsultativeType.ParentID = ");
                    strWhere.Append(TypeID);
                }
            }
            string str1 = "";
            if (NewsAttribute[0] == '0')
                str1 += "[01],";
            else
                str1 += "1,";

            if (NewsAttribute[2] == '0')
                str1 += "[01],";
            else
                str1 += "1,";

            if (NewsAttribute[4] == '0')
                str1 += "[01]";
            else
                str1 += "1";

            //资讯属性
            //if (NewsAttribute != "")
            //{
            //    strWhere.Append("and Attribute like '");
            //    strWhere.Append(str1);
            //    strWhere.Append("%' ");
            //}
            StringBuilder strSQL = new StringBuilder();
            strSQL.Append("select");
            strSQL.Append(strSelect);
            strSQL.Append(" from ");
            strSQL.Append(" W_Consultative left join W_ConsultativeType on W_Consultative.TypeID=W_ConsultativeType.ID ");
            strSQL.Append(strWhere);

            strSQL.Append(" order by W_Consultative.ID desc");
            DataTable NewsList = Function.GetDataTable(strSQL.ToString());  //取得资讯列表
            StringBuilder strBuilder = new StringBuilder();
            if (NewsList.Rows.Count == 0)
            {
                strBuilder.Append("暂无信息");
            }
            else
            {
                int intCount = NewsList.Rows.Count;
                int intRow = 0;
                int intCell = RowsNum;
                intRow = intCount % intCell == 0 ? intCount / intCell : intCount / intCell + 1;
                strBuilder.Append("<table width='100%'  border=\"0\" cellpadding=\"0\" cellspacing=\"0\">" + "\r\n ");
                for (int i = 0; i < intRow; i++)
                {
                    strBuilder.Append("<tr>" + "\r\n ");
                    for (int j = 0; j < intCell; j++)
                    {
                        int m = i * intCell + j;
                        if (m > Num || m >= intCount) break; //如果超过显示的条数则跳出。
                        strBuilder.Append("<td valign='top' ");
                        if (TitleClass != "" || TitleClass != null)
                        {
                            strBuilder.Append(@" class='" + TitleClass + "'");
                        }
                        strBuilder.Append(">");


                        if (TypeID < 1)
                        {
                            //是否显示日期
                            if (isDate == "1")
                            {
                                strBuilder.Append("<span style='float:right'>");
                                strBuilder.Append(DateTime.Parse(NewsList.Rows[m]["AddDate"].ToString()).ToString(DateClass));
                                strBuilder.Append("</span>");
                            }
                        }

                        //是否显示分类，如果不显示分类则显示点
                        if (isType == "1")
                        {
                            strBuilder.Append(@"[");
                            strBuilder.Append(@"<a href=");
                            strBuilder.Append(@"{PB_WebURL}");
                            strBuilder.Append(@"News/Trade-");
                            strBuilder.Append(NewsList.Rows[m]["TypeID"].ToString());
                            strBuilder.Append(Base.BasePage.Config.Rewrite);
                            strBuilder.Append(@">");
                            strBuilder.Append(NewsList.Rows[m]["Name"].ToString());
                            strBuilder.Append(@"</a>] ");
                        }
                        //显示标题
                        strBuilder.Append(@"<a href='");
                        if (NewsList.Rows[i]["Detail"].ToString().Length > 0)
                        {
                            strBuilder.Append(@"{PB_WebURL}");
                            strBuilder.Append(@"News/Detail-");
                            strBuilder.Append(NewsList.Rows[m]["ID"].ToString());
                            strBuilder.Append(Base.BasePage.Config.Rewrite);
                        }
                        else
                        {
                            strBuilder.Append(NewsList.Rows[m]["ChangeDirectionLink"].ToString());
                        }

                        strBuilder.Append(@"'>");
                        if (NewsList.Rows[m]["Title"].ToString().Length > TitleLenght && TitleLenght > 0)
                            strBuilder.Append(NewsList.Rows[m]["Title"].ToString().Substring(0, TitleLenght));
                        else
                            strBuilder.Append(NewsList.Rows[m]["Title"].ToString());
                        strBuilder.Append(@"</a>");

                        if (TypeID > 0)
                        {
                            //是否显示日期
                            if (isDate == "1")
                            {
                                strBuilder.Append("&nbsp;&nbsp;");
                                strBuilder.Append("<span>");
                                strBuilder.Append(DateTime.Parse(NewsList.Rows[m]["AddDate"].ToString()).ToString(DateClass));
                                strBuilder.Append("</span>");
                            }
                        }
                        //间距
                        if (j != intCell - 1)
                        {
                            strBuilder.Append("</td><td width='" + TitleSpace + "'>");
                        }
                        strBuilder.Append("</td>");
                    }
                    strBuilder.Append("</tr>" + "\r\n ");
                }
                strBuilder.Append(@"</table>" + "\r\n ");
            }
            return strBuilder.ToString();

        Err:
            return Function.ErrInfo(0);
        }

        /// <summary>
        /// 资讯类别标签
        /// </summary>
        /// <param name="Array">
        /// num	显示条数	
        /// RowsNum	每行显示的条数	
        /// TitleClass	文字样式	
        /// </param>
        /// <returns></returns>
        public static string SY_NewsType(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,
            if (strContent.Length != 3) goto Err; //如果参数不够则跳出
            int Num = Convert.ToInt32(strContent[0].ToString());
            int RowsNum = Convert.ToInt32(strContent[1].ToString());
            string TitleClass = strContent[2].ToString();

            //临时字符串
            StringBuilder strWhere = new StringBuilder();
            string strSelect;
            //读取几条信息
            if (Num <= 0)
                strSelect = "top 1 ";
            else
                strSelect = " top " + Num + "*";
            strWhere.Append("where 1=1 and ParentID=0 ");
            DataTable NewsList = Function.GetDataTable(strSelect, strWhere.ToString(), "W_ConsultativeType");
            StringBuilder strBuilder = new StringBuilder();
            if (RowsNum <= 0) RowsNum = 1;
            if (NewsList.Rows.Count == 0)
                strBuilder.Append("暂无信息");
            else
            {
                strBuilder.Append("<table width='100%' border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
                for (int i = 0; i < NewsList.Rows.Count; i++)
                {
                    if (i == (Num - 1)) break;
                    strBuilder.Append("<a href=\"");
                    strBuilder.Append(@"{PB_WebURL}");
                    strBuilder.Append(@"News/Trade-");
                    strBuilder.Append(NewsList.Rows[i]["ID"].ToString());
                    strBuilder.Append(Base.BasePage.Config.Rewrite + "\"");
                    if (TitleClass.ToString() != "")
                    {
                        strBuilder.Append(" class=\"" + TitleClass.ToString() + "\"");
                    }
                    strBuilder.Append(@">");
                    strBuilder.Append(NewsList.Rows[i]["Name"].ToString());
                    strBuilder.Append(@"</a>");
                    if (((i + 1) % RowsNum) == 0)  //换行
                    {
                        if (i == (Num - 1) || i == NewsList.Rows.Count - 1)
                            strBuilder.Append(@"</td></tr>");
                        else
                            strBuilder.Append(@"</td></tr><tr><td>");
                    }
                    else
                        strBuilder.Append(@"</td><td>");
                }
            }
            strBuilder.Append(@"</table>");
            return strBuilder.ToString();

        Err:
            return Function.ErrInfo(0);
        }

        /// <summary>
        /// 资讯详细内容标签
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string DIY_NewsInfo(TSystemLable Array)
        {
            //初始化参数
            string strPage = "";
            int intID = 0;
            intID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]); //取得资讯ID
            if (intID <= 0) goto Err;
            strPage = HttpContext.Current.Request.QueryString["page"];  //获取分页值
            if (strPage == null) strPage = "1";
            string strContent = Array.Content.ToString();

            TConsultative tNews = new RConsultative().GateItem(intID);
            string[] strAtttibute = Function.GetAttribute(strContent);   // 查询属性
            StringBuilder strBuilde = new StringBuilder();
            //System.Collections.Hashtable HashInfo = Function.SeparatePages(tNews.Detail.ToString(), strPage, 1000, "detail-" + intID);
            System.Collections.Hashtable HashInfo = Function.SeparatePages(tNews.Detail.ToString(), strPage, "detail-" + intID);
            strBuilde.Append(HashInfo["content"].ToString());
            strBuilde.Append(@"</p><p class=""info_page"">");
            strBuilde.Append(HashInfo["pagetxt"].ToString());
            strBuilde.Append(@"");
            if (strAtttibute.Length != 0)
            {
                for (int i = 0; i < strAtttibute.Length; i++)
                {
                    switch (strAtttibute[i].ToString())
                    {
                        case "{PR:WS_ID}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), tNews.ID.ToString());
                            break;
                        case "{PR:WS_Title}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), tNews.Title.ToString());
                            break;
                        case "{PR:WS_Picture}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), tNews.Picture.ToString());
                            break;
                        case "{PR:WS_AddDate}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), Base.Common.GetShortDate(tNews.AddDate.ToString()));
                            break;
                        case "{PR:WS_Origin}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), tNews.Origin.ToString());
                            break;
                        case "{PR:WS_Detail}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strBuilde.ToString());
                            break;
                        case "{PR:WS_Author}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), tNews.Author.ToString());
                            break;
                    }
                }
            }

            return strContent;

        Err:
            return Function.ErrInfo(1);
        }

        /// <summary>
        /// 资讯详细内容标签
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        private static string GetDetail(int ID)
        {
            //初始化参数
            string strPage = "";
            int intID = 0;
            intID = ID;
            if (intID <= 0) goto Err;
            strPage = HttpContext.Current.Request.QueryString["page"];  //获取分页值
            if (strPage == null) strPage = "1";
            TConsultative tNews = new RConsultative().GateItem(intID);
            StringBuilder strBuilde = new StringBuilder();
            System.Collections.Hashtable HashInfo = Function.SeparatePages(tNews.Detail.ToString(), strPage, 1000, "detail-" + intID);
            strBuilde.Append(HashInfo["content"].ToString());
            strBuilde.Append(@"<p>");
            strBuilde.Append(HashInfo["pagetxt"].ToString());
            strBuilde.Append(@"</p>");

            return strBuilde.ToString();

        Err:
            return Function.ErrInfo(1);
        }

        /// <summary>
        /// 相关新闻
        /// </summary>
        /// <param name="Array">
        /// Num	显示条数	
        /// RowsNum	每行显示几条	
        /// isType	是否显示类型[0不显示，1显示]	
        /// TitleLenght 标题字数	
        /// TitleClass	class	
        /// target	链接目标	
        /// isDate	是否显示日期[0不显示，1显示]	
        /// DateClass	日期样式	
        /// TypeID	信息类别ID，0为全部	
        /// NewsAttribute	文章属性[0为全部，1为推荐，2热点，3为固顶，4，其它]	
        /// </param>
        /// <returns></returns>
        public static string SY_RelatedNews(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 10) goto Err;
            int Num = Convert.ToInt32(strContent[0].ToString());
            int RowsNum = Convert.ToInt32(strContent[1].ToString());
            string isType = strContent[2].ToString();
            int TitleLenght = Convert.ToInt32(strContent[3].ToString());
            string TitleClass = strContent[4].ToString();
            string target = strContent[5].ToString();
            string isDate = strContent[6].ToString();
            string DateClass = strContent[7].ToString();
            int TypeID = Convert.ToInt32(strContent[8].ToString());
            string NewsAttribute = strContent[9].ToString();

            //临时字符串
            StringBuilder strWhere = new StringBuilder();
            string strSelect;
            //读取几条信息
            if (Num <= 0)
                strSelect = " top 1 ";
            else
                strSelect = " top " + Num + " *";

            //资讯类型 
            strWhere.Append("where 1=1");
            if (TypeID != 0)
            {
                if (TypeID < 0)
                {
                    if (HttpContext.Current.Request.QueryString["ID"] != "")
                    {
                        TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                        strWhere.Append("and TypeID = ");
                        strWhere.Append(TypeID);
                    }
                }
                else
                {
                    strWhere.Append("and TyepID = ");
                    strWhere.Append(TypeID);
                }
            }

            //资讯属性
            if (NewsAttribute != "")
            {
                strWhere.Append("and Attribute like '%");
                strWhere.Append(NewsAttribute);
                strWhere.Append("%' ");
            }
            StringBuilder strSQL = new StringBuilder();
            strSQL.Append("select");
            strSQL.Append(strSelect);
            strSQL.Append(" from ");
            strSQL.Append(" View_Cosultative_CosultativeType ");
            strSQL.Append(strWhere);

            strSQL.Append(" order by ID desc");
            DataTable NewsList = Function.GetDataTable(strSQL.ToString());  //取得资讯列表
            StringBuilder strBuilder = new StringBuilder();
            if (NewsList.Rows.Count == 0)
            {
                strBuilder.Append("暂无信息");
            }
            else
            {
                strBuilder.Append("<table><tr><td>");
                for (int i = 0; i < NewsList.Rows.Count; i++)
                {
                    if (i > Num - 1) break; //如果超过显示的条数则跳出。
                    if (isType == "1")
                    {
                        strBuilder.Append(@"[");
                        strBuilder.Append(@"<a href=");
                        strBuilder.Append(@"{PB_WebURL}");
                        strBuilder.Append(@"News/Trade-");
                        strBuilder.Append(NewsList.Rows[i]["TypeID"].ToString());
                        strBuilder.Append(Base.BasePage.Config.Rewrite);
                        strBuilder.Append(@">");
                        strBuilder.Append(NewsList.Rows[i]["Name"].ToString());
                        strBuilder.Append(@"</a>]");
                    }
                    strBuilder.Append(@"<a href='");
                    if (NewsList.Rows[i]["Detail"].ToString() != "")
                    {
                        strBuilder.Append(@"{PB_WebURL}");
                        strBuilder.Append(@"News/Detail-");
                        strBuilder.Append(NewsList.Rows[i]["ID"].ToString());
                        strBuilder.Append(Base.BasePage.Config.Rewrite);
                    }
                    else
                    {
                        strBuilder.Append(NewsList.Rows[i]["ChangeDirectionLink"].ToString());
                    }
                    strBuilder.Append(@"' class='");
                    strBuilder.Append(TitleClass);
                    strBuilder.Append(@"'>");
                    if (NewsList.Rows[i]["Title"].ToString().Length > TitleLenght)
                        strBuilder.Append(NewsList.Rows[i]["Title"].ToString().Substring(0, TitleLenght));
                    else
                        strBuilder.Append(NewsList.Rows[i]["Title"].ToString());
                    strBuilder.Append(@"</a>");
                    if (isDate == "1")
                    {
                        strBuilder.Append(NewsList.Rows[i]["AddDate"].ToString());

                    }
                    if (((i + 1) % RowsNum) == 0)  //换行
                    {
                        if (i == (Num - 1))
                            strBuilder.Append(@"</td></tr>");
                        else
                            strBuilder.Append(@"</td></tr><tr><td>");
                    }
                    else
                    {
                        strBuilder.Append(@"</td><td>");
                    }

                }
                strBuilder.Append(@"</table>");

            }
            return strBuilder.ToString();

        Err:
            return Function.ErrInfo(0);

        }

        /// <summary>
        /// 转换资讯详细页的私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_NewsDetail(string Restr, string str)
        {

            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int ID = 0;
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));
            TConsultative Items = new RConsultative().GateItem(ID);
            string StrSQL = "";
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Title);
                            break;
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Title.ToString());
                            break;
                        case "{PR_ADDDATE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Base.Common.GetShortDate(Items.AddDate.ToString()));
                            break;
                        case "{PR_ORIGIN}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Origin.ToString());
                            break;
                        case "{PR_AUTHOR}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Author.ToString());
                            break;
                        case "{PR_TYPE}":
                            Restr = Restr.Replace(strArray[i].ToString(), GetTypeStr(Items.TypeID.ToString()));
                            break;
                        case "{PR_POSITION}":

                            Restr = Restr.Replace(strArray[i].ToString(), " <a href=\"{PB_WEBurl}\" >首页</a> > " + GetTypeStr(Items.TypeID.ToString()) + " > " + Items.Title.ToString());
                            break;
                        case "{PR_DETAIL}":
                            Restr = Restr.Replace(strArray[i].ToString(), GetDetail(ID));
                            break;
                        case "{PR_RESTOREURL}":          //MATE
                            Restr = Restr.Replace(strArray[i].ToString(), "{PB_WEBURL}News/Restore-" + Items.ID + BasePage.Config.Rewrite);
                            break;

                        case "{PR_NEWSRESTORE}":          //IsComment
                            if (Items.IsComment.ToString().Equals("True"))
                                Restr = Restr.Replace(strArray[i].ToString(), NewsRestore());
                            else
                                Restr = Restr.Replace(strArray[i].ToString(), "");
                            break;
                        case "{PR_DIGG}":          //顶踩
                            Restr = Restr.Replace(strArray[i].ToString(), Digg(Items.ID));
                            break;
                        default:

                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return Restr;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        /// <param name="UID"></param>
        private static string Digg(int UID)
        {
            DataTable dt = Function.GetDataTable("CountUP,CountDown", " where id=" + UID.ToString(), "W_Consultative");
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("<div id=\"digg\">");
            //strBuilder.Append("<script src=\"http://192.168.0.131:8080/js/Common.js\" type=\"text/javascript\"></script>");
            strBuilder.Append("<div id=\"digg_left\"><ul><li id=\"CountUp\" class=\"disu\">" + dt.Rows[0]["CountUp"].ToString() + "</li><li id=\"up\" class=\"disa\" onclick=\"AjaxDigg('up'," + UID.ToString() + ")\">顶一下</li></ul></div>");
            strBuilder.Append("<div id=\"digg_right\"><ul><li id=\"CountDown\" class=\"disu\">" + dt.Rows[0]["CountDown"].ToString() + "</li><li id=\"down\" class=\"disa\" onclick=\" AjaxDigg('down'," + UID.ToString() + ")\">踩一下</li></ul></div>");
            strBuilder.Append(" </div>");
            return strBuilder.ToString();


        }

        /// <summary>
        /// 取得资讯类别
        /// </summary>
        /// <param name="intID"></param>
        /// <returns></returns>
        private static string GetTypeStr(string intID)
        {
            string strName = Function.GetOnlyDate("Name", " where id=" + intID, "W_ConsultativeType");
            return "<a href=\"trade-" + intID + Base.BasePage.Config.Rewrite + "\">" + strName + "</a>";
        }

        /// <summary>
        /// 转换资讯首页的私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_NewsIndex(string Restr, string str)
        {
            Restr = Restr.Replace("{PR_KEYWORD}", "资讯首页");
            return Restr;
        }

        /// <summary>
        /// 转换资讯分类页的私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_NewsTrade(string Restr, string str)
        {
            int ID = 0;
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (ID <= 0) goto Err;
            TConsultativeType Items = new RConsultativeType().GateItem(ID);
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name);
                            break; ;
                        case "{PR_POSITION}":
                            Restr = Restr.Replace(strArray[i].ToString(), " <a href=\"{PB_WEBurl}\" >{PB_WEBNAME}首页</a> > " + Items.Name);
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name);
                            break;
                        case "{PR_TYPEID}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.ID.ToString());
                            break;
                        default:
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        Err:
            return Function.ErrInfo(1);
        }

        /// <summary>
        /// 显示资讯评论格式
        /// </summary>
        /// <returns></returns>
        private static string NewsRestore()
        {
            string param = "";
            if (HttpContext.Current.Request.QueryString["ID"] != null)
                param = HttpContext.Current.Request.QueryString["ID"].ToString();
            string PathName = AppDomain.CurrentDomain.BaseDirectory.ToString() + "xml/NewsRestore.html";
            StringBuilder builder = new StringBuilder();
            string str = "";
            using (StreamReader reader = new StreamReader(PathName, Encoding.Default))
            {
                StringBuilder builder2 = new StringBuilder();
                builder2.Append(reader.ReadToEnd());
                reader.Close();
                str = builder2.ToString().Replace("{TypeID}", param);
            }
            return str;

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="Array"></param>
        /// <param name="strModule"></param>
        /// <returns></returns>
        public static string DIY_NewsList(TSystemLable Array, string strModule)
        {
            // 对标签使用条件进行检查
            // if (!strModule.Contains("Supply_Trade")) throw new Exception(Function.ErrInfo(2));

            string TypeID = "1";
            if (HttpContext.Current.Request.QueryString["ID"] != null && HttpContext.Current.Request.QueryString["ID"] != "")
            {
                if (Base.Common.CheckNum(HttpContext.Current.Request.QueryString["ID"]))
                {
                    TypeID = HttpContext.Current.Request.QueryString["ID"];
                }
            }
            string parentID = "";
            parentID = Function.GetOnlyDate("ParentID", " where ID=" + TypeID, "W_ConsultativeType");

            if (parentID == "0")
            {
                string str = Function.GetOnlyDate(" Count(*)", " where TypeID=" + TypeID, "W_Consultative");
                if (Convert.ToInt32(str) > 0)
                {

                    return notHasLast(TypeID, Array);
                }
                else
                {
                    return HasLast(TypeID, Array);
                }
            }
            else
            {
                return notHasLast(TypeID, Array);
            }

            //return "asdf";
        }

        /// <summary>
        /// 资讯分类页栏目页
        /// </summary>
        /// <param name="TypeID"></param>
        /// <returns></returns>
        protected static string HasLast(string TypeID, TSystemLable Array)
        {


            DataTable Li = Pagination.GetDataTable(" ParentID=" + Convert.ToInt32(TypeID), "W_ConsultativeType", 1, "ID", "ID,Name", 30, 1, 0);
            StringBuilder strBuilder = new StringBuilder();

            for (int i = 0; i < Li.Rows.Count; i++)
            {
                // 求购列表头部
                string strHead = "";
                strHead = Array.Head;
                strHead = strHead.Replace("{PR:WS_TypeName}", Li.Rows[i]["Name"].ToString()).Replace("{PR:WS_TypeUrl}", "Trade-" + Li.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                strBuilder.Append(strHead);

                string strWhere = " TypeID=" + Li.Rows[i]["ID"].ToString();
                string strTable = "W_Consultative inner join W_ConsultativeType on W_Consultative.TypeID=W_ConsultativeType.ID ";
                int OrderType = 1;
                string OrderField = "AddDate";
                string strSelect = " W_Consultative.ID,W_Consultative.AddDate,W_Consultative.Title, W_Consultative.TypeID,W_ConsultativeType.Name as TypeName";
                int PageSize = 10;
                int PageIndex = 1;
                int Count = 0;
                DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);
                string str = "";
                for (int j = 0; j < Lists.Rows.Count; j++)
                {
                    str = Array.Content;
                    str = str.Replace("{PR:WS_Title}", Lists.Rows[j]["Title"].ToString()).Replace("{PR:WS_TitleUrl}", "/News/Detail-" + Lists.Rows[j]["ID"].ToString() + Base.BasePage.Config.Rewrite).Replace("{PR:WS_AddDate}", DateTime.Parse(Lists.Rows[j]["AddDate"].ToString()).ToShortDateString());
                    strBuilder.Append(str);
                }
            }
            return strBuilder.ToString();

        }

        /// <summary>
        /// 资讯分类页列表页
        /// </summary>
        /// <param name="TypeID"></param>
        /// <returns></returns>
        protected static string notHasLast(string TypeID, TSystemLable Array)
        {
            string strWhere = " TypeID=" + TypeID;
            string strTable = "W_Consultative inner join W_ConsultativeType on W_Consultative.TypeID=W_ConsultativeType.ID ";
            int OrderType = 1;
            string OrderField = "AddDate";
            string strSelect = " W_Consultative.ID,W_Consultative.AddDate,W_Consultative.Title, W_Consultative.TypeID,W_ConsultativeType.Name as TypeName";
            int PageSize = 10;
            int PageIndex = 1;
            if (HttpContext.Current.Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(HttpContext.Current.Request.QueryString["Page"]);
            if (PageIndex < 1) PageIndex = 1;
            int Count = 0;

            DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);
            StringBuilder ReBuilder = new StringBuilder();

            if (Lists.Rows.Count < 0)
            {
                ReBuilder.Append("暂无此类产品");
            }
            else
            {
                string str = "";
                for (int j = 0; j < Lists.Rows.Count; j++)
                {
                    str = Array.Content;
                    str = str.Replace("{PR:WS_Title}", Lists.Rows[j]["Title"].ToString()).Replace("{PR:WS_TitleUrl}", "Detail-" + Lists.Rows[j]["ID"].ToString() + Base.BasePage.Config.Rewrite).Replace("{PR:WS_AddDate}", DateTime.Parse(Lists.Rows[j]["AddDate"].ToString()).ToShortDateString());
                    ReBuilder.Append(str);
                }
                // if (i > Num - 1) break; //如果超过显示的条数则跳出。
                // ReBuilder.Append(str);
                ReBuilder.Append(System.Environment.NewLine);
            }
            string strUrl = "/News/Trade-";
            if (PageIndex <= 0) PageIndex = 1;
            strUrl += TypeID + "-p";
            string Pages = Pagination.GoToPager(PageIndex, 10, strUrl, strWhere, "W_Consultative");
            ReBuilder.Append(Pages);
            return ReBuilder.ToString();
        }

        /// <summary>
        /// 资讯评论
        /// </summary>
        /// <param name="strID"></param>
        /// <returns></returns>
        private static string Restore(string strID)
        {
            DataTable Li = Pagination.GetDataTable(" ConsultativeID=" + strID, "W_ConsultativeRestore", 1, "AddDate", "*", 30, 1, 0);

            StringBuilder strBuilder = new StringBuilder();
            for (int i = 0; i < Li.Rows.Count; i++)
            {
                strBuilder.Append(" <div class=\"commenthead\"><span class=\"span_r\">");
                strBuilder.Append(Li.Rows[i]["AddDate"].ToString() + " 发表</span><strong>" + Li.Rows[i]["UserName"].ToString() + "</strong>");
                strBuilder.Append("</div>");
                strBuilder.Append("<div class=\"commenttext\">");
                if (Li.Rows[i]["Shield"].ToString().ToLower() == "false")
                {
                    strBuilder.Append(Li.Rows[i]["Detail"].ToString());
                }
                else
                {
                    strBuilder.Append("该信息已屏蔽");
                }
                strBuilder.Append(" </div> ");

            }
            return strBuilder.ToString();
        }

        /// <summary>
        /// 转换资讯详细页的私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_NewsRestore(string Restr, string str)
        {

            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int ID = 0;
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));
            TConsultative Items = new RConsultative().GateItem(ID);
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Title.ToString());
                            break;
                        case "{PR_DETAILURL}":
                            Restr = Restr.Replace(strArray[i].ToString(), "{PB_WEBURL}News/Detail-" + Items.ID.ToString() + Base.BasePage.Config.Rewrite);
                            break;
                        case "{PR_ADDDATE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Base.Common.GetShortDate(Items.AddDate.ToString()));
                            break;
                        case "{PR_RESTORE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Restore(ID.ToString()));
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }

        public static string SY_DiggList(TSystemLable Array, string strMode)
        {
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 4) throw new Exception(Function.ErrInfo(0));

            string strClass = strContent[2].ToString();
            int TitleLength = Convert.ToInt32(strContent[1].ToString());
            int Count = Convert.ToInt32(strContent[0].ToString());
            string target = strContent[3].ToString();

            string strTypeID = "";
            if (HttpContext.Current.Request.QueryString["id"] != null || HttpContext.Current.Request.QueryString["id"] != "")
            {
                strTypeID = HttpContext.Current.Request.QueryString["id"];
            }
            int PageSize = Count;
            string strWhere = "";
            if (strMode != "News_Trade")
            {
                strWhere = "1=1";
            }
            else
            {
                strWhere = " TypeID=" + strTypeID;
            }
            DataTable Li = Pagination.GetDataTable(strWhere, "W_Consultative", 1, "CountUp", "*", PageSize, 1, 0);

            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append(" <div class=\"" + strClass + "\"><ul>");

            for (int i = 0; i < Li.Rows.Count; i++)
            {
                strBuilder.Append("<li>");
                strBuilder.Append("<span>" + (i + 1) + "</span>");
                strBuilder.Append("<a href=\"{PB_WebUrl}News/Detail-" + Li.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite + "\" target=\"" + target + "\">" + Function.GetString(Li.Rows[i]["Title"].ToString(), TitleLength) + "</a></li>");
            }
            strBuilder.Append("</ul></div>");
            return strBuilder.ToString();
        }

        /// <summary>
        /// SY_NewsList(string Array) 资讯列表(xjz)
        /// </summary>
        /// <param name="Array">
        /// ModelType-----(标签模板)----[String为文字,Image为图文]
        /// Num-----------(显示条数)----[int,默认为12条]
        /// TitleLength---(标题长度)----[int,默认显示全部]
        /// DateClass-----(日期格式)----[string]
        /// NewsType------(信息类型)----[all为全部,type为类型且要取得子类型,auto为自动绑定,other为内容页相关信息]
        /// Attribute-----(文章属性)----[IsRecommend为推荐,IsTop为头条,IsSlide为幻灯片,IsComment为允许评论]
        /// Sort----------(排序方式)----[以XX-asc或xx-desc格式出现,用空格替换'-']
        /// IsPagination--(是否分页)----[1启用,0不启用]
        /// ThisPage------(当前页样式)--[Class="XXX"]
        /// OtherPage-----(其它页样式)--[Class="XXX"]
        /// </param>
        /// <returns></returns>
        public static string SY_NewsList(TSystemLable Array)
        {
            #region   |--分解参数--|
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });
            //初始化参数,如果参数不够则跳出
            if (strContent.Length > 12 || strContent.Length < 11)
                throw new Exception(Function.ErrInfo(0));

            string ModelType = strContent[0];                     //标签模板
            int Num = 12;                                         //显示条数
            if (GetRequest.isNum(strContent[1]))
                Num = int.Parse(strContent[1]);
            int TitleLength = 0;                                  //标题长度
            if (GetRequest.isNum(strContent[2]))
                TitleLength = int.Parse(strContent[2]);
            string DateClass = strContent[3];                     //日期格式
            string NewsType = "";                                 //信息类型
            string[] strType = strContent[4].Split(',');
            if (!(strType[0].Equals("type")))
                NewsType = strType[0];
            else if (strType.Length != 3)
                NewsType = strType[1];
            else if (strType.Length == 3)
                NewsType = strType[2];
            else
                NewsType = strType[0];
            string Attribute = strContent[5];                     //文章属性
            string Sort = strContent[6];                          //排序方式
            int OrderType = 1;
            if (Sort.Contains("asc"))
                OrderType = 0;
            Sort = Sort.Replace("-asc", "");
            Sort = Sort.Replace("-desc", "");
            int IsPagination = int.Parse(strContent[7]);          //启用分页
            string ThisPage = strContent[8];                      //当前页样式
            string OtherPage = strContent[9];                    //其它页样式
            int ContentLength = 20;
            if (strContent.Length == 12)
            {
                if (GetRequest.isNum(strContent[10]))
                    ContentLength = Int32.Parse(strContent[10]);
            }
            #endregion

            #region   |--取得数据--|
            StringBuilder strWhere = new StringBuilder();
            strWhere.Append(" [W_ConsultativeType].ID=[W_Consultative].TypeID ");
            string strSelect = " [W_Consultative].ID,W_ConsultativeType.Name,W_Consultative.Title,W_Consultative.Picture,W_Consultative.AddDate";
            strSelect += ",W_Consultative.Reading,W_Consultative.Author,W_Consultative.Origin,W_Consultative.ClickCount,W_Consultative.TypeID";
            string Table = " [W_Consultative],[W_ConsultativeType] ";
            int ID = 0; //(分类页表示类别ID,详细页表示资讯ID)
            if (NewsType == "auto" || NewsType == "other")
            {
                if (GetRequest.CheckQueryStringisInt("ID"))
                    ID = int.Parse(HttpContext.Current.Request.QueryString["ID"]);
            }
            if (NewsType == "auto" && ID != 0)
                strWhere.Append(" AND ([W_Consultative].TypeID=" + ID + " OR [W_ConsultativeType].ParentID=" + ID + ") ");
            else if (NewsType == "other")
                strWhere.Append(" AND [W_Consultative].KeyWord LIKE '%'+(SELECT [KeyWord] FROM [W_Consultative] WHERE [W_Consultative].ID="+ID+")+'%' AND [W_Consultative].ID!=" + ID + " ");
            else if (NewsType == "all")
                strWhere.Append("");
            else if (GetRequest.isNum(NewsType))
                strWhere.Append(" AND ([W_Consultative].TypeID=" + NewsType + " OR [W_ConsultativeType].ParentID=" + NewsType + ") ");
            string[] lisNew = Attribute.Split(new char[] { ',' });
            if (lisNew[0] == "1")
                strWhere.Append(" AND IsRecommend=1 ");
            else if (lisNew[1] == "1")
                strWhere.Append(" AND IsTop=1 ");
            else if (lisNew[2] == "1")
                strWhere.Append(" AND IsHotspot=1 ");
            else if (lisNew[3] == "1")
                strWhere.Append(" AND IsComment=1");
            strWhere.Append(" and Picture<>'../../Images/System/wutu.gif' and Picture<>''");
            Sort = " [W_Consultative]." + Sort;
            int Page = 1;
            if (IsPagination == 1)
            {
                if (GetRequest.CheckQueryStringisInt("Page"))
                    Page = int.Parse(HttpContext.Current.Request.QueryString["Page"]);
            }
            String Title = "";
            if (HttpContext.Current.Request.QueryString["Title"] != null && HttpContext.Current.Request.QueryString["Title"] != "")
            {
                Title = HttpContext.Current.Request.QueryString["Title"];
                strWhere.Append(" AND [W_Consultative].Title LIKE'%" + Title + "%' ");
            }
            String DateLine = "";
            if (HttpContext.Current.Request.QueryString["Dateline"] != null && HttpContext.Current.Request.QueryString["Dateline"] != "")
            {
                DateLine = HttpContext.Current.Request.QueryString["Dateline"]; //默认全部日期
                strWhere.Append(" AND DATEDIFF(day,[W_Consultative].AddDate ,getdate())<=" + DateLine);
            }
            #endregion

            #region  |--处理数据--|          
            DataTable NewsList = Pagination.GetDataTable(strWhere.ToString(), Table, OrderType, Sort, strSelect, Num, Page, 0);
            // 定义全局变量，最后返回
            StringBuilder ReBulider = new StringBuilder();
            string[,] strAtttibute = Function.GetAttribute(Array.Content, 8);   // 查询属性
            if (NewsList.Rows.Count <= 0)
                ReBulider.Append("暂无资讯信息.");
            else
            {
                ReBulider.Append(Array.Head);
                for (int i = 0; i < NewsList.Rows.Count; i++)
                {
                    string Temp = Array.Content;
                    for (int j = 0; j < strAtttibute.Length / 2; j++)
                    {
                        if (strAtttibute[j, 0] == null)
                            break;
                        int k = int.Parse(strAtttibute[j, 0]);
                        string Name = strAtttibute[j, 1];
                        string Value = "";
                        if (NewsList.Rows[i][Name] != null)
                            Value = NewsList.Rows[i][Name].ToString();
                        if (Value != "")
                        {
                            if (Name.Equals("Picture"))
                                Value = Function.ProcessImageUrl(Value);
                            else if (Name.Equals("AddDate"))
                                Value = DateTime.Parse(Value.ToString()).ToString(DateClass);
                            else if (Name.Equals("Title"))
                                Value = Function.GetString(Value, TitleLength);
                            else if (Name.Equals("Reading"))
                                Value = Function.GetString(Value, ContentLength);
                        }
                        if (k != 0 && Value != "")
                            Temp = Temp.Replace("{PR:WS_" + Name + "(" + k + ")}", Function.GetString(Value, k));
                        else
                            Temp = Temp.Replace("{PR:WS_" + Name + "}", Value);

                    }
                    ReBulider.Append(Temp);
                }
                ReBulider.Append(Array.Footer);
            }
            string strUrl = "{PB_WebURL}News/Trade";
            if (Page <= 0) Page = 1;
            if (NewsType == "all" || NewsType == "auto")
                if (ID != 0)
                    strUrl += "-" + ID;
            strUrl += "-p";
            string Pages = "";
            if (IsPagination == 1)
            {
                if (ThisPage.Equals("") || OtherPage.Equals(""))
                    Pages = Pagination.GoToPager(Page, Num, strUrl, strWhere.ToString(), Table);
                else
                    Pages = Pagination.GoToPager(Page, Num, strUrl, strWhere.ToString(), Table, ThisPage, OtherPage);
                ReBulider.Append(Pages);
            }
            #endregion

            return ReBulider.ToString();
        }

        /// <summary>
        /// 资讯详细内容标签
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string SY_NewsInfo(TSystemLable Array)
        {
            #region   |--分解参数--|
            string DateClass = Array.Info;
            string strPage = "";
            int ID = 0;
            if (GetRequest.CheckQueryStringisInt("ID"))                  //取得资讯ID
                ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (ID <= 0)
                throw new Exception(Function.ErrInfo(0));
            strPage = HttpContext.Current.Request.QueryString["page"];  //获取分页值
            if (strPage == null) strPage = "1";
            #endregion

            #region   |--取得数据--|
            StringBuilder strSQL = new StringBuilder();
            strSQL.Append("SELECT [W_Consultative].ID,[W_Consultative].TypeID,[W_Consultative].Title,[W_ConsultativeType].Name");
            strSQL.Append(",W_Consultative.Picture,W_Consultative.AddDate,[W_Consultative].IsTop,[W_Consultative].IsRecommend");
            strSQL.Append(",[W_Consultative].IsHotspot,[W_Consultative].IsComment,W_Consultative.Author,W_Consultative.Origin");
            strSQL.Append(",(select Count(*) from [W_ConsultativeRestore] where ConsultativeID=" + ID + ") as CommentCount");
            strSQL.Append(",[W_Consultative].ChangeDirectionLink,[W_Consultative].Detail ");
            strSQL.Append("FROM [W_Consultative],[W_ConsultativeType] ");
            strSQL.Append("WHERE [W_ConsultativeType].ID=[W_Consultative].TypeID AND [W_Consultative].ID=" + ID);
            DataTable NewsInfo = Function.GetDataTable(strSQL.ToString());
            #endregion

            #region   |--处理数据--|
            StringBuilder strBuilde = new StringBuilder();
            if (NewsInfo.Rows.Count <= 0)
                return "不存在该资讯.";
            string strContent = Array.Content;
            string[] strAtttibute = Function.GetAttribute(strContent);   // 查询属性
            System.Collections.Hashtable HashInfo = Function.SeparatePages(NewsInfo.Rows[0]["Detail"].ToString(), strPage, "detail-" + ID);
            strBuilde.Append(HashInfo["content"].ToString());
            strBuilde.Append(@"</p><p class=""info_page"">");
            strBuilde.Append(HashInfo["pagetxt"].ToString());
            strBuilde.Append(@"");
            if (strAtttibute.Length != 0)
            {
                for (int i = 0; i < strAtttibute.Length; i++)
                {
                    string Label = strAtttibute[i].ToUpper();
                    switch (Label)
                    {
                        case "{PR:WS_ID}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), NewsInfo.Rows[0]["ID"].ToString());
                            break;
                        case "{PR:WS_TYPEID}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), NewsInfo.Rows[0]["TypeID"].ToString());
                            break;
                        case "{PR:WS_TITLE}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), NewsInfo.Rows[0]["Title"].ToString());
                            break;
                        case "{PR:WS_NAME}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), NewsInfo.Rows[0]["Name"].ToString());
                            break;
                        case "{PR:WS_PICTURE}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), Function.ProcessImageUrl(NewsInfo.Rows[0]["Picture"].ToString()));
                            break;
                        case "{PR:WS_ADDDATE}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), DateTime.Parse(NewsInfo.Rows[0]["AddDate"].ToString()).ToString(DateClass));
                            break;
                        case "{PR:WS_ATTRIBUTE}":
                            string AT = "";
                            if (NewsInfo.Rows[0]["IsTop"].ToString().Equals("True"))
                                AT += "<font color=\"red\">顶</font> ";
                            if (NewsInfo.Rows[0]["IsRecommend"].ToString().Equals("True"))
                                AT += "<font color=\"green\">荐</font> ";
                            if (NewsInfo.Rows[0]["IsHotspot"].ToString().Equals("True"))
                                AT += "<font color=\"purple\">幻</font> ";
                            if (NewsInfo.Rows[0]["IsComment"].ToString().Equals("True"))
                                AT += "<font color=\"blue\">评</font> ";
                            strContent = strContent.Replace(strAtttibute[i].ToString(), AT);
                            break;
                        case "{PR:WS_AUTHOR}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), NewsInfo.Rows[0]["Author"].ToString());
                            break;
                        case "{PR:WS_ORIGIN}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), NewsInfo.Rows[0]["Origin"].ToString());
                            break;
                        case "{PR:WS_COMMENTCOUNT}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), NewsInfo.Rows[0]["CommentCount"].ToString());
                            break;
                        case "{PR:WS_CHANGEDIRECTIONLINK}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), NewsInfo.Rows[0]["ChangeDirectionLink"].ToString());
                            break;
                        case "{PR:WS_DETAIL}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strBuilde.ToString());
                            break;
                    }
                }
            }
            #endregion

            return strContent;
        }

        /// <summary>
        /// 资讯类别标签
        /// </summary>
        /// <param name="Array">
        /// TypeModel 所属分类		
        /// num	显示条数
        /// </param>
        /// <returns></returns>
        public static string SY_NewsTypeList(TSystemLable Array)
        {
            #region   |--分解参数--|
            string[] strLabel;
            strLabel = Array.Info.Split(new char[] { '|' });

            //初始化参数,
            string TypeModel = strLabel[0];
            int Num = 12;
            if (GetRequest.isNum(strLabel[1]))
                Num = Convert.ToInt32(strLabel[1]);
            int ParentID = 0;
            if (GetRequest.CheckQueryStringisInt("ID"))
                ParentID = int.Parse(HttpContext.Current.Request.QueryString["ID"]);
            #endregion

            #region   |--取得数据--|
            //临时字符串
            string strWhere = " WHERE 1=1 ";
            string strSelect = "";
            //读取几条信息
            if (Num <= 0)
                strSelect = "top 1 ";
            else
                strSelect = " top " + Num + " ID,Name ";
            if (TypeModel.Equals("auto"))
            {
                if (ParentID == 0)
                    strWhere += (" AND ParentID=0");
                else
                    strWhere += (" AND ParentID=" + ParentID);
            }
            else
                strWhere += " AND ParentID=" + TypeModel;
            DataTable TypeList = Function.GetDataTable(strSelect, strWhere, "W_ConsultativeType");
            #endregion

            #region   |--处理数据--|
            StringBuilder strBuilder = new StringBuilder();
            if (TypeList.Rows.Count == 0 && TypeModel.Equals("auto"))                /*若2级分类下无数据,则重新加载一级分类*/
                TypeList = Function.GetDataTable(strSelect, " WHERE ParentID=0 ", "W_ConsultativeType");
            else if (TypeList.Rows.Count == 0)
                TypeList = Function.GetDataTable(strSelect, " WHERE ID=" + TypeModel, "W_ConsultativeType");
            string[] strAtttibute = Function.GetAttribute(Array.Content);   // 查询属性
            if (TypeList.Rows.Count != 0)
            {
                strBuilder.Append(Array.Head);
                for (int i = 0; i < TypeList.Rows.Count; i++)
                {
                    string strContent = Array.Content;
                    for (int j = 0; j < strAtttibute.Length; j++)
                    {
                        string Label = strAtttibute[j].ToUpper();
                        switch (Label)
                        {
                            case "{PR:WS_NAME}":
                                strContent = strContent.Replace(strAtttibute[j].ToString(), TypeList.Rows[i]["Name"].ToString());
                                break;
                            case "{PR:WS_TYPEID}":
                                strContent = strContent.Replace(strAtttibute[j].ToString(), TypeList.Rows[i]["ID"].ToString());
                                break;
                        }
                    }
                    strBuilder.Append(strContent);
                }
                strBuilder.Append(Array.Footer);
            }
            #endregion

            return strBuilder.ToString();
        }
    }
}