﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;
using System.Text;
namespace nspLable.Function
{
    /// <summary>
    /// 分页类
    /// </summary>
    public class Pagination
    {


        /// <summary>
        /// 分页数据库操作函数
        /// </summary>
        /// <param name="strwhere">查询条件(注意: 不要加where)</param>
        /// <param name="tblName">表名</param>
        /// <param name="OrderType">设置排序类型,非 0 值则降序</param>
        /// <param name="fldName">排序的字段名</param>
        /// <param name="strGetFields">需要返回的列</param>
        /// <param name="PageSize">页尺寸</param>
        /// <param name="PageIndex">页码</param>
        /// <param name="doCount">返回记录总数,非 0 值则返回</param>
        /// <returns>返回一个表</returns>
        public static DataTable GetDataTable(string strwhere, string tblName, int OrderType, string fldName, string strGetFields, int PageSize, int PageIndex, int doCount)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", strwhere), //查询条件(注意: 不要加where)
                new SqlParameter("@tblName", tblName), //表名
                new SqlParameter("@OrderType", OrderType), //设置排序类型,非 0 值则降序
                new SqlParameter("@fldName", fldName),   //排序的字段名
                new SqlParameter("@strGetFields", strGetFields), //需要返回的列
                new SqlParameter("@PageSize", PageSize),     //页尺寸
                new SqlParameter("@PageIndex", PageIndex),     //页码 
                new SqlParameter("@doCount", doCount)     //返回记录总数,非 0 值则返回 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_Pagination", param);
        }

        /// <summary>
        /// 分页数据库操作函数
        /// </summary>
        /// <param name="strwhere">查询条件(注意: 不要加where)</param>
        /// <param name="tblName">表名</param>
        /// <param name="OrderType">设置排序类型,非 0 值则降序</param>
        /// <param name="fldName">排序的字段名</param>
        /// <param name="strGetFields">需要返回的列</param>
        /// <param name="PageSize">页尺寸</param>
        /// <param name="PageIndex">页码</param>
        /// <param name="doCount">返回记录总数,非 0 值则返回</param>
        /// <returns>返回一个表</returns>
        public static DataTable GetDataTable(string strwhere, string tblName, int OrderType, string fldName, string strGetFields, int PageSize, int PageIndex, int doCount,string KeyDate)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", strwhere), //查询条件(注意: 不要加where)
                new SqlParameter("@tblName", tblName), //表名
                new SqlParameter("@OrderType", OrderType), //设置排序类型,非 0 值则降序
                new SqlParameter("@fldName", fldName),   //排序的字段名
                new SqlParameter("@strGetFields", strGetFields), //需要返回的列
                new SqlParameter("@PageSize", PageSize),     //页尺寸
                new SqlParameter("@PageIndex", PageIndex),     //页码 
                new SqlParameter("@doCount", doCount),     //返回记录总数,非 0 值则返回 
                new SqlParameter("@KeyDate", KeyDate)     
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_Pagination", param);
        }

        /// <summary>
        /// 分页导航获取总页数
        /// </summary>
        /// <param name="strwhere">查询条件(注意: 不要加where)</param>
        /// <param name="tblName">表、视图</param>
        /// <returns>Total：字段名（总的记录数）</returns>
        public static DataTable GetDataTable(string strwhere, string tblName)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", strwhere), //查询条件(注意: 不要加where)
                new SqlParameter("@tblName", tblName), //表名
                new SqlParameter("@doCount", 1)     //返回记录总数,非 0 值则返回 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_Pagination", param);
        }


        /// <summary>
        /// 分页函数
        /// </summary>
        /// <param name="page">要连接的页</param>
        /// <param name="pageSize">每页显示的记录数</param>
        /// <param name="Count">总的记录数</param>
        /// <param name="Url">链接路径</param>
        /// <param name="strWhere">查询条件</param>
        /// <param name="strWhere">要查询的表、视图</param>
        /// <returns>返回分页导航栏</returns>
        public static string GoToPager(int page, int pageSize, string Url, string strWhere, string tblName)
        {
            if (tblName == null) goto Err;
            DataTable tb = GetDataTable(strWhere, tblName);
            int Count = Convert.ToInt32(tb.Rows[0]["Total"]);  //取得总的记录数
            StringBuilder strHtml = new StringBuilder(); 
            int prevPage = page - 1;
            int nextPage = page + 1;
            int startPage;
            int pageCount = (int)Math.Ceiling((double)Count / pageSize);
            //strHtml.Append(@"<span style='float:left'>页码：");
            //strHtml.Append(page);
            //strHtml.Append(@"/");
            //strHtml.Append(pageCount);
            //strHtml.Append(@"&nbsp;总记录：");
            //strHtml.Append(Count);
            //strHtml.Append(@"</span>  ");
            if (pageCount <= 1)
            {
                return "";
            }
            strHtml.Append(@"  <div class='page_tion' style='float:left'><ul><li class='pages'>");
            if (prevPage < 1)
            {
                strHtml.Append("<span>首页&nbsp;</span>");
                strHtml.Append("<span>上一页&nbsp;</span>");
            }
            else
            {
                strHtml.Append(@"<span><a href='" + Url + "1"+Base.BasePage.Config.Rewrite+"'>首页</a>&nbsp;</span>");
                strHtml.Append(@"<span><a href='" + Url + prevPage + Base.BasePage.Config.Rewrite + "'>上一页</a>&nbsp;</span>");
            }
            if (page % 10 == 0)
            {
                startPage = page - 9;
            }
            else
            {
                startPage = page - page % 10 + 1;
            }
            if (startPage > 10)
            {
                strHtml.Append(@"<span><a href='");
                strHtml.Append(Url);
                strHtml.Append(startPage - 1 + Base.BasePage.Config.Rewrite);
                strHtml.Append(@"'>...</a></span>");
            }
            for (int i = startPage; i < startPage + 10; i++)
            {
                if (i > pageCount) break;
                if (i == page)
                {
                    strHtml.Append(@"<span class=""page_b"">" + i + "</span>");
                }
                else
                {
                    strHtml.Append(@"<span> <a href='" + Url + i + Base.BasePage.Config.Rewrite + "'>" + i + "</a> </span>");
                }
            }
            if (pageCount >= startPage + 10) strHtml.Append(@"<span><a href='" + Url + (startPage + 10) + Base.BasePage.Config.Rewrite + "'>...</a></span>");
            if (nextPage > pageCount)
            {
                strHtml.Append(@"<span>&nbsp;下一页&nbsp;</span>");
                strHtml.Append( @"<span>末页&nbsp;</span>");
            }
            else
            {
                strHtml.Append(@"<span>&nbsp;<a href='" + Url + nextPage + Base.BasePage.Config.Rewrite + "'>下一页</a>&nbsp;</span>");
                strHtml.Append(@"<span><a href='" + Url + pageCount + Base.BasePage.Config.Rewrite + "'>末页</a>&nbsp;</span>");
            }


            strHtml.Append(@"</li></ul></div>");
            return strHtml.ToString();

        Err:
            return "缺少数据表或视图";
        }

        /// <summary>
        /// 分页函数
        /// </summary>
        /// <param name="page">要连接的页</param>
        /// <param name="pageSize">每页显示的记录数</param>
        /// <param name="Count">总的记录数</param>
        /// <param name="Url">链接路径</param>
        /// <param name="strWhere">查询条件</param>
        /// <param name="strWhere">要查询的表、视图</param>
        /// <returns>返回分页导航栏</returns>
        public static string GoToPager(int page, int pageSize, string Url, string strWhere, string tblName,int k)
        {
            if (tblName == null) goto Err;
            DataTable tb = GetDataTable(strWhere, tblName);
            int Count = Convert.ToInt32(tb.Rows[0]["Total"]);  //取得总的记录数
            StringBuilder strHtml = new StringBuilder();
            int prevPage = page - 1;
            int nextPage = page + 1;
            int startPage;
            int pageCount = (int)Math.Ceiling((double)Count / pageSize);
            //strHtml.Append(@"<span style='float:left'>页码：");
            //strHtml.Append(page);
            //strHtml.Append(@"/");
            //strHtml.Append(pageCount);
            //strHtml.Append(@"&nbsp;总记录：");
            //strHtml.Append(Count);
            //strHtml.Append(@"</span>  ");
            if (pageCount <= 1)
            {
                return "";
            }
            strHtml.Append(@"  <div class='page_tion' style='float:left'><ul><li class='pages'>");
            if (prevPage < 1)
            {
                strHtml.Append("<span>首页&nbsp;</span>");
                strHtml.Append("<span>上一页&nbsp;</span>");
            }
            else
            {
                strHtml.Append(@"<span><a href='" + Url + "1"  + "'>首页</a>&nbsp;</span>");
                strHtml.Append(@"<span><a href='" + Url + prevPage  + "'>上一页</a>&nbsp;</span>");
            }
            if (page % 10 == 0)
            {
                startPage = page - 9;
            }
            else
            {
                startPage = page - page % 10 + 1;
            }
            if (startPage > 10)
            {
                strHtml.Append(@"<span><a href='");
                strHtml.Append(Url);
                strHtml.Append(startPage - 1 );
                strHtml.Append(@"'>...</a></span>");
            }
            for (int i = startPage; i < startPage + 10; i++)
            {
                if (i > pageCount) break;
                if (i == page)
                {
                    strHtml.Append(@"<span class=""page_b"">" + i + "</span>");
                }
                else
                {
                    strHtml.Append(@"<span> <a href='" + Url + i  + "'>" + i + "</a> </span>");
                }
            }
            if (pageCount >= startPage + 10) strHtml.Append(@"<span><a href='" + Url + (startPage + 10) +  "'>...</a></span>");
            if (nextPage > pageCount)
            {
                strHtml.Append(@"<span>&nbsp;下一页&nbsp;</span>");
                strHtml.Append(@"<span>末页&nbsp;</span>");
            }
            else
            {
                strHtml.Append(@"<span>&nbsp;<a href='" + Url + nextPage + "'>下一页</a>&nbsp;</span>");
                strHtml.Append(@"<span><a href='" + Url + pageCount  + "'>末页</a>&nbsp;</span>");
            }


            strHtml.Append(@"</li></ul></div>");
            return strHtml.ToString();

        Err:
            return "缺少数据表或视图";
        }

        /// <summary>
        /// 分页函数
        /// </summary>
        /// <param name="page">要连接的页</param>
        /// <param name="pageSize">每页显示的记录数</param>
        /// <param name="Count">总的记录数</param>
        /// <param name="Url">链接路径</param>
        /// <param name="strWhere">查询条件</param>
        /// <param name="strWhere">要查询的表、视图</param>
        /// <param name="ThisPageClass">本页样式</param>
        /// <param name="OtherPageClass">其它页样式</param>
        /// <returns>返回分页导航栏</returns>
        public static string GoToPager(int page, int pageSize, string Url, string strWhere, string tblName,string ThisPageClass,string OtherPageClass)
        {
            if (tblName == null) goto Err;
            DataTable tb = GetDataTable(strWhere, tblName);
            int Count = Convert.ToInt32(tb.Rows[0]["Total"]);  //取得总的记录数
            StringBuilder strHtml = new StringBuilder();
            int prevPage = page - 1;
            int nextPage = page + 1;
            int startPage;
            int pageCount = (int)Math.Ceiling((double)Count / pageSize);
            if (pageCount <= 1)
            {
                return "";
            }
            strHtml.Append(@"  <div class='page_tion' style='float:left'><ul><li class='pages'>");
            if (prevPage < 1)
            {
                strHtml.Append("<span>首页&nbsp;</span>");
                strHtml.Append("<span>上一页&nbsp;</span>");
            }
            else
            {
                strHtml.Append(@"<span><a href='" + Url + "1" + Base.BasePage.Config.Rewrite + "'>首页</a>&nbsp;</span>");
                strHtml.Append(@"<span><a href='" + Url + prevPage + Base.BasePage.Config.Rewrite + "'>上一页</a>&nbsp;</span>");
            }
            if (page % 10 == 0)
            {
                startPage = page - 9;
            }
            else
            {
                startPage = page - page % 10 + 1;
            }
            if (startPage > 10)
            {
                strHtml.Append(@"<span><a href='");
                strHtml.Append(Url);
                strHtml.Append(startPage - 1 + Base.BasePage.Config.Rewrite);
                strHtml.Append(@"'>...</a></span>");
            }
            for (int i = startPage; i < startPage + 10; i++)
            {
                if (i > pageCount) break;
                if (i == page)
                {
                    strHtml.Append("<span Class=\""+ThisPageClass+"\">" + i + "</span>");
                }
                else
                {
                    strHtml.Append("<span Class=\""+OtherPageClass+"\"> <a href='" + Url + i + Base.BasePage.Config.Rewrite + "'>" + i + "</a> </span>");
                }
            }
            if (pageCount >= startPage + 10) strHtml.Append(@"<span><a href='" + Url + (startPage + 10) + Base.BasePage.Config.Rewrite + "'>...</a></span>");
            if (nextPage > pageCount)
            {
                strHtml.Append(@"<span>&nbsp;下一页&nbsp;</span>");
                strHtml.Append(@"<span>末页&nbsp;</span>");
            }
            else
            {
                strHtml.Append(@"<span>&nbsp;<a href='" + Url + nextPage + Base.BasePage.Config.Rewrite + "'>下一页</a>&nbsp;</span>");
                strHtml.Append(@"<span><a href='" + Url + pageCount + Base.BasePage.Config.Rewrite + "'>末页</a>&nbsp;</span>");
            }


            strHtml.Append(@"</li></ul></div>");
            return strHtml.ToString();

        Err:
            return "缺少数据表或视图";
        }


    }

}