﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Data.SqlClient;
using nspLable.Manage;
using Product;
using nspLable.Function;
using UserInfo;
using Area;
using VipGrade;
using Base;
using System.Text.RegularExpressions;
namespace nspLable.Function.Systems
{
    /// <summary>
    /// SupplyLable 的摘要说明
    /// </summary>
    public class clsProductLable : nspLable.Function.Systems.systemic
    {


        /// <summary>
        /// 产品图文标签
        /// </summary>
        /// <param name="Array（13）">
        /// Num	        信息列表数目	
        /// RowsNum	    每行的列数	
        /// ProAttribute	信息列表属性	
        /// WhitchType	列表显示样式(0:只有图片，1: 图文)
        /// TypeID      类型（0：供应，1：求购）
        /// IndType     行业类别
        /// OrderBy	    排序方式（0：ID升序；1：ID降序；2：时间升序；3：时间降序）	
        /// PicHeight	图片宽度	
        /// PicWidth	图片高度	
        /// PicClass	图片样式	
        /// TitleSize	标题最多字符数	
        /// TitleClass	标题样式	
        /// Target---（链接目标）
        /// <returns></returns>
        public static string SY_Productlist_Pic(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 13) return Function.ErrInfo(0);

            int Num = 0;
            int RowsNum = 0;
            int WhichType = 0;
            int TypeID = 0;
            int OrderBy = 0;
            int PicWidth = 0;
            int PicHight = 0;
            int TitleSize = 0;
            if (strContent[0].ToString().Trim() != "") Num = Convert.ToInt32(strContent[0].ToString());
            if (strContent[1].ToString().Trim() != "") RowsNum = Convert.ToInt32(strContent[1].ToString());
            string ProAttribute = strContent[2].ToString();
            if (strContent[3].ToString().Trim() != "") WhichType = Convert.ToInt32(strContent[3].ToString());
            if (strContent[4].ToString().Trim() != "") TypeID = Convert.ToInt32(strContent[4].ToString());
            string IndType = strContent[5].ToString();
            if (strContent[6].ToString().Trim() != "") OrderBy = Convert.ToInt32(strContent[6].ToString());
            if (strContent[7].ToString().Trim() != "") PicWidth = Convert.ToInt32(strContent[7].ToString());
            if (strContent[8].ToString().Trim() != "") PicHight = Convert.ToInt32(strContent[8].ToString());
            string PicClass = strContent[9].ToString();
            if (strContent[10].ToString().Trim() != "") TitleSize = Convert.ToInt32(strContent[10].ToString());
            string TitleClass = strContent[11].ToString();
            string Target = strContent[12].ToString();

            //需要取得的数据
            string strSelect;
            //读取几条信息
            if (Num <= 0)
                strSelect = "top 1  ID,Name,Thumbnail";
            else
                strSelect = " top " + Num + " ID,Name,Thumbnail ";


            //要查询的表、视图、存储过程
            string strTableName = "";
            if (TypeID < 0) TypeID = 0;
            //显示供应还是求购           
            if (TypeID == 1)
                strTableName = "C_Purchase";
            else
                strTableName = "C_Supply";


            //查询条件
            String strWhere = "where Verify=1";
            //所属类型 
            if (IndType.ToString().Length > 0 && IndType != "0")
            {
                //strWhere.Append("and IndType like %");
                //strWhere.Append(IndType);
                //strWhere.Append("% ");
                strWhere += " and patindex('%," + IndType + ",%' , ','+IndType+',')>0 ";
            }
            // 产品属性
            if (ProAttribute != "")
            {
                if (ProAttribute == "0")
                {
                    strWhere += "and Recommend = 1 ";
                }
                else
                {
                    strWhere += "and Recommend = 0 ";
                }

            }

            // 排序方式
            string strOrder = "";
            if (OrderBy < 0) OrderBy = 0;
            switch (OrderBy)
            {
                case 0:
                    strOrder = "order by ID desc";
                    break;
                case 1:
                    strOrder = "order by ID asc";
                    break;
                case 2:
                    strOrder = "order by AddDate asc";
                    break;
                case 3:
                    strOrder = "order by AddDate desc";
                    break;

            }
            //获取数据表
            DataTable ProductList = Function.GetDataTable(strSelect, strWhere, strTableName, strOrder);
            StringBuilder strBuilder = new StringBuilder();
            if (ProductList.Rows.Count <= 0) return "没有相关产品";
            strBuilder.Append("<table width='100%' border='0' cellspacing='0' cellspadding='0'><tr><td>");
            for (int i = 0; i < ProductList.Rows.Count; i++)
            {
                if (i > Num - 1) break; //如果超过显示的条数则跳出。
                switch (WhichType)
                {
                    case 0:  //只显示图片
                        strBuilder.Append(@"<table  border='0' cellspacing='0' cellspadding='0'><tr><td>");
                        if (TypeID == 0)
                            strBuilder.Append(@"<a href='{PB_WebURL}Supply/Detail-");
                        else
                            strBuilder.Append(@"<a href='{PB_WebURL}Purchase/Detail-");
                        strBuilder.Append(ProductList.Rows[i]["ID"].ToString());
                        strBuilder.Append(BasePage.Config.Rewrite);
                        strBuilder.Append(@" ' Target='");
                        strBuilder.Append(Target);
                        strBuilder.Append(@"'>");
                        strBuilder.Append("<img width='");
                        strBuilder.Append(PicWidth);
                        strBuilder.Append(@"' height='");
                        strBuilder.Append(PicHight);
                        if (PicClass != "" || PicClass != null)
                        {
                            strBuilder.Append(@"' class='");
                            strBuilder.Append(PicClass);
                            strBuilder.Append(@"'");
                        }
                        strBuilder.Append(" src='");
                        strBuilder.Append(Function.ProcessImageUrl(ProductList.Rows[i]["Thumbnail"].ToString()));
                        strBuilder.Append(@"'></a>");
                        strBuilder.Append(@"</td></tr></table>");
                        break;
                    case 1: //显示文字
                        strBuilder.Append(@"<table  border='0' cellspacing='0' cellspadding='0'><tr><td>");
                        if (TypeID == 0)
                            strBuilder.Append(@"<a href='{PB_WebURL}Supply/Detail-");
                        else
                            strBuilder.Append(@"<a href='{PB_WebURL}Purchase/Detail-");
                        strBuilder.Append(ProductList.Rows[i]["ID"].ToString());
                        strBuilder.Append(BasePage.Config.Rewrite);
                        strBuilder.Append(@" ' Target='" + "");
                        strBuilder.Append(Target);
                        strBuilder.Append(@"'>");
                        strBuilder.Append("<img width='");
                        strBuilder.Append(PicWidth);
                        strBuilder.Append(@"' height='");
                        strBuilder.Append(PicHight + "'");
                        if (PicClass != "" || PicClass != null)
                        {
                            strBuilder.Append(@" class='");
                            strBuilder.Append(PicClass);
                            strBuilder.Append(@"'");
                        }
                        strBuilder.Append(" src='");
                        strBuilder.Append(Function.ProcessImageUrl(ProductList.Rows[i]["Thumbnail"].ToString()));
                        strBuilder.Append(@"'></a></td></tr><tr><td>");
                        if (TypeID == 1)
                            strBuilder.Append(@"<a href='{PB_WebURL}Purchase/Detail-");
                        else
                            strBuilder.Append(@"<a href='{PB_WebURL}Supply/Detail-");
                        strBuilder.Append(ProductList.Rows[i]["ID"].ToString());
                        strBuilder.Append(BasePage.Config.Rewrite);
                        strBuilder.Append(@"' Target='" + Target + "' class=\"" + TitleClass + "\">");
                        if (TitleClass != "" || TitleClass != null)
                            strBuilder.Append(Function.GetString(ProductList.Rows[i]["Name"].ToString(), TitleSize));
                        strBuilder.Append(@"</a>");
                        strBuilder.Append(@"</td><tr></table>");
                        break;
                    default:
                        strBuilder.Append(@"<table  border='0' cellspacing='0' cellspadding='0'><tr><td>");
                        strBuilder.Append(" ");
                        strBuilder.Append(@"</td></tr></table>");
                        break;

                }

                //换行
                if (((i + 1) % RowsNum) == 0)
                {
                    if (i == (Num - 1))
                        strBuilder.Append(@" ");
                    else
                        strBuilder.Append(@"</td></tr><tr><td>");
                }
                else
                    strBuilder.Append(@"</td><td>");
            }
            strBuilder.Append(@"</td></tr></table>");
            return strBuilder.ToString();
        }

        /// <summary>
        /// 产品文字列表
        /// </summary>
        /// <param name="Array（10）">
        /// Num	          显示条数      
        /// RowsNum	      每行显示几条
        /// TypeID        [0：供应,1：求购]	
        /// IndType	      行业类别
        /// ProAttribute  商机属性
        /// OrderBy	      排序方式
        /// TitleSize	  标题字数	
        /// TitleClass    标题样式
        /// isShow	      是否显示 [供应/求购,时间]{0：不显示，1：显示}
        /// Target	      打开方式 [_blank ,_self]
        /// </param>
        /// <returns></returns>
        public static string SY_Productlist_Str(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 10) goto Err;

            int Num = strContent[0].ToString().Length > 0 ? Convert.ToInt32(strContent[0].ToString()) : 0;
            int RowsNum = strContent[1].ToString().Length > 0 ? Convert.ToInt32(strContent[1].ToString()) : 0;
            string TypeID = strContent[2].ToString();
            string IndType = strContent[3].ToString();
            string ProAttribute = strContent[4].ToString();
            string OrderBy = strContent[5].ToString();
            int TitleSize = strContent[6].ToString().Length > 0 ? Convert.ToInt32(strContent[6].ToString()) : 0;
            string TitleClass = strContent[7].ToString();
            char isType = strContent[8].ToString().Length > 0 ? strContent[8].ToString()[0] : '0';
            char isAddDate = strContent[8].ToString().Length > 2 ? strContent[8].ToString()[2] : '0';
            string Target = strContent[9].ToString();

            //需要取得的数据
            string strSelect;
            //读取几条信息
            if (Num <= 0)
                strSelect = "top 1 ";
            else
                strSelect = " top " + Num;

            if (TypeID == "1")
                strSelect += " C_Purchase.ID as ID , Name";
            else
                strSelect += " C_Supply.ID as ID , Name";


            if (isAddDate == '1') strSelect += " , AddDate";
            if (isType == '1') strSelect += ",Type,IndType ";

            //要查询的表、视图、存储过程
            string strTableName = "";
            //显示供应还是求购           
            if (TypeID == "1")
                strTableName = "C_Purchase";
            else
                strTableName = "C_Supply";
            if (isType == '1') strTableName += " , W_IndustryType";

            //查询条件
            StringBuilder strWhere = new StringBuilder();
            //所属类型 
            strWhere.Append("where verify=1 ");
            if (TypeID == "1" && isType == '1')
                strWhere.Append("and ','+ C_Purchase.IndType like +'%,'+ CAST(W_IndustryType.ID AS varchar)");
            else if (TypeID == "0" && isType == '1')
                strWhere.Append("and ','+ C_Supply.IndType like +'%,'+ CAST(W_IndustryType.ID AS varchar)");
            if (IndType.ToString().Length > 0 && IndType.ToString() != "0")
            {
                strWhere.Append(" and patindex('%," + IndType + ",%' , ','+IndType+',')>0 ");
            }
            // 资讯属性
            //if (ProAttribute != "")
            //{
            //    if (ProAttribute == "0")
            //    {
            //        strWhere.Append("and Recommend = 'False' ");
            //    }
            //    else
            //    {
            //        strWhere.Append("and Recommend = 'False' ");
            //    }
            //}

            // 排序方式
            string strOrder = "";
            switch (OrderBy)
            {
                case "0":
                    strOrder = "order by ID asc";
                    break;
                case "1":
                    strOrder = "order by ID desc";
                    break;
                case "2":
                    strOrder = "order by AddDate asc";
                    break;
                case "3":
                    strOrder = "order by AddDate desc";
                    break;
                default:
                    strOrder = "order by AddDate desc";
                    break;
            }
            //获取数据表
            DataTable ProductList = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrder);
            if (ProductList.Rows.Count <= 0)
            {
                return "暂无该信息";
            }
            StringBuilder strBuilder = new StringBuilder();
            int intCount = ProductList.Rows.Count;
            int intRow = 0;
            int intCell = RowsNum;
            intRow = intCount % intCell == 0 ? intCount / intCell : intCount / intCell + 1;
            strBuilder.Append("<table width='100%'  border=\"0\" cellpadding=\"0\" cellspacing=\"0\">" + "\r\n ");
            for (int i = 0; i < intRow; i++)
            {
                strBuilder.Append("<tr>" + "\r\n ");
                for (int j = 0; j < intCell; j++)
                {
                    int m = i * intCell + j;
                    if (m > Num || m >= intCount) break; //如果超过显示的条数则跳出。
                    strBuilder.Append("<td");
                    if (TitleClass != null || TitleClass != "")
                    {
                        strBuilder.Append(" class='" + TitleClass + "'");
                    }
                    strBuilder.Append(">");



                    if (isType == '1')
                    {
                        strBuilder.Append(@"[");
                        if (TypeID == "0")
                            strBuilder.Append(@"<a href='{PB_WebURL}Supply/Trade-");
                        else
                            strBuilder.Append(@"<a href='{PB_WebURL}Purchase/Trade-");
                        if (ProductList.Rows[m]["IndType"].ToString().LastIndexOf(',') > 0)
                            strBuilder.Append(ProductList.Rows[m]["IndType"].ToString().Substring(ProductList.Rows[m]["IndType"].ToString().LastIndexOf(',') + 1));
                        else
                            strBuilder.Append(ProductList.Rows[m]["IndType"].ToString());
                        strBuilder.Append(BasePage.Config.Rewrite);
                        strBuilder.Append(@" ' Target='");
                        strBuilder.Append(Target);
                        strBuilder.Append(@"'>");
                        strBuilder.Append(ProductList.Rows[m]["Type"].ToString());
                        strBuilder.Append(@"</a>]");
                    }
                    if (TypeID == "0")
                        strBuilder.Append(@"<a href='{PB_WebURL}Supply/Detail-");
                    else
                        strBuilder.Append(@"<a href='{PB_WebURL}Purchase/Detail-");
                    strBuilder.Append(ProductList.Rows[m]["ID"].ToString());
                    strBuilder.Append(BasePage.Config.Rewrite);
                    strBuilder.Append(@"' Target='");
                    strBuilder.Append(Target);
                    strBuilder.Append(@"'>"); strBuilder.Append("  ");
                    if (TitleSize > 0) //设置标题字数
                        if (ProductList.Rows[m]["Name"].ToString().Length > TitleSize)
                            strBuilder.Append(ProductList.Rows[m]["Name"].ToString().Substring(0, TitleSize));
                        else
                            strBuilder.Append(ProductList.Rows[m]["Name"].ToString());
                    else
                        strBuilder.Append(ProductList.Rows[m]["Name"].ToString());
                    strBuilder.Append(@"</a>    ");
                    if (isAddDate == '1')
                        strBuilder.Append(DateTime.Parse(ProductList.Rows[m]["AddDate"].ToString()).ToShortDateString());
                    strBuilder.Append("</td>");
                }
                strBuilder.Append("</tr>" + "\r\n ");
            }
            strBuilder.Append(@"</table>" + "\r\n ");
            return strBuilder.ToString();

        Err:
            return Function.ErrInfo(0);

        }

        /// <summary>
        /// 转换求购详细页的私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_PurchaseDetail(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int PID = 0;
            PID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            TPurchase Items = new RPurchase().GateItem(PID);
            if (Items.ID <= 0)
            {
                HttpContext.Current.Response.Write("<script>location.href='/Error.aspx?err=5';</script>");
            }
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name);
                            break;
                        case "{PR_NAME}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name.ToString());
                            break;
                        case "{PR_MATEKEYWORD}":             //Matekeyword
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Key.ToString());
                            break;
                        case "{PR_MATEDESCRIPTION}":         //
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name.ToString());
                            break;
                        case "{PR_TYPELINK}":                //类别列表
                            string strTypeLink = "";
                            if (Items.IndType.ToString() != "")
                            {
                                strTypeLink = TypeLink(Items.IndType.ToString(), 1);
                                Restr = Restr.Replace(strArray[i].ToString(), strTypeLink);
                            }

                            break;
                        case "{PR_TYPENAME}":                //类别名称
                            string strTypenName = "";
                            strTypenName = TypeLink(Items.IndType.ToString(), 0);
                            string str1 = Base.Common.ClearHtml(strTypenName);
                            Restr = Restr.Replace(strArray[i].ToString(), str1.Substring(str1.LastIndexOf('>') + 1).Trim());
                            break;
                        case "{PR_PICTURE}":                 //图片
                            Restr = Restr.Replace(strArray[i].ToString(), Function.ProcessImageUrl(Items.Thumbnail.ToString()));
                            break;
                        case "{PR_PICBIG}":                 //图片链接
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Thumbnail.Replace("t_","m_"));
                            break;
                        case "{PR_ID}":                      //求购ID
                            Restr = Restr.Replace(strArray[i].ToString(), Items.ID.ToString());
                            break;
                        case "{PR_INFO}":                    //求购信息
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Info.ToString());
                            break;
                        case "{PR_EXPIRYDATE}":              //有效期
                            string strExpiryDate = "";
                            strExpiryDate += Function.DateTransform(Items.StartDate.ToString(), "yyyy-mm-dd") + " - ";
                            strExpiryDate += Function.DateTransform(Items.EndDate.ToString(), "yyyy-mm-dd");
                            Restr = Restr.Replace(strArray[i].ToString(), strExpiryDate);
                            break;
                        case "{PR_COUNT}":                   //求购数量
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Count.ToString());
                            break;
                        case "{PR_PRICE}":                   //单价
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Price.ToString());
                            break;
                        case "{PR_UNIT}":                    //单位
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Unit.ToString());
                            break;
                        case "{PR_AREA}":                    //地区
                            Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "area"));
                            break;
                        case "{PR_ADDDATE}":                 //发布日期
                            Restr = Restr.Replace(strArray[i].ToString(), Function.DateTransform(Items.AddDate.ToString(), "yyyy-mm-dd"));
                            break;
                        case "{PR_INTERRELATED}":           //相关求购产品
                            Restr = Restr.Replace(strArray[i].ToString(), Purchase_Interrelated(Items.Key.ToString(), PID));
                            break;
                        case "{PR_MODEL}":                  //相关求购产品
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Model.ToString());
                            break;
                        case "{PR_USERNAME}":               //
                            Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "loginname"));
                            break;
                        case "{PR_USERGRADE}":              //会员等级
                            if (Items.IsUser.Equals("True"))
                                Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "grade"));
                            else
                                Restr = Restr.Replace(strArray[i].ToString(), "非会员");
                            break;
                        case "{PR_COUNTYEAR}":               //第几年
                            if (Items.IsUser.Equals("True"))
                            {
                                string year = "1";
                                DateTime StartDate = DateTime.Parse(GetUserInfo(Items.UserID, "StartDate"));
                                if (((DateTime.Now.Year) - (StartDate.Year)) == 0)
                                    year = "1";
                                else if (((DateTime.Now.Year) - (StartDate.Year)) > 0)
                                    year = ((DateTime.Now.Year) - (StartDate.Year)).ToString();
                                Restr = Restr.Replace(strArray[i].ToString(), "第" + year + "年");
                            }
                            else
                                Restr = Restr.Replace(strArray[i].ToString(), "");
                            break;
                        case "{PR_COMPANYNAME}":            //公司名称
                            Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "companyname"));
                            break;
                        case "{PR_BUSSINESSMODEL}":            //公司性质
                            Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "BusinessModel"));
                            break;
                        case "{PR_SAVEFAVORITES}":          //收藏信息
                            Restr = Restr.Replace(strArray[i].ToString(), systemic.PR_SaveFavorites(Items.ID.ToString(), "purchase"));
                            break;
                        case "{PR_QUOTATION}":              //报价
                            Restr = Restr.Replace(strArray[i].ToString(), "{PB_WebUrl}Search/Quotation.aspx?id=" + Items.ID.ToString());
                            break;
                        case "{PR_STARTDATE}":              //
                            Restr = Restr.Replace(strArray[i].ToString(), Items.StartDate.ToShortDateString());
                            break;
                        case "{PR_ENDDATE}":              //
                            Restr = Restr.Replace(strArray[i].ToString(), Items.EndDate.ToShortDateString());
                            break;
                        default:
                            // Restr = Restr.Replace(strArray[i].ToString(), strArray[i].ToString());
                            break;

                    }
                }
            }
            catch (Exception e)
            {
                // Restr = Restr + e.Message.ToString();
            }
            return Restr;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="p">会员ID</param>
        /// <param name="param">要查找的字段</param>
        /// <returns></returns>
        private static string GetUserInfo(int p, string param)
        {
            string Restr = "";
            UserInfo.TUserInfo Items = new UserInfo.RUserInfo().GateItem(p);
            if (Items.UserID == 0)
            {
                // HttpContext.Current.Response.Redirect("/Error.aspx");
                return "";
            }


            switch (param.ToUpper())
            {
                case "AREA":               //地区
                    if (Items.Country == "中国")
                        Restr += Items.Province + " " + Items.City;
                    else
                        Restr += Items.Country;
                    break;
                case "COMPANYNAME":        //公司名称
                    Restr += Items.CompanyName;
                    break;
                case "LOGINNAME":          //会员名称
                    Restr += Items.LoginName;
                    break;
                case "QQ":                //QQ
                    Restr += Items.QQ;
                    break;
                case "GRADE":             //会员等级
                    DataTable Grade = new VipGrade.RVipGrade().GetDataTable(Convert.ToInt32(Items.GradeID.ToString()));
                    Restr += Grade.Rows[0]["Name"].ToString();
                    break;
                case "BUSINESSMODEL":
                    Restr += Items.BusinessModel.ToString();
                    break;
                case "STARTDATE":
                    Restr += Items.StartDate.ToString();
                    break;
            }
            return Restr.ToString();
        }

        /// <summary>
        /// 相关求购产品
        /// </summary>
        /// <returns></returns>
        private static string Purchase_Interrelated(string strkey, int ID)
        {
            StringBuilder Restr = new StringBuilder();
            try
            {
                string[] strTable;
                string strWhere = "Where id != " + ID + " and ";
                strWhere += "C_Purchase.UserID = U_UserInfo.UserID  and ( ";
                if (strkey.IndexOf(',') < 0)
                    strWhere += " [key] ='" + strkey.ToString() + "')";
                else
                {
                    strTable = strkey.Split(',');
                    for (int i = 0; i < strTable.Length; i++)
                    {
                        strWhere += " [key] like '%";
                        strWhere += strTable[i].ToString();
                        strWhere += "%' or";
                    }
                    strWhere = strWhere.Substring(0, strWhere.Length - 2);
                    strWhere += ")";
                }
                DataTable Tables = Function.GetDataTable(" C_Purchase.* , U_UserInfo.CompanyName ", strWhere, "C_Purchase ,U_UserInfo", "order by C_Purchase.AddDate");
                if (Tables.Rows.Count < 0)
                    Restr.Append("没有相关求购信息");
                else
                {
                    Restr.Append(@"<table width='100%'><tr><td>名称</td><td>数量</td><td>价格</td><td>公司</td><td>发布时间</td></tr>");
                    for (int i = 0; i < Tables.Rows.Count; i++)
                    {
                        Restr.Append("<tr><td><a href=\"{PB_WEBURL}Purchase/detail-");
                        Restr.Append(Tables.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite + "\">");
                        Restr.Append(Tables.Rows[i]["Name"].ToString());
                        Restr.Append("</a></td><td>");
                        Restr.Append(Tables.Rows[i]["Count"].ToString());
                        Restr.Append("</td><td>");
                        Restr.Append(Tables.Rows[i]["Price"].ToString());
                        Restr.Append("</td><td>");
                        Restr.Append(Tables.Rows[i]["CompanyName"].ToString());
                        Restr.Append("</td><td>");
                        Restr.Append(Tables.Rows[i]["AddDate"].ToString());
                        Restr.Append("</td><tr>");
                    }
                    Restr.Append("</table>");
                }
            }
            catch (Exception e)
            {
                Restr.Append(e.Message.ToString());
            }
            return Restr.ToString();
        }


        /// <summary>
        /// 行业类别链表
        /// </summary>
        /// <param name="strType">行业ID字符串</param>
        /// <param name="param">0:分类页, 1:详细页</param>
        /// <returns></returns>
        private static string TypeLink(string strTypeLink, int param)
        {
            if (strTypeLink[strTypeLink.Length - 1] == ',')
            {
                strTypeLink = strTypeLink.Substring(0, strTypeLink.Length - 1);
            }
            try
            {
                DataTable TypeData = new DataTable();
                if (param != 0)
                    TypeData = Function.GetDataTable("Type,ID", "where ID in(" + strTypeLink + ") AND ToRelease=1 ", "W_IndustryType", " order by SuperiorsFlag  ");
                else
                {
                    SqlParameter[] param1 = new SqlParameter[] 
                    {  
                        new SqlParameter("@ID",Convert.ToInt32(strTypeLink))
                    };
                    TypeData = SqlOperate.SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_W_TypeLink", param1);
                }
                string strType = "";
                string str = "<a href='trade-";

                if (TypeData.Rows.Count > 0)
                {
                    for (int i = 0; i < TypeData.Rows.Count; i++)
                    {
                        strType += " > " + str;
                        strType += TypeData.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite;
                        strType += "'>";
                        strType += TypeData.Rows[i]["Type"].ToString();
                        strType += "</a>";
                    }
                }
                return strType;
            }
            catch (Exception ex)
            {
                return "";
            }
        }

        /// <summary>
        /// 详细页行业类别链表
        /// </summary>
        /// <param name="param">0:求购分类页, 1:求购详细页, 2:供应分类页, 3:供应详细页</param>
        /// <returns></returns>
        private static string TypeLink(string strTypeLink)
        {
            return TypeLink(strTypeLink, 1);
        }

        /// <summary>
        ///  求购列表（仅限在求购分类页中使用）
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string DIY_Purchaselist(TSystemLable Array, string strModule)
        {
            // 对标签使用条件进行检查
            if (strModule == "" || strModule.Substring(0, strModule.IndexOf('_')) != "Purchase") throw new Exception(Function.ErrInfo(2));
            string strWhere = " C_Purchase.Verify=1 and (datediff(hh,C_Purchase.EndDate,getdate())<0)";
            int TypeID = 0;
            if (Function.CheckQueryStringisInt("id"))
            {
                TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                strWhere += " and patindex('%,'+rtrim( " + TypeID + ")+',%',','+ IndType+',')>0 ";
            }

            if (TypeID < 0) throw new Exception(Function.ErrInfo(1));

            // 定义全局变量，最后返回
            StringBuilder ReBulider = new StringBuilder();

            // 求购列表头部
            string strHead = "";
            strHead = Array.Head;
            ReBulider.Append(strHead);

            //取得页尺寸
            int pagesize = 10;
            int OrderType = 1;               
            int PageID = 1;  //x
            if (Function.CheckQueryStringisInt("Page"))
            {
                PageID = Convert.ToInt32(HttpContext.Current.Request.QueryString["Page"]);
            }

            string strTabelName = "C_Purchase Left join U_UserInfo on C_Purchase.UserID=U_UserInfo.UserID ";
            string strFldName = "AddDate";
            string strSelect = "C_Purchase.*,U_UserInfo.UserID, U_UserInfo.GradeID";           
            if (Array.Info != null)
            {
                string[] strInfo1 = Array.Info.Split('|');
                for (int k = 0; k < strInfo1.Length; k++)
                {
                    if (k == 0)
                    {
                        if (GetRequest.isNum(strInfo1[k].ToString()))
                        {
                            pagesize = Int32.Parse(strInfo1[k].ToString());
                        }
                    }
                    else if (k == 1)
                    {
                        if (GetRequest.isNum(strInfo1[k].ToString()))
                        {
                            string strType = strInfo1[k].ToString();
                            switch (strType)
                            {
                                case "0": OrderType = 0; strFldName = " C_Purchase.AddDate asc, U_UserInfo.GradeID "; break;
                                case "1": OrderType = 1; strFldName = " C_Purchase.AddDate desc, U_UserInfo.GradeID "; break;
                                case "2": OrderType = 1; strFldName = " U_UserInfo.GradeID desc, C_Purchase.AddDate "; break;
                                case "3": OrderType = 0; strFldName = " U_UserInfo.GradeID asc, C_Purchase.AddDate "; break;
                            }
                        }
                    }
                }
            }     
            // 获取求购信息U_VipGrade.Sort desc,AddDate
            DataTable Lists = Pagination.GetDataTable(strWhere, strTabelName, OrderType, strFldName, strSelect, pagesize, PageID, 0, "C_Purchase.id");
            if (Lists.Rows.Count < 0)
            {
                ReBulider.Append("暂无此类产品");
            }
            else
            {
                DataSet vipData = new VipGrade.RVipGrade().GetDataTable();
                string strInfo = Array.Content.ToString();
                string[] strAtttibute = Function.GetAttribute(strInfo);
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strInfo = Array.Content.ToString();
                    for (int j = 0; j < strAtttibute.Length; j++)
                    {
                        switch (strAtttibute[j].ToUpper())
                        {
                            case "{PR:WS_ID}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["ID"].ToString());
                                break;
                            case "{PR:WS_NAME}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Name"].ToString());
                                break;
                            case "{PR:WS_PICTURE}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.ProcessImageUrl(Lists.Rows[i]["Thumbnail"].ToString()));
                                break;                           
                            case "{PR:WS_ADDDATE}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Convert.ToDateTime(Lists.Rows[i]["AddDate"].ToString()).ToShortDateString());
                                break;
                            case "{PR:WS_INFO}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.GetString(Base.Common.RemoveHTML(Lists.Rows[i]["Info"].ToString()), 60));
                                break;
                            case "{PR:WS_LEVEL}":
                                if ((Lists.Rows[i]["IsUser"].ToString()).Equals("False"))
                                {
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), "非会员");
                                }
                                else
                                {
                                    for (int k = 0; k < vipData.Tables[0].Rows.Count; k++)
                                    {
                                        if (Lists.Rows[i]["GradeID"].ToString() == vipData.Tables[0].Rows[k]["ID"].ToString())
                                        {
                                            strInfo = strInfo.Replace(strAtttibute[j].ToString(), "<img src=\"" + Function.ProcessImageUrl(vipData.Tables[0].Rows[k]["Flag"].ToString()) + "\"/>");
                                            break;
                                        }
                                    }
                                }
                                break;
                            case "{PR:WS_GALAXIECHAT}":           //在线交流
                                string str1 = GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "qq");
                                string str = "";
                                if (str1 != "")
                                    str = "<a target=\"blank\" href=\"http://wpa.qq.com/msgrd?V=1&Uin=" + str1 + "&Exe=QQ&Site=im.qq.com&Menu=No\"><img style=\" border:0\" src=\"{pb_weburl}images/b_online.gif\" alt=\"给我发消息\" /></a>";
                                if (HttpContext.Current.Request.Cookies["UserID"] != null && HttpContext.Current.Request.Cookies["UserID"].ToString() != "")
                                {
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), str);
                                }
                                else
                                {
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), "<img style=\" border:0\" src=\"{pb_weburl}images/b_online.gif\" alt=\"给我发消息\" onclick=\"javascript:alert('您还没有登陆，请先登陆')\" />");
                                }
                                break;
                            case "{PR:WS_AREA}":                  //地区
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "area"));
                                break;

                            case "{PR:WS_PRICE}":                 //价格
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Price"].ToString() + "元/" + Lists.Rows[i]["Unit"].ToString());
                                break;
                            case "{PR:WS_COMPANYNAME}":
                                if (HttpContext.Current.Request.Cookies["UserID"] != null && HttpContext.Current.Request.Cookies["UserID"].ToString() != "")
                                {
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "companyname"));
                                }
                                else
                                {
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), "&nbsp;");
                                }
                                break;
                            case "{PR:WS_DETAILLINK}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_WEBURL}Purchase/detail-" + Lists.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite);
                                break;
                            case "{PR:WS_SHOPURL}":
                                if (HttpContext.Current.Request.Cookies["UserID"] != null && HttpContext.Current.Request.Cookies["UserID"].ToString() != "")
                                {
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_WEBURL}Shops/index/" + GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "LoginName") + Base.BasePage.Config.Rewrite);
                                }
                                else
                                {
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), "#");
                                }
                                break;
                            case "{PR:WS_CHECKINFO}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "<input id=\"compareBox" + i + "\" type=\"checkbox\" value=\"\" name=\" " + Lists.Rows[i]["id"].ToString() + " \" onclick=\"clickcompareBox(" + Lists.Rows[i]["id"].ToString() + ",this)\" memberId=\"stfseal\">");
                                break;
                        }

                    }
                    if (i > pagesize) break; //如果超过显示的条数则跳出。
                    ReBulider.Append(strInfo);
                }
            }



            //求购列表尾部
            string strFooter = "";
            strFooter = Array.Footer;
            ReBulider.Append(strFooter);

            string strUrl = "{PB_WebURL}Purchase/Trade";
            if (PageID <= 0) PageID = 1;
            if (TypeID != 0)
            {
                strUrl += "-" + TypeID;
            }
            strUrl += "-p";
            string Pages = Pagination.GoToPager(PageID, pagesize, strUrl, strWhere, "C_Purchase");
            ReBulider.Append(Pages);
            return ReBulider.ToString();

        Err0:
            return Function.ErrInfo(2);
        }

        /// <summary>
        /// 处理求购分类页私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_PurchaseTrade(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            string PID = "0";
            if (HttpContext.Current.Request.QueryString["id"] != null && HttpContext.Current.Request.QueryString["id"] != "")
            {
                PID = HttpContext.Current.Request.QueryString["ID"];
            }
            Product.TIndustryType Items = new TIndustryType();
            Items.Type = "";
            if (PID != "0")
            {
                Items = new RIndustryType().GateItem(Convert.ToInt32(PID));
            }
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_PUTYPENAME}":
                            //Restr = Restr.Replace(strArray[i].ToString(), Items.Name.ToString());
                            break;
                        case "{PR_COUNT}":
                            string str1 = " Verify=1 and (datediff(hh,C_Purchase.EndDate,getdate())<0)";
                            if (PID != "0")
                            {
                                str1 = "patindex('%,'+rtrim( " + PID + ")+',%',','+ IndType+',')>0 AND  Verify=1";
                            }
                            DataTable table = Base.PageList.GetDataTable(str1, "C_Purchase");
                            string count = table.Rows[0]["Total"].ToString();
                            Restr = Restr.Replace(strArray[i].ToString(), count);
                            break;
                        case "{PR_LOWERTYPE}":
                            Restr = Restr.Replace(strArray[i].ToString(), lowerType(Convert.ToInt32(PID), "Purchase"));
                            break;
                        case "{PR_TYPELINK}":
                            string strTypeLink = "";
                            strTypeLink = TypeLink(PID.ToString(), 0);
                            Restr = Restr.Replace(strArray[i].ToString(), strTypeLink);
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Type);
                            break;
                        default:
                            break;

                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;


        }

        /// <summary>
        /// 求购首页私有变量处理方法
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_PurchaseIndex(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int PID = 0;
            PID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            TPurchase Items = new RPurchase().GateItem(PID);
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_PUTYPENAME}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name.ToString());
                            break;
                        case "{PR_LOWERTYPE}":
                            Restr = Restr.Replace(strArray[i].ToString(), lowerType(PID, "Purchase"));
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), "求购信息");
                            break;
                        default:
                            break;

                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }

        /// <summary>
        /// 供应首页私有变量处理方法
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_SupplyIndex(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int PID = 0;
            PID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            TPurchase Items = new RPurchase().GateItem(PID);
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_PUTYPENAME}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name.ToString());
                            break;
                        case "{PR_LOWERTYPE}":
                            Restr = Restr.Replace(strArray[i].ToString(), lowerType(PID, "Supply"));
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), "供应信息");
                            break;
                        default:
                            break;

                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }

        /// <summary>
        /// 供应分类页私有变量处理方法
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_SupplyTrade(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            string PID = "0";
            if (Function.CheckQueryStringisInt("id"))
            {
                PID = HttpContext.Current.Request.QueryString["id"].ToString();
            }
            Product.TIndustryType Items = new TIndustryType();
            Items.Type = "";
            if (PID != "0")
            {
                Items = new RIndustryType().GateItem(Convert.ToInt32(PID));
            }
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToUpper())
                    {
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Type);
                            break;
                        case "{PR_LOWERTYPE}":
                            Restr = Restr.Replace(strArray[i].ToString(), lowerType(Convert.ToInt32(PID), "Supply")); ;
                            break;
                        case "{PR_COUNT}":   //供应的总数    
                            string str1 = "C_Supply.Verify=1 and (datediff(hh,C_Supply.EndDate,getdate())<0)";
                            if (!PID.Equals("0"))
                            {
                                str1 += " AND patindex('%,'+rtrim( " + PID + ")+',%',','+ IndType+',')>0 ";
                            }
                            DataTable table = Base.PageList.GetDataTable(str1, "C_Supply left join U_UserInfo on C_Supply.UserID=U_UserInfo.UserID left join U_VipGrade on U_UserInfo.GradeID=U_VipGrade.ID ");
                            string count = table.Rows[0]["Total"].ToString();
                            Restr = Restr.Replace(strArray[i].ToString(), count);
                            break;
                        case "{PR_TYPELINK}":
                            string strTypeLink = "";
                            strTypeLink = TypeLink(PID.ToString(), 0);
                            Restr = Restr.Replace(strArray[i].ToString(), strTypeLink);
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Type);
                            break;
                        default:
                            break;

                    }
                }
            }
            catch (Exception e)
            {
                Restr += e.Message.ToString();
            }
            return Restr;
        }

        /// <summary>
        /// 供应详细页私有变量处理方法
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_SupplyDetail(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int SID = 0;
            SID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            TSupply Items = new RSupply().GateItem(SID);
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name);
                            break;
                        case "{PR_NAME}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name.ToString());
                            break;
                        case "{PR_MATEKEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Key.ToString());
                            break;
                        case "{PR_MATEDESCRIPTION}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name.ToString());
                            break;
                        case "{PR_TYPELINK}":                //类别列表
                            string strTypeLink = "";
                            strTypeLink = TypeLink(Items.IndType.ToString(), 1);
                            Restr = Restr.Replace(strArray[i].ToString(), strTypeLink);
                            break;
                        case "{PR_TITLE}":                   //信息名称
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name.ToString());
                            break;
                        case "{PR_PICTURE}":                 //信息图片
                            Restr = Restr.Replace(strArray[i].ToString(), Function.ProcessImageUrl(Items.Picture_1.ToString()));
                            break;
                        case "{PR_INFO}":                    //详细信息
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Info.ToString());
                            break;
                        case "{PR_MODEL}":                    //详细信息
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Model.ToString());
                            break;
                        case "{PR_EXPIRYDATE}":              //有效期
                            string strExpiryDate = "";
                            //strExpiryDate += Function.DateTransform(Items.StartDate.ToString(), "yyyy-mm-dd") + " - ";
                            strExpiryDate += Function.DateTransform(Items.EndDate.ToString(), "yyyy-mm-dd");
                            Restr = Restr.Replace(strArray[i].ToString(), strExpiryDate);
                            break;
                        case "{PR_COUNT}":                   //供应数量
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Quantity.ToString());
                            break;
                        case "{PR_PRICE}":                   //单价
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Price.ToString());
                            break;
                        case "{PR_UNIT}":                    //单位
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Units.ToString());
                            break;
                        case "{PR_MINMUNUM}":                    //单位
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Minimum.ToString());
                            break;
                        case "{PR_ADDDATE}":                 //发布日期
                            Restr = Restr.Replace(strArray[i].ToString(), Function.DateTransform(Items.AddDate.ToString(), "yyyy-mm-dd"));
                            break;
                        case "{PR_INTERRELATED}":            //相关供应产品
                            // Restr = Restr.Replace(strArray[i].ToString(), Purchase_Interrelated(Items.Key.ToString(), PID));
                            break;
                        case "{PR_USERGRADE}":               //会员等级
                            Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "grade"));
                            break;
                        case "{PR_COUNTYEAR}":               //第几年
                            string year = "1";
                            DateTime StartDate = DateTime.Parse(GetUserInfo(Items.UserID, "StartDate"));
                            if (((DateTime.Now.Year) - (StartDate.Year)) == 0)
                                year = "1";
                            else if (((DateTime.Now.Year) - (StartDate.Year)) > 0)
                                year = ((DateTime.Now.Year) - (StartDate.Year)).ToString();
                            Restr = Restr.Replace(strArray[i].ToString(), year);
                            break;
                        case "{PR_SAVEFAVORITES}":          //收藏信息
                            Restr = Restr.Replace(strArray[i].ToString(), systemic.PR_SaveFavorites(Items.ID.ToString(), "supply"));
                            break;
                        case "{PR_AREA}":                    //地区
                            Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "area"));
                            break;
                        case "{PR_BUSSINESSMODEL}":            //公司性质
                            Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "BusinessModel"));
                            break;
                        case "{PR_INQUIRY}":               //询价
                            Restr = Restr.Replace(strArray[i].ToString(), "{PB_WebUrl}Search/Inquiry.aspx?cpid=" + Items.ID.ToString());
                            break;
                        default:
                            break;

                    }
                }
            }
            catch (Exception e)
            {
                return Restr + e.Message.ToString();
            }
            return Restr;
        }

        /// <summary>
        ///  供应列表（仅限在求购分类页中使用）
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string DIY_Supplylist(TSystemLable Array, string strModule)
        {
            // 对标签使用条件进行检查
            if (!strModule.Contains("Supply_Trade")) throw new Exception(Function.ErrInfo(2));
            string strWhere = "C_Supply.Verify=1 and (datediff(hh,C_Supply.EndDate,getdate())<0)";
            int TypeID = 0;
            if (Function.CheckQueryStringisInt("id"))
            {
                TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                //strWhere += " and  IndType like '%" + TypeID + "%' ";
                strWhere += " and patindex('%,'+rtrim( " + TypeID + ")+',%',','+ IndType+',')>0 ";
            }

            // 定义全局变量，最后返回
            StringBuilder ReBulider = new StringBuilder();

            // 求购列表头部
            string strHead = "";
            strHead = Array.Head;
            ReBulider.Append(strHead);

            string strTable = " C_Supply left join U_UserInfo on C_Supply.UserID=U_UserInfo.UserID left join U_VipGrade on U_UserInfo.GradeID=U_VipGrade.ID ";
            int OrderType = 1;
            string OrderField = " U_VipGrade.Sort desc, C_Supply.AddDate ";
            string strSelect = " C_Supply.*,U_UserInfo.UserID ,U_VipGrade.ID as VipID";

            //获得页尺寸
            int PageSize = 10;
            if (Array.Info != null)
            {
                string[] strInfo1 = Array.Info.Split('|');
                for (int k = 0; k < strInfo1.Length; k++)
                {
                    if (k == 0)
                    {
                        if (GetRequest.isNum(strInfo1[k].ToString()))
                        {
                            PageSize = Int32.Parse(strInfo1[k].ToString());
                        }
                    }
                    else if (k == 1)
                    {
                        if (GetRequest.isNum(strInfo1[k].ToString()))
                        {
                            string strType = strInfo1[k].ToString();
                            switch (strType)
                            {
                                case "0": OrderType = 0; OrderField = "  C_Supply.AddDate desc, U_VipGrade.Sort "; break;
                                case "1": OrderType = 1; OrderField = "  C_Supply.AddDate asc, U_VipGrade.Sort "; break;
                                case "2": OrderType = 1; OrderField = "  U_VipGrade.Sort desc, C_Supply.AddDate "; break;
                                case "3": OrderType = 0; OrderField = "  U_VipGrade.Sort asc, C_Supply.AddDate "; break;
                                case "4": OrderType = 1; OrderField = "  C_Supply.Price desc, C_Supply.AddDate "; break;
                                case "5": OrderType = 0; OrderField = "  C_Supply.Price asc, C_Supply.AddDate "; break;
                                case "6": OrderType = 1; OrderField = "  C_Supply.AddDate desc, C_Supply.Price "; break;
                            }
                        }
                    }
                }
            }         
            int PageIndex = 0;
            if (HttpContext.Current.Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(HttpContext.Current.Request.QueryString["Page"]);
            if (PageIndex < 1) PageIndex = 1;
            int Count = 0;

            DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count, "C_Supply.ID");
            if (Lists.Rows.Count < 0)
            {
                ReBulider.Append("暂无此类产品");
            }
            else
            {
                DataSet vipData = new VipGrade.RVipGrade().GetDataTable();
                string strInfo = Array.Content.ToString();
                string[] strAtttibute = Function.GetAttribute(strInfo);
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strInfo = Array.Content.ToString();
                    for (int j = 0; j < strAtttibute.Length; j++)
                    {
                        switch (strAtttibute[j].ToUpper())
                        {
                            case "{PR:WS_ID}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["ID"].ToString());
                                break;
                            case "{PR:WS_NAME}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Name"].ToString());
                                break;
                            case "{PR:WS_PICTURE}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.ProcessImageUrl(Lists.Rows[i]["Thumbnail"].ToString()));
                                break;
                            case "{PR:WS_ADDDATE}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), DateTime.Parse(Lists.Rows[i]["AddDate"].ToString()).ToShortDateString());
                                break;
                            case "{PR:WS_INFO}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.GetString(Base.Common.RemoveHTML(Lists.Rows[i]["Info"].ToString()), 40));
                                break;
                            case "{PR:WS_PRICE}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Price"].ToString() + "元/" + Lists.Rows[i]["Units"].ToString());
                                break;
                            case "{PR:WS_LEVEL}":
                                for (int k = 0; k < vipData.Tables[0].Rows.Count; k++)
                                {
                                    if (Lists.Rows[i]["VipID"].ToString() == vipData.Tables[0].Rows[k]["ID"].ToString())
                                    {
                                        strInfo = strInfo.Replace(strAtttibute[j].ToString(), "<img src=\"" + Function.ProcessImageUrl(vipData.Tables[0].Rows[k]["Flag"].ToString()) + "\"/>");
                                        break;
                                    }
                                }
                                break;
                            case "{PR:WS_BRAND}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["brand"].ToString());
                                break;
                            case "{PR:WS_PLACE}":                       //地区
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "area"));
                                break;
                            case "{PR:WS_COMPANYNAME}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "companyname"));
                                break;
                            case "{PR:WS_CONTACTWAY}":                //联系我们
                                string strWay = "<a href='{Pb_webUrl}shops/Contact/" + GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "loginName") + ".html'>联系方式</a>";
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), strWay);
                                break;
                            case "{PR:WS_INQUIRY}":                   //询价
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_WebUrl}/Search/Inquiry.aspx?cpid=" + Lists.Rows[i]["ID"].ToString());
                                break;
                            case "{PR:WS_DETAILLINK}":               //详细链接
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_WebUrl}Supply/Detail-" + Lists.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite);
                                break;
                            case "{PR:WS_COMPANYLINK}":               //详细链接
                                string UID = Lists.Rows[i]["UserID"].ToString();
                                TUserInfo tsuser = new RUserInfo().GateItem(int.Parse(UID));
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_WebUrl}Shops/index/" + tsuser.LoginName + BasePage.Config.Rewrite);
                                break;
                            case "{PR:WS_GALAXIECHAT}":              //在线交流
                                string str1 = GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "qq");
                                string str = "";
                                if (str1 != "")
                                    str = "<a target=\"blank\" href=\"http://wpa.qq.com/msgrd?V=1&Uin=" + str1 + "&Exe=QQ&Site=im.qq.com&Menu=No\"><img style=\" border:0\" src=\"{pb_weburl}images/b_online.gif\" alt=\"给我发消息\" /></a>";
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), str);
                                break;
                            case "{PR:WS_SHOPURL}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_WEBURL}Shop/index/" + GetUserInfo(Convert.ToInt32(Lists.Rows[i]["UserID"].ToString()), "loginName") + Base.BasePage.Config.Rewrite);
                                break;
                            case "{PR:WS_CHECKINFO}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "<input id=\"compareBox" + i + "\" type=\"checkbox\" value=\"\" name=\" " + Lists.Rows[i]["id"].ToString() + " \" onclick=\"clickcompareBox(" + Lists.Rows[i]["id"].ToString() + ",this)\" memberId=\"stfseal\">");
                                break;

                        }
                    }
                    // if (i > Num - 1) break; //如果超过显示的条数则跳出。


                    ReBulider.Append(strInfo);
                    ReBulider.Append(System.Environment.NewLine);
                }
            }



            //求购列表尾部
            string strFooter = "";
            strFooter = Array.Footer;
            ReBulider.Append(strFooter);

            string strUrl = "Trade";
            if (TypeID != 0)
            {
                strUrl += "-" + TypeID;
            }
            strUrl += "-p";
            string Pages = Pagination.GoToPager(PageIndex, PageSize, strUrl, strWhere, strTable);
            ReBulider.Append(Pages);
            return ReBulider.ToString();


        }

        private static string GetVipGrade(int GradeID)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqldata"].ConnectionString);
            SqlCommand cmd = new SqlCommand("SELECT [Flag] FROM [U_VipGrade] WHERE ID=@ID", con);
            cmd.Parameters.AddWithValue("@ID", GradeID);
            con.Open();
            SqlDataReader sr = cmd.ExecuteReader();
            if (sr.Read())
            {
                return sr["Flag"].ToString();
            }
            con.Close();
            return "";
        }

        /// <summary>
        /// 公司最新产品
        /// </summary>
        /// <param name="Array">
        /// Num	          显示条数      
        /// RowsNum	      每行显示几条
        /// WhichType     [0：供应,1：求购]
        /// PicWidth      图宽
        /// PicHeight     图高
        /// PicClass      图Class
        /// TitleSize	  标题字数	
        /// TitleClass    标题样式
        /// Target	      打开方式 [_blank ,_self]
        /// strAttribute  [0：全部，1：当前频道]
        /// Recommend     [0:不推荐，1：推荐]  
        /// </param>
        /// <returns></returns> 
        public static string SY_DetailNewProduct(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 11) return Function.ErrInfo(0);

            int Num = 0;
            int RowsNum = 0;
            int PicWidth = 0;
            int PicHight = 0;
            int TitleSize = 0;
            if (strContent[0].ToString().Trim() != "") Num = Convert.ToInt32(strContent[0].ToString());
            if (strContent[1].ToString().Trim() != "") RowsNum = Convert.ToInt32(strContent[1].ToString());
            string WhichType = strContent[2].ToString();
            if (strContent[3].ToString().Trim() != "") PicWidth = Convert.ToInt32(strContent[3].ToString());
            if (strContent[4].ToString().Trim() != "") PicHight = Convert.ToInt32(strContent[4].ToString());
            string PicClass = strContent[5].ToString();
            if (strContent[6].ToString().Trim() != "") TitleSize = Convert.ToInt32(strContent[6].ToString());
            string TitleClass = strContent[7].ToString();
            string Target = strContent[8].ToString();
            string strAttribute = strContent[9].ToString();
            string Recommend = strContent[10].ToString();
            //获取该产品的其他信息
            int PID = 0;
            PID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            DataTable ProductList = new DataTable();
            if (WhichType == "0")
            {
                TSupply Items = new RSupply().GateItem(PID);
                ProductList = GetDt(Items, 0, Num, strAttribute, Recommend);
            }
            else
            {
                TPurchase Items = new RPurchase().GateItem(PID);
                ProductList = GetDt(Items, 1, Num, strAttribute, Recommend);
            }
            string strHref = "<a href='{PB_WEBURL}Supply/detail-";
            StringBuilder strBuilder = new StringBuilder();
            if (ProductList.Rows.Count <= 0) return "没有相关产品";
            strBuilder.Append("<table width='100%'><tr><td>");
            for (int i = 0; i < ProductList.Rows.Count; i++)
            {
                if (i > Num - 1) break; //如果超过显示的条数则跳出。
                strBuilder.Append(strHref);
                strBuilder.Append(ProductList.Rows[i]["ID"].ToString());
                strBuilder.Append(BasePage.Config.Rewrite);
                strBuilder.Append(@" ' Target='");
                strBuilder.Append(Target);
                strBuilder.Append(@"'>");
                strBuilder.Append("<img width='");
                strBuilder.Append(PicWidth);
                strBuilder.Append(@"' height='");
                strBuilder.Append(PicHight);
                strBuilder.Append(@"' class='");
                strBuilder.Append(PicClass);
                strBuilder.Append(@"'src='");
                strBuilder.Append(Function.ProcessImageUrl(ProductList.Rows[i]["Thumbnail"].ToString()));
                strBuilder.Append(@"'></a><br />");
                strBuilder.Append(strHref);
                strBuilder.Append(ProductList.Rows[i]["ID"].ToString());
                strBuilder.Append(BasePage.Config.Rewrite);
                strBuilder.Append(@"' Target='");
                strBuilder.Append(Target);
                strBuilder.Append(@"'>");
                strBuilder.Append(Function.GetString(ProductList.Rows[i]["Name"].ToString(), TitleSize));
                strBuilder.Append(@"</a>");

                //换行
                if (((i + 1) % RowsNum) == 0)
                {
                    if (i == (Num - 1))
                        strBuilder.Append("");
                    else
                        strBuilder.Append(@"</td></tr><tr><td>");
                }
                else
                    strBuilder.Append(@"</td><td>");
            }
            strBuilder.Append(@"</td></tr></table> ");
            return strBuilder.ToString();
        }

        private static DataTable GetDt(TSupply Items, int Type, int Num, string strAttribute, string Recommend)
        {
            string strSelect = "";
            if (Num <= 0)
                strSelect += "top 1 ";
            else
                strSelect += " top " + Num;

            strSelect += " ID,Thumbnail,Name";
            string strWhere = " where UserID=" + Items.UserID;
            if (strAttribute == "1")
                strWhere += " and IndType='" + Items.IndType.ToString() + "'";
            if (Recommend == "1")
                strWhere += " and UserRecommend=1";

            string strOrder = " order by AddDate desc ";
            string strTableName = " C_Supply";

            //获取数据表
            DataTable ProductList = Function.GetDataTable(strSelect, strWhere, strTableName, strOrder);
            return ProductList;
        }

        private static DataTable GetDt(TPurchase Items, int Type, int Num, string strAttribute, string Recommend)
        {
            string strSelect = "";
            if (Num <= 0)
                strSelect += "top 1 ";
            else
                strSelect += " top " + Num;

            strSelect += " ID,Thumbnail,Name";
            string strWhere = " where UserID=" + Items.UserID;
            if (strAttribute == "1")
                strWhere += " and IndType='" + Items.IndType.ToString() + "'";
            if (Recommend == "1")
                strWhere += " and UserRecommend=1";

            string strOrder = " order by AddDate desc ";
            string strTableName = "C_Purchase";

            //获取数据表
            DataTable ProductList = Function.GetDataTable(strSelect, strWhere, strTableName, strOrder);
            return ProductList;
        }

        public static string DIY_SupplyInfo(TSystemLable Array)
        {
            int SID = 0;
            // 判断是否出错
            //if (StrModule != "Supply_detail") goto Err0;
            int intID = Convert.ToInt32(HttpContext.Current.Request.QueryString["id"]);
            //int intID =100006 ;
            if (intID <= 0) goto Err1;

            TSupply strInfo = new RSupply().GateItem(intID);
            if (strInfo.ID <= 0)
            {
                return "该供应信息不存在！";
            }
            string strContent = Array.Content.ToString();  //取得用户自定义的标签内容
            string[] strAtttibute = Function.GetAttribute(strContent);
            if (strAtttibute.Length != 0)
            {
                for (int i = 0; i < strAtttibute.Length; i++)
                {
                    switch (strAtttibute[i].ToUpper())
                    {
                        case "{PR:WS_PRICE}":              //产品价格
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Price.ToString() + "元/" + strInfo.Units.ToString());
                            break;
                        case "{PR:WS_IMAGE}":              //产品图片
                            strContent = strContent.Replace(strAtttibute[i].ToString(), Function.ProcessImageUrl(strInfo.Thumbnail));
                            break;
                        case "{PR:WS_IMGBIG}":
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Thumbnail.Replace("t_","m_")); break;
                        case "{PR:WS_MINAMOUNT}":          //最小起订
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Minimum.ToString() + " " + strInfo.Units.ToString());
                            break;
                        case "{PR:WS_MAXAMOUNT}":          //供货数量
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Quantity.ToString() + " " + strInfo.Units.ToString());
                            break;
                        case "{PR:WS_ADDRESS}":            //所在地
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Place.ToString());
                            break;
                        case "{PR:WS_LINKMAN}":            //联系人
                            TUserInfo t = new RUserInfo().GateItem(strInfo.UserID);
                            strContent = strContent.Replace(strAtttibute[i].ToString(), t.LinkName + " " + t.Sex.ToString());
                            break;
                        case "{PR:WS_FAX}":                //有效期
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.EndDate.ToShortDateString());
                            break;
                        case "{PR:WS_LOGO}":               //品牌
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Brand.ToString());
                            break;
                        case "{PR:WS_TYPE}":               //规格型号
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Model.ToString());
                            break;
                        case "{PR:WS_DESCRIPTION}":        //详细信息
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Info.ToString());
                            break;
                        case "{PR:WS_ALLINFO}":            //详细信息
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Document.ToString());
                            break;
                        case "{PR:WS_SAVEFAVORITES}":        //收藏信息
                            strContent = strContent.Replace(strAtttibute[i].ToString(), systemic.PR_SaveFavorites(strInfo.ID.ToString(), "supply"));
                            break;
                        case "{PR:WS_QUOTATION}":        //点此询价
                            strContent = strContent.Replace(strAtttibute[i].ToString(), "{PB_WebUrl}/Search/Inquiry.aspx?type=supply&cpid=" + strInfo.ID.ToString());
                            break;
                    }
                }
            }
            return strContent;
        Err1:
            return Function.ErrInfo(1);
        }

        public static string DIY_ProductInfo(TSystemLable Array)
        {
            int SID = 0;
            // 判断是否出错
            //if (StrModule != "Supply_detail") goto Err0;
            int intID = Convert.ToInt32(HttpContext.Current.Request.QueryString["id"]);
            //int intID =100006 ;
            if (intID <= 0) goto Err1;

            TPurchase strInfo = new RPurchase().GateItem(intID);
            if (strInfo.ID <= 0)
            {
                return "该求购信息不存在！";
            }
            string strContent = Array.Content.ToString();  //取得用户自定义的标签内容
            string[] strAtttibute = Function.GetAttribute(strContent);
            if (strAtttibute.Length != 0)
            {
                for (int i = 0; i < strAtttibute.Length; i++)
                {
                    switch (strAtttibute[i].ToUpper())
                    {
                        case "{PR:WS_COMPANYNAME}":         //公司名称
                            if (strInfo.IsUser.Equals("True"))
                            {
                                TUserInfo t = new RUserInfo().GateItem(strInfo.UserID);
                                strContent = strContent.Replace(strAtttibute[i].ToString(), t.CompanyName);
                            }
                            else if (strInfo.IsUser.Equals("False"))
                            {
                                string CompanyName = GetVisitorComPanyName(strInfo.UserID);
                                strContent = strContent.Replace(strAtttibute[i].ToString(), CompanyName + " (非会员)");
                            }
                            break;
                        case "{PR:WS_BUSINESSMODE}":        //经营模式
                            if (strInfo.IsUser.Equals("True"))
                            {
                                TUserInfo t = new RUserInfo().GateItem(strInfo.UserID);
                                string[] strc;
                                string temp = "";
                                strc = (t.BusinessModel.ToString()).Split(new char[] { ',' });
                                foreach (string var in strc)
                                {
                                    if (var.Equals("0"))
                                    {
                                        temp += "生产型 |";
                                    }
                                    if (var.Equals("1"))
                                    {
                                        temp += " 贸易型 |";
                                    }
                                    if (var.Equals("2"))
                                    {
                                        temp += " 服务型 |";
                                    }
                                    if (var.Equals("3"))
                                    {
                                        temp += " 政府或其他机构 ";
                                    }
                                }
                                strContent = strContent.Replace(strAtttibute[i].ToString(), temp);
                            }
                            else if (strInfo.IsUser.Equals("False"))
                            {
                                string CompanyName = GetVisitorComPanyName(strInfo.UserID);
                                strContent = strContent.Replace(strAtttibute[i].ToString(), " (非会员)");
                            }
                            break;
                        case "{PR:WS_ADDRESS}":             //所在地
                            if (strInfo.IsUser.Equals("True"))
                            {
                                TUserInfo t = new RUserInfo().GateItem(strInfo.UserID);
                                strContent = strContent.Replace(strAtttibute[i].ToString(), t.Province + " " + t.City);
                            }
                            else if (strInfo.IsUser.Equals("False"))
                            {
                                strContent = strContent.Replace(strAtttibute[i].ToString(), " (非会员)");
                            }
                            break;
                        case "{PR:WS_ADDDATE}":            //发布时间                           
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.AddDate.ToShortDateString());
                            break;
                        case "{PR:WS_ENDDATE}":               //到期时间
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.EndDate.ToShortDateString());
                            break;
                        case "{PR:WS_TYPE}":               //规格型号
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Model);
                            break;
                        case "{PR:WS_DESCRIPTION}":        //详细信息
                            strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Info);
                            break;
                        case "{PR:WS_SAVEFAVORITES}":        //收藏信息
                            strContent = strContent.Replace(strAtttibute[i].ToString(), systemic.PR_SaveFavorites(strInfo.ID.ToString(), "purchase"));

                            break;
                        case "{PR:WS_QUOTATION}":        //点此报价
                            strContent = strContent.Replace(strAtttibute[i].ToString(), "{PB_WebUrl}Search/Quotation.aspx?id=" + strInfo.ID.ToString());
                            break;
                    }
                }
            }
            return strContent;
        Err1:
            return Function.ErrInfo(1);
        }

        public static string GetVisitorComPanyName(int ID)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString);
            SqlCommand cmd = new SqlCommand("SELECT CompanyName FROM [U_Visitor] WHERE ID=@ID", con);
            cmd.Parameters.AddWithValue("@ID", ID);
            con.Open();
            SqlDataReader sr = cmd.ExecuteReader();
            if (sr.Read())
            {
                return sr["CompanyName"].ToString();
            }
            con.Close();
            return "";
        }

    }
}