﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Data.SqlClient;
using nspLable.Manage;
using UserInfo;
using Base;
using Product;
namespace nspLable.Function.Systems
{

    /// <summary>
    /// Companylable 的摘要说明
    /// </summary>
    public class clsUserlable : nspLable.Function.Systems.systemic
    {

        /// <summary>
        /// 自定义会员信息
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string DIY_UserInfo(TSystemLable Array, string StrModule)
        {
            if (StrModule.Equals("Job_Detail") || (StrModule.Equals("Supply_Detail") || (HttpContext.Current.Request.Cookies["UserID"] != null && HttpContext.Current.Request.Cookies["UserID"].ToString() != "")))
            {
                int UID = 0;
                // 判断是否出错
                //if (StrModule != "Supply_detail") goto Err0;
                int intID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                if (intID <= 0) goto Err1;

                if (StrModule == "")
                    goto Err0;
                else
                {
                    DataTable strTable = new DataTable();
                    switch (StrModule.ToUpper())
                    {
                        case "SUPPLY_DETAIL":
                            strTable = Function.GetDataTable(" UserID as UID", " where ID=" + intID, " C_Supply");
                            UID = Convert.ToInt32(strTable.Rows[0]["UID"].ToString());
                            break;
                        case "PURCHASE_DETAIL":
                            strTable = Function.GetDataTable(" UserID as UID", " where ID=" + intID, " C_Purchase");
                            UID = Convert.ToInt32(strTable.Rows[0]["UID"].ToString());
                            break;
                        case "AGENT_DETAIL":
                            strTable = Function.GetDataTable(" UserID as UID", " where ID=" + intID, " W_SincereAgent");
                            UID = Convert.ToInt32(strTable.Rows[0]["UID"].ToString());
                            break;
                        case "JOB_DETAIL":
                            strTable = Function.GetDataTable(" UserID as UID", " where ID=" + intID, " [C_Job]");
                            UID = Convert.ToInt32(strTable.Rows[0]["UID"].ToString());
                            break;
                    }
                }

                TUserInfo strInfo = new RUserInfo().GateItem(UID);  //
                if (strInfo.UserID <= 0)
                {
                    return "该会员不存在！";
                }
                string strContent = Array.Content.ToString();  //取得用户自定义的标签内容
                string[] strAtttibute = Function.GetAttribute(strContent);
                if (strAtttibute.Length != 0)
                {
                    for (int i = 0; i < strAtttibute.Length; i++)
                    {
                        switch (strAtttibute[i].ToUpper())
                        {
                            case "{PR:WS_ID}":              //会员ID
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.UserID.ToString());
                                break;
                            case "{PR:WS_NAME}":               //联系人名称
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.LinkName.ToString());
                                break;
                            case "{PR:WS_SEX}":                //性别
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Sex.ToString());
                                break;
                            case "{PR:WS_POSITION}":           //职务
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Position.ToString());
                                break;
                            case "{PR:WS_TEL}":                //电话
                                string strTel = strInfo.Tel_International + " " + strInfo.Tel_DistrictNumber + " " + strInfo.Tel_Telephone + " " + strInfo.Tel_Ext;
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strTel);
                                break;
                            case "{PR:WS_FAX}":                //传真
                                string strFax = strInfo.Fax_International + " " + strInfo.Fax_DistrictNumber + " " + strInfo.Fax_Telephone + " " + strInfo.Fax_Ext;
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strFax);
                                break;
                            case "{PR:WS_COMPANYNAME}":        //公司名称
                                string str1 = "<a target=\"_blank\" href='" + "{Pb_WebUrl}shop/index/" + strInfo.LoginName + Base.BasePage.Config.Rewrite + "'>" + strInfo.CompanyName.ToString() + "</a>";
                                strContent = strContent.Replace(strAtttibute[i].ToString(), str1);
                                break;
                            case "{PR:WS_LOGO}":               //公司LOGO
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Logo.ToString());
                                break;
                            case "{PR:WS_MOBILEPHONE}":        //手机
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.MobilePhone.ToString());
                                break;
                            case "{PR:WS_QQ}":                 //QQ
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.QQ.ToString());
                                break;
                            case "{PR:WS_BUSINESSMODEL}":           //经营模式           
                                string[] strc;
                                string temp = "";
                                strc = (strInfo.BusinessModel.ToString()).Split(new char[] { ',' });
                                foreach (string var in strc)
                                {
                                    if (var.Equals("0"))
                                    {
                                        temp += "生产型 |";
                                    }
                                    if (var.Equals("1"))
                                    {
                                        temp += " 贸易型 |";
                                    }
                                    if (var.Equals("2"))
                                    {
                                        temp += " 服务型 |";
                                    }
                                    if (var.Equals("3"))
                                    {
                                        temp += " 政府或其他机构 ";
                                    }
                                }
                                strContent = strContent.Replace(strAtttibute[i].ToString(), temp);
                                break;
                            case "{PR:WS_SHOPURL}":              //商铺地址
                                strContent = strContent.Replace(strAtttibute[i].ToString(), "{PB_WEBUrl}Shop/index/" + strInfo.LoginName.ToString() + Base.BasePage.Config.Rewrite);
                                break;
                            case "{PR:WS_DEALINADD}":          //主要经营地址
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.DealinAdd.ToString());
                                break;
                            case "{PR:WS_EMAIL}":          //邮箱
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Email.ToString());
                                break;
                            case "{PR:WS_POSTALCODE}":         //邮编
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Postalcode.ToString());
                                break;
                            case "{PR:WS_SUMMARY}":         //邮编
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strInfo.Summary);
                                break;
                            case "{PR:WS_WEBURL}":             //公司网址
                                string str = "<a href='" + "{Pb_WebUrl}shops/index/" + strInfo.LoginName + ".html'>" + "{Pb_WebUrl}shops/index/" + strInfo.LoginName + Base.BasePage.Config.Rewrite + "</a>";
                                if (strInfo.URL.ToString() != "")
                                {
                                    str += "<br /><a href='" + strInfo.URL.ToString() + "'>" + strInfo.URL.ToString() + "</a>";
                                }
                                strContent = strContent.Replace(strAtttibute[i].ToString(), str);
                                break;
                            case "{PR:WS_ADDRESS}":            //地址
                                string strAddress = "";
                                if (strInfo.Country.ToString() == "中国")
                                {
                                    strAddress += strInfo.Country.ToString();
                                    strAddress += " " + strInfo.Province.ToString();
                                    strAddress += " " + strInfo.City.ToString();
                                    strAddress += strInfo.Area.ToString();
                                    strAddress += " " + strInfo.Street.ToString();
                                }
                                else
                                {
                                    strAddress = strInfo.Country.ToString();
                                }
                                strContent = strContent.Replace(strAtttibute[i].ToString(), strAddress);
                                break;
                        }
                    }
                }
                return strContent;

            }
            else
            {
                int intID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                if (intID <= 0) goto Err1;
                string ReturnUrl = Base.BasePage.Config.WebURL + "Purchase/detail-" + intID + BasePage.Config.Rewrite;
                string strdir = Base.XMLProcess.Read("xml/Label.config", "configuration/label[@type='Purchase_NotLogin']", "path");
                string Path = AppDomain.CurrentDomain.BaseDirectory.ToString() + "xml/" + strdir;
                string Content = Function.GetFile(Path);
                Content = Content.Replace("{PR:WS_Url}", ReturnUrl);
                return Content;
            }
        Err0:
            return Function.ErrInfo(2);
        Err1:
            return Function.ErrInfo(1);
        }

        /// <summary>
        /// 公司图文标签
        /// </summary>
        /// <param name="Array（15）">
        /// Num	        信息列表数目	
        /// RowsNum	    每行的列数	
        /// ProAttribute	信息列表属性	
        /// WhitchType	列表显示样式(0:只显示公司Logo，1: Logo+公司名称，Logo+公司名称+公司介绍)
        /// Target---（链接目标）
        /// Industry    行业类别
        /// Area
        /// OrderBy	    排序方式（0：ID升序；1：ID降序；2：时间升序；3：时间降序）	
        /// PicHeight	图片宽度	
        /// PicWidth	图片高度	
        /// PicClass	图片样式
        /// TitleSize	标题最多字符数
        /// TitleClass	标题样式
        /// SummarySize 简介字数
        /// SummaryClass简介样式
        /// <returns></returns>
        public static string SY_Companylist_Pic(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 15) goto Err;

            int Num = Convert.ToInt32(strContent[0].ToString());
            int RowsNum = Convert.ToInt32(strContent[1].ToString());
            string ProAttribute = strContent[2].ToString();
            int WhichType = Convert.ToInt32(strContent[3].ToString());
            string Target = strContent[4].ToString();
            string Industry = strContent[5].ToString();
            string Area = strContent[6].ToString();
            int OrderBy = Convert.ToInt32(strContent[7].ToString());
            int PicWidth = Convert.ToInt32(strContent[8].ToString());
            int PicHight = Convert.ToInt32(strContent[9].ToString());
            string PicClass = strContent[10].ToString();
            int TitleSize = Convert.ToInt32(strContent[11].ToString());
            string TitleClass = strContent[12].ToString();
            int SummarySize = 0;
            if (strContent[13] != null && strContent[13] != "")
                SummarySize = Convert.ToInt32(strContent[13].ToString());
            string SummaryClass = strContent[14].ToString();
            //需要取得的数据
            string strSelect;
            //读取几条信息
            if (Num <= 0)
                strSelect = "top 1  UserID as ID,CompanyName,Logo,Summary,LoginName";
            else
                strSelect = " top " + Num + " UserID as ID ,CompanyName,Logo,Summary ,LoginName";

            //查询条件
            StringBuilder strWhere = new StringBuilder();
            //所属类型 
            strWhere.Append("where 1=1 ");
            if (Industry.ToString().Length > 0 && Industry.ToString() != "0")
            {
                strWhere.Append("and Industry ='");
                strWhere.Append(Industry);
                strWhere.Append("' ");
            }

            // 排序方式
            string strOrder = "";
            if (OrderBy < 0) OrderBy = 0;
            switch (OrderBy)
            {
                case 0:
                    strOrder = " order by ID desc";
                    break;
                case 1:
                    strOrder = " order by ID asc";
                    break;
                case 2:
                    strOrder = " order by RegDate asc";
                    break;
                case 3:
                    strOrder = " order by RegDate desc";
                    break;

            }
            //获取数据表
            DataTable ProductList = Function.GetDataTable(strSelect, strWhere.ToString(), "U_UserInfo", strOrder);

            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("<table width='100%' border='0' cellpadding='0' cellspacing='0'><tr><td>" + "\r\n ");
            for (int i = 0; i < ProductList.Rows.Count; i++)
            {
                if (i > Num - 1) break; //如果超过显示的条数则跳出。
                switch (WhichType)
                {
                    case 0:  //只显示图片
                        strBuilder.Append(@"<table border='0' cellpadding='0' cellspaning='0'><tr><td>");
                        strBuilder.Append(@"<a href='{PB_WebURL}Shops/index/" + ProductList.Rows[i]["LoginName"].ToString() + ".html");
                        strBuilder.Append(@" ' Target='");
                        strBuilder.Append(Target);
                        strBuilder.Append(@"'>");
                        strBuilder.Append("<img width='");
                        strBuilder.Append(PicWidth);
                        strBuilder.Append(@"' height='");
                        strBuilder.Append(PicHight);
                        if (PicClass != "")
                        {
                            strBuilder.Append(@"' class='");
                            strBuilder.Append(PicClass);
                            strBuilder.Append("'");
                        }
                        strBuilder.Append(@" src='");
                        strBuilder.Append(Function.ProcessImageUrl(ProductList.Rows[i]["Logo"].ToString()));
                        strBuilder.Append(@"'></a>");
                        strBuilder.Append(@"</td></tr></table>" + "\r\n ");
                        break;
                    case 1: //显示图文
                        strBuilder.Append(@"<table border='0' cellpadding='0' cellspaning='0'><tr><td>");
                        strBuilder.Append(@"<a href='{PB_WebURL}Shops/index/" + ProductList.Rows[i]["LoginName"].ToString() + ".html");
                        strBuilder.Append(@" ' Target='");
                        strBuilder.Append(Target);
                        strBuilder.Append(@"'>");
                        strBuilder.Append("<img width='");
                        strBuilder.Append(PicWidth);
                        strBuilder.Append(@"' height='");
                        strBuilder.Append(PicHight);
                        if (PicClass != "")
                        {
                            strBuilder.Append(@"' class='");
                            strBuilder.Append(PicClass);
                            strBuilder.Append("'");
                        }
                        strBuilder.Append(@" src='");
                        strBuilder.Append(Function.ProcessImageUrl(ProductList.Rows[i]["Logo"].ToString()));
                        strBuilder.Append(@"'></a></td></tr>" + "\r\n " + "<tr><td>");
                        strBuilder.Append(@"<a href='{PB_WebURL}Shops/index/" + ProductList.Rows[i]["LoginName"].ToString() + ".html");
                        strBuilder.Append(@"' Target='");
                        strBuilder.Append(Target);
                        strBuilder.Append(@"'");
                        if (TitleClass != "")
                        {
                            strBuilder.Append(" class='" + TitleClass + "'");
                        }
                        strBuilder.Append(">");
                        if (TitleSize > 0) //设置标题字数
                            if (ProductList.Rows[i]["CompanyName"].ToString().Length > TitleSize)
                                strBuilder.Append(ProductList.Rows[i]["CompanyName"].ToString().Substring(0, TitleSize));
                            else
                                strBuilder.Append(ProductList.Rows[i]["CompanyName"].ToString());
                        else
                            strBuilder.Append(ProductList.Rows[i]["CompanyName"].ToString());
                        strBuilder.Append(@"</a>");
                        strBuilder.Append(@"</td><tr></table>" + "\r\n ");
                        break;
                    case 2: //显示图文
                        strBuilder.Append(@"<table><tr><td rowspan='2'>");
                        strBuilder.Append(@"<a href='{PB_WebURL}Shops/index/" + ProductList.Rows[i]["LoginName"].ToString() + ".html");
                        strBuilder.Append(@" ' Target='");
                        strBuilder.Append(Target);
                        strBuilder.Append(@"'>");
                        strBuilder.Append("<img width='");
                        strBuilder.Append(PicWidth);
                        strBuilder.Append(@"' height='");
                        strBuilder.Append(PicHight);
                        if (PicClass != "")
                        {
                            strBuilder.Append(@"' class='");
                            strBuilder.Append(PicClass);
                            strBuilder.Append("'");
                        }
                        strBuilder.Append(@" src='");
                        strBuilder.Append(Function.ProcessImageUrl(ProductList.Rows[i]["Logo"].ToString()));
                        strBuilder.Append(@"'></a></td><td>");
                        strBuilder.Append(@"<a href='{PB_WebURL}Shops/index/" + ProductList.Rows[i]["LoginName"].ToString() + Base.BasePage.Config.Rewrite);
                        strBuilder.Append(@"' Target='");
                        strBuilder.Append(Target);
                        strBuilder.Append(@"' class='");
                        strBuilder.Append(TitleClass);
                        strBuilder.Append(@"'>");
                        if (TitleSize > 0) //设置标题字数
                            if (ProductList.Rows[i]["CompanyName"].ToString().Length > TitleSize)
                                strBuilder.Append(ProductList.Rows[i]["CompanyName"].ToString().Substring(0, TitleSize));
                            else
                                strBuilder.Append(ProductList.Rows[i]["CompanyName"].ToString());
                        else
                            strBuilder.Append(ProductList.Rows[i]["CompanyName"].ToString());
                        strBuilder.Append(@"</a>");
                        strBuilder.Append(@"<td></tr>" + "\r\n " + "<tr><td>");
                        strBuilder.Append(@"<span class='");
                        strBuilder.Append(SummaryClass);
                        strBuilder.Append("'>");
                        if (TitleSize > 0) //设置公司简介
                            if (ProductList.Rows[i]["Summary"].ToString().Length > SummarySize)
                                strBuilder.Append(ProductList.Rows[i]["Summary"].ToString().Substring(0, SummarySize));
                            else
                                strBuilder.Append(ProductList.Rows[i]["Summary"].ToString());
                        else
                            strBuilder.Append(ProductList.Rows[i]["Summary"].ToString());
                        strBuilder.Append(@"</td><tr></table>" + "\r\n ");
                        break;

                    default:
                        strBuilder.Append(@"<table></tr><td>");
                        strBuilder.Append(" ");
                        strBuilder.Append(@"</td></tr></table>" + "\r\n ");
                        break;

                }

                //换行
                if (((i + 1) % RowsNum) == 0)
                {
                    if (i == (Num - 1))
                        strBuilder.Append(@" ");
                    else
                        strBuilder.Append(@"</td></tr>" + "\r\n " + "<tr><td>");
                }
                else
                    strBuilder.Append(@"</td>" + "\r\n " + "<td>");
            }
            strBuilder.Append(@"</td></tr></table>" + "\r\n ");
            return strBuilder.ToString();

        Err:
            return Function.ErrInfo(0);
        }

        /// <summary>
        /// 公司库首页私有变量处理方法
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_CorporationIndex(string Restr, string str)
        {
            Restr = Restr.Replace("{PR_KEYWORD}", "公司库信息");
            return Restr;
        }

        /// <summary>
        /// 公司库分类页私有变量处理方法
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_CorporationTrade(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');

            string TypeID = "0";
            if (HttpContext.Current.Request.QueryString["id"] != null && HttpContext.Current.Request.QueryString["id"] != "")
            {
                TypeID = HttpContext.Current.Request.QueryString["ID"];
            }
            Product.TIndustryType Items = new TIndustryType();
            Items.Type = "";
            if (TypeID != "0")
            {
                Items = new RIndustryType().GateItem(Convert.ToInt32(TypeID));
            }
            // Product.TIndustryType Items = new Product.RIndustryType().GateItem(TypeID);
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Type);
                            break;
                        case "{PR_TITLE}":                    //TITLE
                            Restr = Restr.Replace(strArray[i].ToString(), "公司库");
                            break;
                        case "{PR_METAKEYWORDS}":              //MATE关键字
                            Restr = Restr.Replace(strArray[i].ToString(), Base.XMLProcess.Read("Xml/Meta.xml", "/config/meta[@typeid='corporation_index']/keywords"));
                            break;
                        case "{PR_METADESCRIPTION}":          //MATE
                            Restr = Restr.Replace(strArray[i].ToString(), Base.XMLProcess.Read("Xml/Meta.xml", "/config/meta[@typeid='corporation_index']/descriptions"));
                            break;
                        case "{PR_LOWERTYPE}":
                            Restr = Restr.Replace(strArray[i].ToString(), lowerType(Convert.ToInt32(TypeID), "Company"));
                            break;
                        case "{PR_TYPELINK}":
                            if (TypeID == "0")
                            {
                                Restr = Restr.Replace(strArray[i].ToString(), "");
                            }
                            else
                            {
                                Restr = Restr.Replace(strArray[i].ToString(), TypeLink(TypeID, 1));
                            }
                            break;
                        case "{PR_COUNT}":   //供应的总数    
                            string str1 = "U_UserInfo.Verify=1 AND U_UserInfo.GradeID=U_VipGrade.ID and datediff(hh,U_UserInfo.EndDate,getdate())>0";
                            if (TypeID != "0")
                            {
                                str1 += " and U_UserInfo.Industry like '%" + TypeID + "%'";
                            }
                            DataTable table = Base.PageList.GetDataTable(str1,"U_UserInfo,U_VipGrade");
                            string count = table.Rows[0]["Total"].ToString();
                            Restr = Restr.Replace(strArray[i].ToString(), count);
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;


        }

        /// <summary>
        /// 公司库详细页私有变量处理方法
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_CorporationDetail(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');

            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_TITLE}":                    //TITLE
                            Restr = Restr.Replace(strArray[i].ToString(), "公司库");
                            break;
                        default:
                            Restr = Restr;
                            break;

                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;


        }

        /// <summary>
        /// 公司图文标签
        /// </summary>
        /// <param name="Array（15）">
        /// strIndustry   
        /// strArea
        /// intNum
        /// intRowNum
        /// strClass
        /// strGradeID
        /// strOrderBy
        /// <returns></returns>
        public static string SY_CompanyList_Str(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 9)
            {
                throw new Exception(Function.ErrInfo(0));
            }

            string strIndustry = strContent[0].ToString();
            string strArea = strContent[1].ToString();
            string strGradeID = strContent[2].ToString();
            int intNum = 1;
            if (Base.Common.CheckNum(strContent[3].ToString()))
            {
                intNum = int.Parse(strContent[3].ToString());
            }
            int intRowNum = Base.Common.CheckNum(strContent[4].ToString()) ? int.Parse(strContent[4].ToString()) : 1;
            string strClass = strContent[7].ToString();
            int intTitleLength = Base.Common.CheckNum(strContent[6].ToString()) ? int.Parse(strContent[6].ToString()) : 0;
            string strOrderBy = strContent[5].ToString();
            string strTarget = strContent[8].ToString();
            // string CssClass = "class_list Mark";
            string target = "_blank";

            //需要取得的数据
            string strSelect;
            //读取几条信息
            if (intNum <= 0)
                strSelect = " top 1  LoginName ,CompanyName";
            else
                strSelect = " top " + intNum + " LoginName,CompanyName";
            string strWhere = " where 1=1";

            if (strArea != "0" && strArea != "" && !strArea.Equals("全国"))
            {
                strWhere += " and Province ='" + strArea + "'";
            }
            if (strGradeID != "0")
            {
                strWhere += " and  GradeID=" + strGradeID;
            }

            string strOrder = "";
            switch (strOrderBy)
            {
                case "0":
                    strOrder = " order by UserID asc";
                    break;
                case "1":
                    strOrder = " order by UserID desc";
                    break;
                case "2":
                    strOrder = " order by RegDate asc";
                    break;
                case "3":
                    strOrder = " order by RegDate desc";
                    break;

            }
            StringBuilder strBuilder = new StringBuilder();
            //获取数据表
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), "U_UserInfo", strOrder);
            if (Lists.Rows.Count <= 0)
            {
                return "还没有会员！";
            }
            else
            {

                int intCount = Lists.Rows.Count;

                int intCell = intRowNum;
                int intRow = intCount % intCell == 0 ? intCount / intCell : intCount / intCell + 1;
                strBuilder.Append("<table width='100%'  border=\"0\" cellpadding=\"0\" cellspacing=\"0\">" + "\r\n ");
                for (int i = 0; i < intRow; i++)
                {
                    strBuilder.Append("<tr>" + "\r\n ");
                    for (int j = 0; j < intCell; j++)
                    {
                        int m = i * intCell + j;
                        if (m > intCount - 1 || m > intNum) break;
                        strBuilder.Append("<td ");
                        if (strClass != null || strClass != "")
                        {
                            strBuilder.Append(" class='" + strClass + "'");
                        }
                        strBuilder.Append(">");
                        strBuilder.Append("<a href=\"{pb_webUrl}shop/index/" + Lists.Rows[m]["LoginName"].ToString() + Base.BasePage.Config.Rewrite + "\" target=\"" + target + "\">");
                        strBuilder.Append(Function.GetString(Lists.Rows[m]["CompanyName"].ToString(), intTitleLength));
                        strBuilder.Append("</a>");
                        strBuilder.Append("</td>" + "\r\n ");
                    }
                    strBuilder.Append("</tr>" + "\r\n ");
                }
                strBuilder.Append(@"</table>" + "\r\n ");
            }
            return strBuilder.ToString();

        }

        /// <summary>
        ///  公司列表（仅限在公司分类页中使用）
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string DIY_Companylist(TSystemLable Array, string strModule)
        {
            // 对标签使用条件进行检查
            if (!strModule.Contains("Company_Trade")) throw new Exception(Function.ErrInfo(2));
            string strWhere = " U_UserInfo.Verify=1 AND U_UserInfo.GradeID=U_VipGrade.ID and datediff(hh,U_UserInfo.EndDate,getdate())>0";
            int TypeID = 0;
            if (Function.CheckQueryStringisInt("id"))
            {
                TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["id"]);
                strWhere += " and patindex('%,'+rtrim( " + TypeID + ")+',%',','+ Industry+',')>0 ";
            }

            int PageID = 1;
            if (Function.CheckQueryStringisInt("page"))
            {
                PageID = Convert.ToInt32(HttpContext.Current.Request.QueryString["Page"]);
            }
            if (PageID < 1) PageID = 1;

            // 定义全局变量，最后返回
            StringBuilder ReBulider = new StringBuilder();

            // 求购列表头部
            string strHead = "";
            strHead = Array.Head;
            ReBulider.Append(strHead);

            string strTable = " U_UserInfo,U_VipGrade ";
            int OrderType = 0;
            string OrderField = " Sort desc ,RegDate ";
            string strSelect = " U_UserInfo.*,U_VipGrade.Flag ";
            int PageSize = 10;
            if (Array.Info != null)
            {
                string[] strInfo1 = Array.Info.Split('|');
                for (int k = 0; k < strInfo1.Length; k++)
                {
                    if (k == 0)
                    {
                        if (GetRequest.isNum(strInfo1[k].ToString()))
                        {
                            PageSize = Int32.Parse(strInfo1[k].ToString());
                        }
                    }
                    else if (k == 1)
                    {
                        if (GetRequest.isNum(strInfo1[k].ToString()))
                        {
                            string strType = strInfo1[k].ToString();
                            switch (strType)
                            {
                                case "0": OrderType = 0; OrderField = " U_UserInfo.StartDate asc, U_UserInfo.GradeID "; break;
                                case "1": OrderType = 1; OrderField = " U_UserInfo.StartDate desc, U_UserInfo.GradeID "; break;
                                case "2": OrderType = 1; OrderField = " U_UserInfo.GradeID desc, U_UserInfo.StartDate "; break;
                                case "3": OrderType = 0; OrderField = " U_UserInfo.GradeID asc, U_UserInfo.StartDate "; break;

                            }
                        }
                    }
                }
            }
            int PageIndex = 1;
            if (HttpContext.Current.Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(HttpContext.Current.Request.QueryString["Page"]);
            if (PageIndex < 1) PageIndex = 1;
            int Count = 0;

            DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count, "U_UserInfo.UserID");
            if (Lists.Rows.Count < 0)
            {
                ReBulider.Append("暂无此类产品");
            }
            else
            {
                string strInfo = Array.Content.ToString();
                string[] strAtttibute = Function.GetAttribute(strInfo);
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strInfo = Array.Content.ToString();
                    for (int j = 0; j < strAtttibute.Length; j++)
                    {
                        switch (strAtttibute[j].ToUpper())
                        {
                            case "{PR:WS_ID}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["ID"].ToString());
                                break;
                            case "{PR:WS_SHOP}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_webUrl}shop/index/" + Lists.Rows[i]["LoginName"].ToString() + Base.BasePage.Config.Rewrite);
                                break;
                            case "{PR:WS_COMPANYNAME}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["CompanyName"].ToString());
                                break;
                            case "{PR:WS_LOGO}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.ProcessImageUrl(Lists.Rows[i]["logo"].ToString()));
                                break;
                            case "{PR:WS_LEVEL}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "<img src=\"" + Lists.Rows[i]["Flag"].ToString() + "\"/>");
                                break;
                            case "{PR:WS_INFO}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Base.Common.RemoveHTML(Function.GetString(Lists.Rows[i]["Summary"].ToString(), 150)));
                                break;
                            case "{PR:WS_SUMMARY}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Base.Common.RemoveHTML(Function.GetString(Lists.Rows[i]["Summary"].ToString(), 150)));
                                break;
                            case "{PR:WS_BUSSINESSMODEL}":
                                string[] strc;
                                string temp = "";
                                strc = (Lists.Rows[i]["BusinessModel"].ToString()).Split(new char[] { ',' });
                                foreach (string var in strc)
                                {
                                    if (var.Equals("0"))
                                    {
                                        temp += "生产型 |";
                                    }
                                    if (var.Equals("1"))
                                    {
                                        temp += " 贸易型 |";
                                    }
                                    if (var.Equals("2"))
                                    {
                                        temp += " 服务型 |";
                                    }
                                    if (var.Equals("3"))
                                    {
                                        temp += " 政府或其他机构";
                                    }
                                }
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), temp);
                                break;
                            case "{PR:WS_AREA}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Province"].ToString() + " " + Lists.Rows[i]["City"].ToString());
                                break;
                            case "{PR:WS_CAPITAL}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Capital"].ToString() + "万元");
                                break;
                            case "{PR:WS_ADDDATE}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["StartDate"].ToString());
                                break;
                            case "{PR:WS_GALAXIECHAT}":           //在线交流
                                string str = "";
                                if (Lists.Rows[i]["QQ"].ToString() != "")
                                    str = "<a target=\"blank\" href=\"http://wpa.qq.com/msgrd?V=1&Uin=" + Lists.Rows[i]["QQ"].ToString() + "&Exe=QQ&Site=im.qq.com&Menu=No\"><img style=\" border:0\" src=\"{pb_weburl}images/b_online.gif\" alt=\"给我发消息\" /></a>";
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), str);
                                break;

                        }
                    }
                    //  if (i > Num - 1) break; //如果超过显示的条数则跳出。


                    ReBulider.Append(strInfo);
                    ReBulider.Append(System.Environment.NewLine);
                }
            }


            //求购列表尾部
            string strFooter = "";
            strFooter = Array.Footer;
            ReBulider.Append(strFooter);

            string strUrl = "{PB_WebURL}Company/Trade";
            if (PageID <= 0) PageID = 1;
            if (TypeID != 0)
            {
                strUrl += "-" + TypeID;
            }
            strUrl += "-p";

            string Pages = Pagination.GoToPager(PageID, PageSize, strUrl, strWhere, strTable);
            ReBulider.Append(Pages);
            return ReBulider.ToString();

        Err0:
            return Function.ErrInfo(2);
        Err1:
            return Function.ErrInfo(1);

        }

        private static string GetVipGrade(int GradeID)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqldata"].ConnectionString);
            SqlCommand cmd = new SqlCommand("SELECT [Flag] FROM [U_VipGrade] WHERE ID=@ID", con);
            cmd.Parameters.AddWithValue("@ID", GradeID);
            con.Open();
            SqlDataReader sr = cmd.ExecuteReader();
            if (sr.Read())
            {
                return sr["Flag"].ToString();
            }
            con.Close();
            return "";
        }
        /// <summary>
        /// 行业类别链表
        /// </summary>
        /// <param name="strType">行业ID字符串</param>
        /// <param name="param">0:分类页, 1:详细页</param>
        /// <returns></returns>
        private static string TypeLink(string strTypeLink, int param)
        {
            if (strTypeLink == "")
            {
                return "";
            }
            else if (strTypeLink[strTypeLink.Length - 1] == ',')
            {
                strTypeLink = strTypeLink.TrimEnd(new char[',']);
            }

            try
            {
                DataTable TypeData = new DataTable();
                if (param == 0)
                    TypeData = Function.GetDataTable("Type,ID", "where ID in(" + strTypeLink + ") ", "W_IndustryType", " order by SuperiorsFlag  ");
                else
                {
                    SqlParameter[] param1 = new SqlParameter[] 
                    {  
                        new SqlParameter("@ID",Convert.ToInt32(strTypeLink))
                    };
                    TypeData = SqlOperate.SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_W_TypeLink", param1);
                }
                string strType = "";
                string str = "<a href='trade-";

                if (TypeData.Rows.Count > 0)
                {
                    for (int i = 0; i < TypeData.Rows.Count; i++)
                    {
                        strType += " > " + str;
                        strType += TypeData.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite;
                        strType += "'>";
                        strType += TypeData.Rows[i]["Type"].ToString();
                        strType += "</a>";
                    }
                }
                return strType;
            }
            catch (Exception ex)
            {
                return ex.Message.ToString();
            }
        }
    }
}