﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using Base;
using nspLable.Function;
using System.Text;
namespace nspLable.Function.Systems
{
    /// <summary>
    /// WebNewsLabel 的摘要说明
    /// </summary>
    public class WebNewsLabel
    {
        public static string PR_Trade(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_TYPELINK}":
                            Restr = Restr.Replace(strArray[i].ToString(), PR_TypeLink());
                            break;
                        case "{PR_LIST}":
                            Restr = Restr.Replace(strArray[i].ToString(), PR_List());
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }

        public static string PR_TypeLink()
        {
            if (HttpContext.Current.Request.QueryString["id"] == "" || HttpContext.Current.Request.QueryString["id"] == null)
                return "公告首页";
            else
            {
                string ID = GetRequest.GetQueryStringValue("id");
                if (ID.Equals("1"))
                    return "网站公告";
                else if (ID.Equals("2"))
                    return "网站活动";
                else if (ID.Equals("3"))
                    return "网站新闻";
            }
            return "错误请求";
        }



        /// <summary>
        /// 站内信息列表 
        /// </summary>
        /// <returns></returns>
        public static string PR_List()
        {
            StringBuilder ReBulider = new StringBuilder();
            string strSelect = "ID,Title,AddDate";
            string strWhere = " 1=1 ";
            string strTable = "W_WebNews";
            int PageSize = 10;
            int PageIndex = 1;
            int OrderType = 1;
            string OrderField = "AddDate";
            int Count = 0;
            if (HttpContext.Current.Request.QueryString["id"] == "" || HttpContext.Current.Request.QueryString["id"] == null)
            {
                DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);
                if (Lists.Rows.Count == 0)
                {
                    return "暂无信息!";
                }
                else
                {
                    ReBulider.Append("<ul>");
                    for (int i = 0; i < Lists.Rows.Count; i++)
                    {
                        ReBulider.Append("<li><a href=\"{PB_WebUrl}WebNews/detail-");
                        ReBulider.Append(Lists.Rows[i]["id"].ToString());
                        ReBulider.Append(BasePage.Config.Rewrite + "\"");
                        ReBulider.Append(">" + Lists.Rows[i]["Title"].ToString());
                        ReBulider.Append("&nbsp;&nbsp;");
                        ReBulider.Append(DateTime.Parse(Lists.Rows[i]["AddDate"].ToString()).ToShortDateString() + "</a> <br/><br/>");
                        ReBulider.Append("</li>");
                    }
                    ReBulider.Append("</ul>");
                }
                return ReBulider.ToString();
            }
            else
            {
                string strType = GetRequest.GetQueryStringValue("id");
                if (strType == "")
                {
                    return "不存在该类型的信息！";
                }
                //判断是哪个类型的新闻取得数据信息
                if (strType.Equals("1"))             //网站公告
                {
                    strWhere = " Type='网站公告' ";
                }
                else if (strType.Equals("2"))        //网站活动
                {
                    strWhere = " Type='网站活动' ";
                }
                else if (strType.Equals("3"))         //网站新闻
                {
                    strWhere = " Type='网站新闻' ";
                }
                DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);
                if (Lists.Rows.Count == 0)
                {
                    return "暂无该类型信息！";
                }
                else
                {
                    ReBulider.Append("<ul>");
                    for (int i = 0; i < Lists.Rows.Count; i++)
                    {
                        ReBulider.Append("<li><a href=\"detail-");
                        ReBulider.Append(Lists.Rows[i]["id"].ToString());
                        ReBulider.Append(BasePage.Config.Rewrite + "\"");
                        ReBulider.Append(">" + Lists.Rows[i]["Title"].ToString());
                        ReBulider.Append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        ReBulider.Append(DateTime.Parse(Lists.Rows[i]["AddDate"].ToString()).ToShortDateString() + "</a> <br/><br/>");
                        ReBulider.Append("</li>");
                    }
                    ReBulider.Append("</ul>");
                }
                return ReBulider.ToString();
            }
        }

        public static string PR_Detail(string Restr, string str)
        {
            if (HttpContext.Current.Request.QueryString["ID"] == "" || HttpContext.Current.Request.QueryString["ID"] == null)
                return Restr;
            if (!Function.CheckQueryStringisInt("ID"))
                return Restr;
            string[] strArray;
            strArray = str.Split('|');
            //返回查询结果
            DataTable Lists = Function.GetDataTable("SELECT * FROM [W_WebNews] WHERE ID=" + HttpContext.Current.Request.QueryString["ID"]);
            //是否存在类别
            if (Lists.Rows.Count > 0)
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_TYPELINK}":
                            Restr = Restr.Replace(strArray[i].ToString(), Lists.Rows[0]["Type"].ToString());
                            break;
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Lists.Rows[0]["Title"].ToString());
                            break;
                        case "{PR_ORIGIN}":
                            Restr = Restr.Replace(strArray[i].ToString(), "信息来源 :  " + Lists.Rows[0]["Origin"].ToString());
                            break;
                        case "{PR_PICTURE}":
                            if (Lists.Rows[0]["Picture"].ToString() != "")
                                Restr = Restr.Replace(strArray[i].ToString(), "<img src=\"" + Lists.Rows[0]["Picture"].ToString() + "\"/>");
                            else
                                Restr = Restr.Replace(strArray[i].ToString(), "");
                            break;
                        case "{PR_DETAIL}":
                            Restr = Restr.Replace(strArray[i].ToString(), Lists.Rows[0]["Detail"].ToString());
                            break;
                        case "{PR_ADDDATE}":
                            Restr = Restr.Replace(strArray[i].ToString(), "发布日期 : "+Lists.Rows[0]["AddDate"].ToString());
                            break;
                    }
                }
            }
            else
                Restr = "不存在公告信息!";
            return Restr;
        }
    }
}