﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_SystemLable 的摘要说明
/// </summary>
namespace nspLable.Manage
{
    public class RSystemLable : ISystemLable
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region ISystemLable 成员

        /// <summary>
        /// 添加系统标签
        /// </summary>
        /// <param name="eui">系统标签对象</param>
        /// <returns></returns>
        public int Insert(TSystemLable eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@Name", eui.Name),
					new SqlParameter("@TypeID", eui.TypeID),
                    new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Info", eui.Info),
					new SqlParameter("@Remarks", eui.Remarks),
                    new SqlParameter("@Head",eui.Head),
                    new SqlParameter("@Content",eui.Content),
                    new SqlParameter("@Footer",eui.Footer)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_SystemLable_Add", commandParameters);
        }
        /// <summary>
        /// 修改系统标签
        /// </summary>
        /// <param name="eui">系统标签对象</param>
        /// <returns></returns>
        public int Update(TSystemLable eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID",eui.ID),
                    new SqlParameter("@Name", eui.Name),
					new SqlParameter("@TypeID", eui.TypeID),
                    new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Info", eui.Info),
					new SqlParameter("@Remarks", eui.Remarks),
                    new SqlParameter("@Head",eui.Head),
                    new SqlParameter("@Content",eui.Content),
                    new SqlParameter("@Footer",eui.Footer)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_SystemLable_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除系统标签
        /// </summary>
        /// <param name="ID">系统标签ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_SystemLable") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有系统标签
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
              
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "View_SystemLable_SystemLableType"), 
                new SqlParameter("@strOrder",  "order by ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        ///// <summary>
        ///// 根据系统标签ID得到系统标签信息
        ///// </summary>
        ///// <param name="ParamID"></param>
        ///// <returns></returns>
        //public DataTable GetDataTable(int ParamID)
        //{
        //    SqlParameter[] param = new SqlParameter[] 
        //    {
        //        new SqlParameter("@strwhere", "where ID=" + ParamID),
        //        new SqlParameter("@strtableName", "W_SystemLable"), 
        //        new SqlParameter("@strOrder", "order by ID desc") 
        //    };
        //    return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        //}
        /// <summary>
        /// 根据系统标签类别ID得到相应的系统标签信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where TypeID=" + ParamID),
                new SqlParameter("@strtableName", "W_SystemLable"), 
                new SqlParameter("@strOrder", "order by ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据系统标签名，备注，所属类型查询系统标签信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TSystemLable eui)
        {
            string str = "where 1=1";
            if (eui.Name != "")
            {
                str = str + " and Name like '%" + eui.Name + "%' ";
            }
            if (eui.Remarks != "")
            {
                str = str + " and Remarks like '%" + eui.Remarks + "%' ";
            }
            if (eui.TypeID != 0)
            {
                str = str + " and TypeID =" + eui.TypeID;
            }

            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "View_SystemLable_SystemLableType"), 
                new SqlParameter("@strOrder", "order by ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据系统标签ID得到每一条系统标签信息
        /// </summary>
        /// <param name="ID">系统标签ID</param>
        /// <returns></returns>
        public TSystemLable GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "W_SystemLable"), 
                new SqlParameter("@strOrder", "") 
            };
            TSystemLable info = new TSystemLable();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }

                info.Name = reader["Name"].ToString();

                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeID = int.Parse(reader["TypeID"].ToString());
                }
                info.Title = (reader["Title"].ToString());
                info.Info = reader["Info"].ToString();
                info.Remarks = (reader["Remarks"].ToString());
                info.Head = (reader["Head"].ToString());
                info.Content = reader["Content"].ToString();
                info.Footer = (reader["Footer"].ToString());
            }
            return info;
        }

        /// <summary>
        /// 返回参数
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TSystemLable GateItem(string parameter)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where Name='" + parameter+"'"), 
                new SqlParameter("@strTableName", "W_SystemLable"), 
                new SqlParameter("@strOrder", "") 
            };
            TSystemLable info = new TSystemLable();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["Name"].ToString() != "")
                {
                    info.Name = reader["Name"].ToString();
                }
                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeID = int.Parse(reader["TypeID"].ToString());
                }
                if (reader["Title"].ToString() != "")
                {
                    info.Title = (reader["Title"].ToString());
                }
                if (reader["Info"].ToString() != "")
                {
                    info.Info = reader["Info"].ToString();
                }
                if (reader["Remarks"].ToString() != "")
                {
                    info.Remarks = (reader["Remarks"].ToString());
                }
                if (reader["Head"].ToString() != "")
                {
                    info.Head = (reader["Head"].ToString());
                }
                if (reader["Content"].ToString() != "")
                {
                    info.Content = reader["Content"].ToString();
                }
                if (reader["Footer"].ToString() != "")
                {
                    info.Footer = (reader["Footer"].ToString());
                }


            }
            return info;
        }
        #endregion
    }
}
