﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_SystemLableType 的摘要说明
/// </summary>
namespace nspLable.Manage
{
    public class RSystemLableType:ISystemLableType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region ISystemLableType 成员

        /// <summary>
        /// 添加系统标签类型
        /// </summary>
        /// <param name="eui">系统标签类型对象</param>
        /// <returns></returns>
        public int Insert(TSystemLableType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@Name", eui.Name),
                    new SqlParameter("@ParentID",eui.ParentID)
					
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_SystemLableType_Add", commandParameters);
        }
        /// <summary>
        /// 修改系统标签类型
        /// </summary>
        /// <param name="eui">系统标签类型对象</param>
        /// <returns></returns>
        public int Update(TSystemLableType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID",eui.ID),
                    new SqlParameter("@Name", eui.Name)
			};
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_SystemLableType_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除系统标签类型
        /// </summary>
        /// <param name="ID">系统标签类型ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@ID", ID)
            };
            return SqlHelper.DeleteByWhere("SP_W_SystemLableType_Delete", param);

        }
        /// <summary>
        /// 得到所有系统标签类型
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_SystemLableType"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据系统标签类型ID得到系统标签类型信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ParentID=" + ParamID),
                new SqlParameter("@strtableName", "W_SystemLableType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据系统标签类型ID得到每一条系统标签类型信息
        /// </summary>
        /// <param name="ID">系统标签类型ID</param>
        /// <returns></returns>
        public TSystemLableType GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "W_SystemLableType"), 
                new SqlParameter("@strOrder", "") 
            };
            TSystemLableType info = new TSystemLableType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
            }
            return info;
        }
        #endregion

    }
}
