﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_UserLable 的摘要说明
/// </summary>
namespace nspLable.Manage
{
    public class RUserLable : IUserLable
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IUserLable 成员

        /// <summary>
        /// 添加用户标签
        /// </summary>
        /// <param name="eui">用户标签对象</param>
        /// <returns></returns>
        public int Insert(TUserLable eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@LableName", eui.LableName),
                    new SqlParameter("@TypeID", eui.TypeID),
					new SqlParameter("@Info", eui.Info),
                    new SqlParameter("@Remarks", eui.Remarks)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_UserLable_Add", commandParameters);
        }
        /// <summary>
        /// 修改用户标签
        /// </summary>
        /// <param name="eui">用户标签对象</param>
        /// <returns></returns>
        public int Update(TUserLable eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID",eui.ID),
                    new SqlParameter("@TypeID", eui.TypeID),
                    new SqlParameter("@LableName", eui.LableName),
					new SqlParameter("@Info", eui.Info),
                    new SqlParameter("@Remarks", eui.Remarks)
               
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_UserLable_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除用户标签
        /// </summary>
        /// <param name="ID">用户标签ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_UserLable") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有用户标签
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_UserLable"), 
                new SqlParameter("@strOrder", " order by AddDate desc,ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        ///// <summary>
        ///// 根据用户标签ID得到用户标签信息
        ///// </summary>
        ///// <param name="ParamID"></param>
        ///// <returns></returns>
        //public DataTable GetDataTable(int ParamID)
        //{
        //    SqlParameter[] param = new SqlParameter[] 
        //    {
        //        new SqlParameter("@strwhere", "where ID=" + ParamID),
        //        new SqlParameter("@strtableName", "W_UserLable"), 
        //        new SqlParameter("@strOrder", " order by AddDate desc,ID desc") 
        //    };
        //    return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        //}
        /// <summary>
        /// 根据用户标签类别ID得到用户标签相应的信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where TypeID=" + ParamID),
                new SqlParameter("@strtableName", "W_UserLable"), 
                new SqlParameter("@strOrder", " order by AddDate desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据用户标签ID得到用户标签每一条信息
        /// </summary>
        /// <param name="ID">用户标签ID</param>
        /// <returns></returns>
        public TUserLable GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "W_UserLable"), 
                new SqlParameter("@strOrder", "") 
            };
            TUserLable info = new TUserLable();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeID = int.Parse(reader["TypeID"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                info.LableName = reader["LableName"].ToString();
                info.Info = reader["Info"].ToString();
                info.Remarks = (reader["Remarks"].ToString());
            }
            return info;
        }


        public TUserLable GateItem(string Parame)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where LableName='" + Parame+"'"), 
                new SqlParameter("@strTableName", "W_UserLable"), 
                new SqlParameter("@strOrder", "") 
            };
            TUserLable info = new TUserLable();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeID = int.Parse(reader["TypeID"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                if (reader["LableName"].ToString() != "")
                {
                    info.LableName = reader["LableName"].ToString();
                }
                if (reader["Info"].ToString() != "")
                {
                    info.Info = reader["Info"].ToString();
                }
                if (reader["Remarks"].ToString() != "")
                {
                    info.Remarks = (reader["Remarks"].ToString());
                }


            }
            return info;
        }
        #endregion
    }
}
