﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_UserLableType 的摘要说明
/// </summary>
namespace nspLable.Manage
{
    public class RUserLableType:IUserLableType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IUserLableType 成员

        /// <summary>
        /// 添加用户标签类型
        /// </summary>
        /// <param name="eui">用户标签类型对象</param>
        /// <returns></returns>
        public int Insert(TUserLableType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@Name", eui.Name)
					
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_UserLableType_Add", commandParameters);
        }
        /// <summary>
        /// 修改用户标签类型
        /// </summary>
        /// <param name="eui">用户标签类型对象</param>
        /// <returns></returns>
        public int Update(TUserLableType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID",eui.ID),
                    new SqlParameter("@Name", eui.Name)
			};
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_UserLableType_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除用户标签类型
        /// </summary>
        /// <param name="ID">用户标签类型ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_UserLableType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有用户标签类型
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_UserLableType"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据用户标签类型ID得到用户标签类型信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID=" + ParamID),
                new SqlParameter("@strtableName", "W_UserLableType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据用户标签类型ID得到每一条用户标签类型信息
        /// </summary>
        /// <param name="ID">用户标签类型ID</param>
        /// <returns></returns>
        public TUserLableType GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "W_UserLableType"), 
                new SqlParameter("@strOrder", "") 
            };
            TUserLableType info = new TUserLableType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
       
            }
            return info;
        }
        #endregion
    }
}
