﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_MetaInfo 的摘要说明
/// </summary>
namespace MetaInfo
{
    public class RMetaInfo : IMetaInfo
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IMetaInfo 成员

        /// <summary>
        /// 修改网站Meta信息
        /// </summary>
        /// <param name="eui">网站MetaMeta信息对象<</param>
        /// <returns></returns>
        public int Update(TMetaInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                 new SqlParameter("@Type", eui.Type),
                 new SqlParameter("@Title",eui.Title),
                 new SqlParameter("@Keywords", eui.Keywords),
                 new SqlParameter("@Descriptions", eui.Descriptions)
			};
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_MetaInfo_Update", commandParameters);
        }


        /// <summary>
        /// 根据ID网站MMeta信息
        /// </summary>
        /// <param name="ID">网站Meta信息ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_MetaInfo") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有网站Meta信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName","W_MetaInfo"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据id得到网站Meta信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(string type)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere","where Type='"+type+"'"),
                new SqlParameter("@strtableName", "W_MetaInfo"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到每一条网站Meta信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TMetaInfo GetItem(string type)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where Type='"+type+"'"),
                new SqlParameter("@strTableName", "W_MetaInfo"), 
                new SqlParameter("@strOrder", "") 
            };
            TMetaInfo info = new TMetaInfo();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                info.Type = reader["Type"].ToString();
                info.Title = reader["Title"].ToString();
                info.Keywords = reader["Keywords"].ToString();
                info.Descriptions = reader["Descriptions"].ToString();

            }
            return info;
        }
        #endregion
    }
}
