﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_MetaType 的摘要说明
/// </summary>
namespace MetaType
{
    public class RMetaType:IMetaType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IMetaType 成员
        /// <summary>
        /// 添加网站Meta类别
        /// </summary>
        /// <param name="eui">网站Meta类别对象</param>
        /// <returns></returns>
        public int Insert(TMetaType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                     new SqlParameter("@Type", eui.Type)
			};
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_MetaType_Add", commandParameters);
        }
        /// <summary>
        /// 修改网站Meta类别
        /// </summary>
        /// <param name="eui">网站Meta类别对象<</param>
        /// <returns></returns>
        public int Update(TMetaType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("ID",eui.ID),
                    new SqlParameter("@Type", eui.Type)
			};
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_MetaType_Update", commandParameters);
        }
       

        /// <summary>
        /// 根据ID网站Meta类别
        /// </summary>
        /// <param name="ID">网站Meta类别ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_MetaType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有网站Meta类别
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName","W_MetaType"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据id得到网站Meta类别
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere","where ID="+id),
                new SqlParameter("@strtableName", "W_MetaType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到每一条网站Meta类别
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TMetaType GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_MetaType"), 
                new SqlParameter("@strOrder", "") 
            };
            TMetaType info = new TMetaType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                info.Type = reader["Type"].ToString();
             }
            return info;
        }
        #endregion
    }
}
