﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_Favorites 的摘要说明
/// </summary>
namespace Favorites
{
    public class RFavorites:IFavorites
    {

        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IFavorites 成员

        
        /// <summary>
        /// 添加搜藏信息
        /// </summary>
        /// <param name="eui">搜藏信息对象</param>
        /// <returns></returns>
        public int Insert(TFavorites eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]{                
                new SqlParameter("@ProductID", eui.ProductID),
				new SqlParameter("@UserID", eui.UserID),
				new SqlParameter("@Type",eui.Type)
		    };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_Favorites_Add", commandParameters);
        }

        /// <summary>
        /// 根据ProductID删除搜藏信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ProductID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "U_Favorites") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有搜藏信息
        /// </summary>
        /// <returns></returns>

        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere",""),
                new SqlParameter("@strtableName", "U_Favorites"), 
                new SqlParameter("@strOrder", " order by EditDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据strWhere得到所有搜藏信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", strWhere),
                new SqlParameter("@strtableName", "U_Favorites"), 
                new SqlParameter("@strOrder", " order by EditDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到所有搜藏信息每一条信息
        /// </summary>
        /// <param name="ID">搜藏信息ID</param>
        /// <returns></returns>
        public TFavorites GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "U_Favorites"), 
                new SqlParameter("@strOrder", "") 
            };
            TFavorites info = new TFavorites();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["ProductID"].ToString() != "")
                {
                    info.ProductID = Convert.ToInt32(reader["ProductID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = Convert.ToInt32(reader["UserID"].ToString());
                }
                info.Type = reader["Type"].ToString();

            }
            return info;
        }
        #endregion

    }
}
