﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_Certificate 的摘要说明
/// </summary>
namespace Certificate
{
    public class RCertificate : Certificate.ICertificate
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;

        #region ICertificate 成员
        /// <summary>
        /// 添加用户证书信息
        /// </summary>
        /// <param name="eui">用户证书对象</param>
        /// <returns></returns>
        public int Insert(Certificate.TCertificate eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               
                new SqlParameter("@UserID", eui.UserID),
                new SqlParameter("@Name", eui.Name),
                new SqlParameter("@URL", eui.URL),
                new SqlParameter("@Organization", eui.Organization), 
                new SqlParameter("@LicenceDate", eui.LicenceDate), 
                new SqlParameter("@ExpiryDate", eui.ExpiryDate), 
                new SqlParameter("@AddDate", eui.AddDate),
               

             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_Certificate_Add", commandParameters);
        }
        /// <summary>
        /// 修改用户证书信息
        /// </summary>
        /// <param name="eui">用户证书对象</param>
        /// <returns></returns>
        public int Update(Certificate.TCertificate eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@UserID", eui.UserID),
                new SqlParameter("@Name", eui.Name),
                new SqlParameter("@URL", eui.URL),
                new SqlParameter("@Organization", eui.Organization), 
                new SqlParameter("@LicenceDate", eui.LicenceDate), 
                new SqlParameter("@ExpiryDate", eui.ExpiryDate)
               
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_Certificate_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除用户证书信息
        /// </summary>
        /// <param name="ID">证书ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "C_Certificate") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据公司名称和证书名称取得公司证书基本信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            {  
                new SqlParameter("@strTableName","C_Certificate INNER JOIN U_UserInfo"), 
                new SqlParameter("@strWhere","ON C_Certificate.UserID=U_UserInfo.UserID "+strWhere),
                new SqlParameter("@strSelect","C_Certificate.*,U_UserInfo.CompanyName"),
                new SqlParameter("@strOrder", " order by AddDate  desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据证书ID得到用户证书信息
        /// </summary>
        /// <param name="ParamID">证书ID</param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID=" + ParamID),
                new SqlParameter("@strtableName", "C_Certificate"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        public TCertificate GateItem(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect", "C_Certificate.*,U_UserInfo.CompanyName"),
                new SqlParameter("@strwhere", "where C_Certificate.ID=" + ParamID),
                new SqlParameter("@strtableName", "C_Certificate left join U_UserInfo on C_Certificate.UserID=U_UserInfo.UserID"), 
                new SqlParameter("@strOrder", "order by C_Certificate.AddDate desc") 
            };
            TCertificate info = new TCertificate();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = Convert.ToInt32(reader["UserID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                info.URL = reader["URL"].ToString();
                info.Organization = reader["Organization"].ToString();
                if (reader["LicenceDate"].ToString() != "")
                {
                    info.LicenceDate = Convert.ToDateTime(reader["LicenceDate"].ToString());
                }
                if (reader["ExpiryDate"].ToString() != "")
                {
                    info.ExpiryDate = Convert.ToDateTime(reader["ExpiryDate"].ToString());
                }
                if (reader["ExpiryDate"].ToString() != "")
                {
                    info.ExpiryDate = Convert.ToDateTime(reader["ExpiryDate"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                info.CompanyName = reader["CompanyName"].ToString();
            }
            return info;
        }
        #endregion

    }
}
