﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_News 的摘要说明
/// </summary>
namespace Corporation.News
{
    public class RNews : INews
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region INews 成员
        /// <summary>
        /// 添加公司新闻
        /// </summary>
        /// <param name="eui">公司新闻对象</param>
        /// <returns></returns>
        public int Insert(TNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@UserID", eui.UserID),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Info", eui.Info)
		            

             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_News_Add", commandParameters);
        }
        /// <summary>
        /// 修改公司新闻
        /// </summary>
        /// <param name="eui">公司新闻对象<</param>
        /// <returns></returns>
        public int Update(TNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Info", eui.Info)
		         

             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_News_Update", commandParameters);
        }
        /// <summary>
        /// 修改审核信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_News_UpdateVerify", commandParameters);
        }

        /// <summary>
        /// 根据ID删除公司新闻
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "C_News") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有公司新闻
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","C_news.*,U_UserInfo.CompanyName"),
                new SqlParameter("@strWhere"," ON C_news.UserID =U_UserInfo.UserID"),
                new SqlParameter("@strTableName"," C_news INNER JOIN U_UserInfo"), 
                new SqlParameter("@strOrder", " order by AddDate  desc,ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据标题名称和公司名称得到公司新闻
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","C_news.*,U_UserInfo.CompanyName"),
                new SqlParameter("@strWhere"," ON C_news.UserID =U_UserInfo.UserID "+strWhere),
                new SqlParameter("@strTableName"," C_news INNER JOIN U_UserInfo"), 
                new SqlParameter("@strOrder", " order by AddDate desc,ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到公司新闻每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TNews GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "C_News"), 
                new SqlParameter("@strOrder", "") 
            };
            TNews info = new TNews();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = int.Parse(reader["UserID"].ToString());
                }
                info.Title = reader["Title"].ToString();
                info.Info = reader["Info"].ToString();
                if (reader["Verify"].ToString() != "")
                {
                    info.Verify = Convert.ToBoolean(reader["Verify"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}
