﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_ProType 的摘要说明
/// </summary>
namespace Corporation.Product
{
    public class RProType : IProType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region INews 成员
        /// <summary>
        /// 添加产品系列
        /// </summary>
        /// <param name="eui">产品系列对象</param>
        /// <returns></returns>
        public int Insert(TProType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@UserID", eui.UserID),
					new SqlParameter("@Name", eui.Name),
			        new SqlParameter("AddDate",eui.AddDate)
		            

             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_ProType_Add", commandParameters);
        }
        /// <summary>
        /// 修改产品系列
        /// </summary>
        /// <param name="eui">产品系列对象<</param>
        /// <returns></returns>
        public int Update(TProType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Name", eui.Name),
                    new SqlParameter("@Sequence",eui.Sequence)
				
		    };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_ProType_Update", commandParameters);
        }
        /// <summary>
        /// 更新排序字段
        /// </summary>
        /// <param name="paixu">排序字段id</param>
        /// <param name="lbid">栏目字段id</param>
        public int UpdateSequence(int paixu, int lbid)
        {
            string updataStr = "UPDATE  C_ProType SET Sequence=@Sequence where ID=@lbid";
            SqlParameter[] parms ={ 
            new SqlParameter("@Sequence",paixu),
            new SqlParameter("@lbid",lbid)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.Text, updataStr, parms);
        }


        /// <summary>
        /// 根据ID删除产品系列
        /// </summary>
        /// <param name="ID">产品系列ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "C_ProType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有产品系列
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","a.ID,a.Name,a.Sequence,b.LoginName"),
                new SqlParameter("@strWhere","on a.UserID=b.UserID"),
                new SqlParameter("@strTableName","C_ProType as a left join U_UserInfo as b"), 
                new SqlParameter("@strOrder", "order by Sequence asc,ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据产品系列属性得到产品系列        
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TProType eui)
        {
            string str = "where 1=1 ";
            if (eui.UserID != 0)
                str += " and UserID=" + eui.UserID;

            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "C_ProType"), 
                new SqlParameter("@strOrder", "order by Sequence asc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到产品系列每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TProType GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "C_ProType"), 
                new SqlParameter("@strOrder", "") 
            };
            TProType info = new TProType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = int.Parse(reader["UserID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                info.Superiors = reader["Superiors"].ToString();
                info.SuperiorsID = reader["SuperiorsID"].ToString();
                if (reader["Sequence"].ToString() != "")
                {
                    info.Sequence = Convert.ToInt32(reader["Sequence"].ToString());
                }

            }
            return info;
        }
        /// <summary>
        /// 根据登陆用户ID获取个人信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetPersonInfoById(int userid)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere","where UserID="+userid),
                new SqlParameter("@strtableName", "U_UserInfo")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据登陆用户ID获取个人信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetPersonInfo(int userid)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere","where UserID="+userid),
                new SqlParameter("@strtableName", "U_UserInfo")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        #endregion
    }
}
