﻿using System;
using System.Data;
using UserInfo;
/// <summary>
/// 创建有关会员信息的处理接口
/// </summary>
namespace UserInfo
{
    /// <summary>
    /// 会员详细信息接口
    /// </summary>
    public interface IUserInfo
    {       
        int Insert(TUserInfo us);                               //添加会员基本信息
        int UpdateLinkMan(TUserInfo us);                        //修改联系人信息
        int UpdatePassword(TUserInfo us);                       //修改会员密码
        int FindUpdatePwd(int UserID, string Password);         //找回密码并修改
        int UpdateVerify(UserInfo.TUserInfo us);                //修改审核信息
        int UpdateLocked(UserInfo.TUserInfo us);                //修改锁定信息
        int UpdateCorpInfo(TUserInfo us);                       //修改公司信息
        int UpdateLogin(UserInfo.TUserInfo eui);                 //修改登录信息
        int Delete(int ID);                                     //根据会员ID删除会员的基本信息
        DataSet GetDataTable(string LoginName,string Password); //根据会员名称和会员密码取得会员的基本信息
        DataSet GetDataTable(int UserID);                       //根据会员UserID取得会员的基本信息
        DataTable GetDataTable(string strWhere);                  //根据strWhere条件取得会员的基本信息
        TUserInfo GateItem(int id);                             //根据会员UserID取得会员的每一条信息
        /// <summary>
        /// 发送密码到邮箱
        /// </summary>
        //int RePasstoEmail(string[] str);

        /// <summary>
        /// 通过安全问题找回密码
        /// </summary>
        int RePasstoAnswer();

        /// <summary>
        /// 返回单个会员信息
        /// </summary>
      
      int GateI(string LoginName);
      int mailjiancha(string Email);
      
    }
   
}