using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;
using UserInfo;
//using System.Web.HttpContext.Current.Session;


namespace UserInfo
{
    public class RUserInfo : IUserInfo
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IUserInfo Ա
        /// <summary>
        /// עʱϢ
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Insert(UserInfo.TUserInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]{                               
				new SqlParameter("@LoginName", eui.LoginName),
				new SqlParameter("@Sex",eui.Sex),
				new SqlParameter("@Password",eui.Password),
				new SqlParameter("@Question", eui.Question),
				new SqlParameter("@Answer", eui.Answer),
				new SqlParameter("@GradeID", eui.GradeID),
				new SqlParameter("@Lockuedup", eui.Lockuedup),
				new SqlParameter("@LinkName", eui.LinkName),
				new SqlParameter("@MobilePhone", eui.MobilePhone),
				new SqlParameter("@Email", eui.Email),
				new SqlParameter("@QQ", eui.QQ),
				new SqlParameter("@MSN", eui.MSN),
				new SqlParameter("@Tel_International", eui.Tel_International),
				new SqlParameter("@Tel_DistrictNumber", eui.Tel_DistrictNumber),
				new SqlParameter("@Tel_Telephone", eui.Tel_Telephone),
				new SqlParameter("@Tel_Ext", eui.Tel_Ext),
            	new SqlParameter("@Fax_International", eui.Fax_International),
				new SqlParameter("@Fax_DistrictNumber", eui.Fax_DistrictNumber),
				new SqlParameter("@Fax_Telephone", eui.Fax_Telephone),
				new SqlParameter("@Fax_Ext", eui.Fax_Ext),
				new SqlParameter("@Department", eui.Department),
				new SqlParameter("@Position", eui.Position),
				//new SqlParameter("@RegDate", eui.RegDate),
				new SqlParameter("@CompanyName", eui.CompanyName),
				new SqlParameter("@CompanyNature", eui.CompanyNature),
				//new SqlParameter("@BusinessModel", eui.BusinessModel),
				new SqlParameter("@DealinAdd", eui.DealinAdd),
				//new SqlParameter("@Product", eui.Product),
				new SqlParameter("@Industry", eui.Industry),
				//new SqlParameter("@Summary", eui.Summary),
				//new SqlParameter("@Verify", eui.Verify),
				new SqlParameter("@Country", eui.Country),
				new SqlParameter("@Province", eui.Province),
				new SqlParameter("@City", eui.City),
				new SqlParameter("@Area", eui.Area),
				//new SqlParameter("@Street", eui.Street),
				//new SqlParameter("@Postalcode", eui.Postalcode),
				//new SqlParameter("@URL", eui.URL),
				//new SqlParameter("@Capital", eui.Capital),
				//new SqlParameter("@Established",eui.Established),
				//new SqlParameter("@RegisterAddress", eui.RegisterAddress),
				//new SqlParameter("@Corporate", eui.Corporate),
				//new SqlParameter("@StartDate", eui.StartDate),
				//new SqlParameter("@EndDate", eui.EndDate),
				//new SqlParameter("@Logo", eui.Logo)            
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserInfo_Add", commandParameters);
        }


        /// <summary>
        /// ޸ĻԱģ
        /// </summary>
        /// <param name="strTemplate">µģ</param>
        /// <returns></returns>
        public int UpdateTemplate(string strTemplatem, int ID)
        {
            SqlParameter[] commandParameters = new SqlParameter[]{
                new SqlParameter("@ID", ID),new SqlParameter("@Template", strTemplatem) 
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserOperate_UpdateTemplate", commandParameters);
        }



        /// <summary>
        /// ޸ϵϢ
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateLinkMan(UserInfo.TUserInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@UserID", eui.UserID),
                new SqlParameter("@LinkName", eui.LinkName), 
                new SqlParameter("@Sex", eui.Sex), 
                new SqlParameter("@Email", eui.Email), 
                new SqlParameter("@Tel_International", eui.Tel_International),
				new SqlParameter("@Tel_DistrictNumber", eui.Tel_DistrictNumber),
				new SqlParameter("@Tel_Telephone", eui.Tel_Telephone),
				new SqlParameter("@Tel_Ext", eui.Tel_Ext),
                new SqlParameter("@Fax_International", eui.Fax_International),
				new SqlParameter("@Fax_DistrictNumber", eui.Fax_DistrictNumber),
				new SqlParameter("@Fax_Telephone", eui.Fax_Telephone),
				new SqlParameter("@Fax_Ext", eui.Fax_Ext),
			    new SqlParameter("@MobilePhone", eui.MobilePhone),
                new SqlParameter("@Department", eui.Department),
                new SqlParameter("@Position", eui.Position), 
                new SqlParameter("@QQ", eui.QQ), 
                new SqlParameter("@MSN", eui.MSN)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserInfo_linkMan_Update", commandParameters);
        }
        /// <summary>
        /// ޸
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdatePassword(UserInfo.TUserInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@UserID", eui.UserID),
                new SqlParameter("@OldPassword", eui.OldPassword),
                new SqlParameter("@Password", eui.Password)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserInfo_UpdatePassword", commandParameters);
        }
        /// <summary>
        /// һ룬䷵ҳֱ޸
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int FindUpdatePwd(int UserID, string Password)
        {
            string updataStr = "update U_UserInfo set Password= @Password where UserID=@UserID";
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@UserID",UserID),
                new SqlParameter("@Password", Password)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.Text, updataStr, commandParameters);
        }
        /// <summary>
        /// ޸Ϣ
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(UserInfo.TUserInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@UserID", eui.UserID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserInfo_UpdateVerify", commandParameters);
        }
        /// <summary>
        /// ޸Ϣ
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateLocked(UserInfo.TUserInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@UserID", eui.UserID),
                new SqlParameter("@Lockedup", eui.Lockuedup)
               
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserInfo_UpdateLocked", commandParameters);
        }
        /// <summary>
        /// ޸Ĺ˾Ϣ
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateCorpInfo(UserInfo.TUserInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@UserID", eui.UserID),
                new SqlParameter("@CompanyName", eui.CompanyName), 
                new SqlParameter("@CompanyNature", eui.CompanyNature), 
                new SqlParameter("@BusinessModel", eui.BusinessModel), 
                new SqlParameter("@DealinAdd", eui.DealinAdd),
				new SqlParameter("@Product", eui.Product),
				new SqlParameter("@Industry", eui.Industry),
				new SqlParameter("@Summary", eui.Summary),
                new SqlParameter("@Street", eui.Street),
				new SqlParameter("@Postalcode", eui.Postalcode),
				new SqlParameter("@URL", eui.URL),
				new SqlParameter("@Capital", eui.Capital),
			    new SqlParameter("@Established", eui.Established),
                new SqlParameter("@RegisterAddress", eui.RegisterAddress),
                new SqlParameter("@Country", eui.Country), 
                new SqlParameter("@Province", eui.Province), 
                new SqlParameter("@City", eui.City),
                new SqlParameter("@Area", eui.Area),
                new SqlParameter("@Corporate", eui.Corporate),
                new SqlParameter("@Logo", eui.Logo),
                new SqlParameter("@GradeID", eui.GradeID)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserInfo_CorpInfo_Update", commandParameters);
        }


        /// <summary>
        /// ޸ĵ¼Ϣ
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateLogin(UserInfo.TUserInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@UserID", eui.UserID),
                new SqlParameter("@GradeID",eui.GradeID),
                new SqlParameter("@Password", eui.Password),
                new SqlParameter("@Question", eui.Question),
                new SqlParameter("@Answer",eui.Answer),
                new SqlParameter("@StartDate",eui.StartDate),
                new SqlParameter("@EndDate",eui.EndDate)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserInfo_UpdateLogin", commandParameters);
        }



        /// <summary>
        /// IDɾԱϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@id", ID)
            };
            return SqlHelper.DeleteByWhere("SP_U_UserInfo_Delte", param);

        }
        /// <summary>
        /// strWhereõԱϢ
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere",strWhere),
                new SqlParameter("@strtableName", "U_UserInfo"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// ݻԱIDõԱϢ
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataSet GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where UserID=" + ParamID),
                new SqlParameter("@strtableName", "U_UserInfo"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteDataset(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// ݻԱõԱϢ
        /// </summary>
        /// <param name="LoginName"></param>
        /// <param name="Password"></param>
        /// <returns></returns>
        public DataSet GetDataTable(string LoginName, string Password)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where LoginName='" + LoginName + "'and Password='" + Password +"'"), 
                new SqlParameter("@strtableName", "U_UserInfo"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteDataset(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }



        //public int RePasstoEmail(string[] Parm)
        //{
        //    //SendMail.Jmail Mail = new SendMail.Jmail();
        //    //return Mail.SendMail(Parm);
        //}

        public int RePasstoAnswer()
        {
            throw new Exception("The method or operation is not implemented.");
        }
        /// <summary>
        /// ݻԱIDõԱÿһϢ
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        public UserInfo.TUserInfo GateItem(int UserID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where UserID=" +Convert.ToInt32( UserID)), 
                new SqlParameter("@strTableName", "U_UserInfo"), 
                new SqlParameter("@strOrder", "") 
            };
            TUserInfo info = new TUserInfo();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                info = new TUserInfo();

                //ԱϢ
                info.UserID = Convert.ToInt32(reader["UserID"].ToString());
                info.LoginName = reader["LoginName"].ToString();
                info.Password = reader["password"].ToString();
                info.Question = reader["Question"].ToString();
                info.Answer = reader["Answer"].ToString();
                if (reader["GradeID"].ToString() != "")
                    info.GradeID = int.Parse(reader["GradeID"].ToString());

                //ϵϢ
                info.LinkName = reader["LinkName"].ToString();
                info.Sex = reader["Sex"].ToString();
                info.Department = reader["Department"].ToString();
                info.Position = reader["Position"].ToString();
                info.Tel_International = reader["Tel_International"].ToString();
                info.Tel_DistrictNumber = reader["Tel_DistrictNumber"].ToString();
                info.Tel_Telephone = reader["Tel_Telephone"].ToString();
                info.Tel_Ext = reader["Tel_Ext"].ToString();
                info.Fax_International = reader["Fax_International"].ToString();
                info.Fax_DistrictNumber = reader["Fax_DistrictNumber"].ToString();
                info.Fax_Telephone = reader["Fax_Telephone"].ToString();
                info.Fax_Ext = reader["Fax_Ext"].ToString();
                info.MobilePhone = reader["MobilePhone"].ToString();
                info.Email = reader["EMail"].ToString();
                info.QQ = reader["QQ"].ToString();
                info.MSN = reader["MSN"].ToString();

                //ع˾Ϣ
                info.CompanyName = reader["CompanyName"].ToString();
                info.CompanyNature = reader["CompanyNature"].ToString();
                info.BusinessModel = reader["BusinessModel"].ToString();
                if (reader["Capital"].ToString() != "")
                    info.Capital = int.Parse(reader["Capital"].ToString());
                if (reader["Established"].ToString() != "")
                    info.Established = Convert.ToDateTime(reader["Established"].ToString());
                info.RegisterAddress = reader["RegisterAddress"].ToString();
                info.Country = reader["Country"].ToString();
                info.Province = reader["Province"].ToString();
                info.City = reader["City"].ToString();
                info.Area = reader["Area"].ToString();
                info.DealinAdd = reader["DealinAdd"].ToString();
                info.Postalcode = reader["Postalcode"].ToString();
                info.Product = reader["Product"].ToString();
                info.Industry = reader["Industry"].ToString();
                info.Summary = reader["Summary"].ToString();
                info.Street = reader["Street"].ToString();
                info.URL = reader["URL"].ToString();
                info.Corporate = reader["Corporate"].ToString();
                info.Logo = reader["Logo"].ToString();
                info.StartDate = DateTime.Parse(reader["StartDate"].ToString());
                info.EndDate = DateTime.Parse(reader["EndDate"].ToString());
            }
            return info;
        }


        /// <summary>
        /// ûַǷ
        /// </summary>
        /// <param name="LoginName">Ҫû</param>
        /// <returns></returns>
        public int GateI(string LoginName)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                 new SqlParameter("@strSelect", "LoginName"),
                 new SqlParameter("@strWhere", "where LoginName='" +LoginName+"'"),
                 new SqlParameter("@strTableName", "U_UserInfo"), 
                 new SqlParameter("@strOrder", "") ,
            };
            int info = 2;
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (reader.Read())
                    return 1;
                else
                    return 0;
            }
            return info;

        }
        //

        public int mailjiancha(string Email)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where Email='" +Email+"'"), 
                new SqlParameter("@strTableName", "U_UserInfo"), 
                new SqlParameter("@strOrder", "") ,
            };
            int info = 2;
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (reader.Read())
                {
                    info = 1;
                    return info;
                }
                else
                {
                    info = 0;
                    return info;
                }

            }
            return info;
        }


        //⹫˾
        public int CheckCompanyName(string CompanyName)
        {
            SqlConnection con = new SqlConnection(ConnectionString);
            string Sql = "SELECT [UserID] FROM [U_UserInfo] WHERE [CompanyName]='" + CompanyName + "'";
            SqlCommand cmd = new SqlCommand(Sql, con);
            con.Open();
            SqlDataReader sr = cmd.ExecuteReader();
            if (sr.Read())
            {
                return (int.Parse(sr["UserID"].ToString()));
            }
            con.Close();
            return 0;
        }

        //ӻԱ
        public int CreateUser(TUserInfo t)
        {
            SqlConnection con = new SqlConnection(ConnectionString);
            SqlCommand cmd = new SqlCommand("SP_U_FastAddUserInfo", con);
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.Parameters.AddWithValue("@LoginName", t.LoginName);
            cmd.Parameters.AddWithValue("@Password", t.Password);
            cmd.Parameters.AddWithValue("@Email", t.Email);
            cmd.Parameters.AddWithValue("@CompanyName", t.CompanyName);
            SqlParameter UserID = new SqlParameter("@UserID", SqlDbType.Int);
            UserID.Direction = ParameterDirection.Output;
            cmd.Parameters.Add(UserID);
            con.Open();
            if (cmd.ExecuteNonQuery() > 0)
            {
                return int.Parse(UserID.SqlValue.ToString());
            }
            con.Close();
            return 0;
        }
        ///**************************************************
        /// <summary>
        /// depiction÷ڸݱѯ
        /// </summary>
        /// <param name="<>"><˵></param>
        /// <returns>
        ///<Էֵ˵˵ȷ˵صֵʲô>
        /// </returns>
        ///Create Date2009-9-4
        ///**************************************************
        public DataTable GetDataType(string table)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strtableName", table)
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        #endregion
    }


}