﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_Link 的摘要说明
/// </summary>
namespace Corporation.Link
{
    public class RLink : ILink
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region ILinks 成员
        /// <summary>
        /// 添加公司友情链接
        /// </summary>
        /// <param name="eui">公司友情链接对象</param>
        /// <returns></returns>
        public int Insert(TLink eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@UserID", eui.UserID),
                    new SqlParameter("@Name", eui.Name),
					new SqlParameter("@Url", eui.Url),
					new SqlParameter("@Logo", eui.Logo)

             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_UserLink_Add", commandParameters);
        }
        /// <summary>
        /// 修改公司友情链接
        /// </summary>
        /// <param name="eui">公司友情链接对象<</param>
        /// <returns></returns>
        public int Update(TLink eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("ID",eui.ID),
                    new SqlParameter("@Name", eui.Name),
					new SqlParameter("@Url", eui.Url),
					new SqlParameter("@Logo", eui.Logo)

             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_U_UserLink_Update", commandParameters);
        }
        /// <summary>
        /// 修改审核信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TLink eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_U_UserLink_UpdateVerify", commandParameters);
        }

        /// <summary>
        /// 根据ID删除公司友情链接
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "U_UserLink") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据标题名称和公司名称取得友情链接
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect"," U_UserInfo.CompanyName,U_UserLink.*"),
                new SqlParameter("@strWhere"," ON U_UserInfo.UserID = U_UserLink.UserID "+strWhere),
                new SqlParameter("@strTableName"," U_UserInfo INNER JOIN U_UserLink"), 
                new SqlParameter("@strOrder", " order by AddDate  desc,ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到公司友情链接每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TLink GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "U_UserLink"), 
                new SqlParameter("@strOrder", "") 
            };
            TLink info = new TLink();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                info.Url = reader["Url"].ToString();
                info.Logo = reader["Logo"].ToString();
                if (reader["Verify"].ToString() != "")
                {
                    info.Verify = Convert.ToBoolean(reader["Verify"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}
