﻿using System;
using System.Data;

/// <summary>
/// T_Link 的摘要说明
/// </summary>
namespace Corporation.Link
{

    /// <summary>
    /// 商铺友情链接接口
    /// </summary>
    public interface ILink
    {
        int Insert(TLink us);                   //添加公司友情链接
        int Update(TLink us);                   //修改公司友情链接
        int UpdateVerify(TLink eui);            //修改审核信息
        int Delete(int ID);                     //根据ID删除公司友情链接信息
        DataTable GetDataTable(string strWhere);//根据标题名称和公司名称取得友情链接
        TLink GateItem(int ID);                 //根据ID取得友情链接
    }

    /// <summary>
    /// 商铺友情链接属性
    /// </summary>
    public class TLink
    {

        #region Model
        private int _id;
        private int _userid;
        private string _name;
        private string _url;
        private string _logo;
        private bool _verify;
        private DateTime _adddate;
        private string _company;
        /// <summary>
        /// 
        /// </summary>
        public int ID
        {
            set { _id = value; }
            get { return _id; }
        }
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserID
        {
            set { _userid = value; }
            get { return _userid; }
        }
        /// <summary>
        /// 网站名称
        /// </summary>
        public string Name
        {
            set { _name = value; }
            get { return _name; }
        }
        /// <summary>
        /// 网站地址
        /// </summary>
        public string Url
        {
            set { _url = value; }
            get { return _url; }
        }
        /// <summary>
        /// 网站Logo
        /// </summary>
        public string Logo
        {
            set { _logo = value; }
            get { return _logo; }
        }
        /// <summary>
        /// 审核
        /// </summary>
        public bool Verify
        {
            set { _verify = value; }
            get { return _verify; }
        }
        /// <summary>
        /// 添加日期
        /// </summary>
        public DateTime AddDate
        {
            set { _adddate = value; }
            get { return _adddate; }
        }
        /// <summary>
        /// 公司名称
        /// </summary>
        public string Company
        {
            set { _company = value; }
            get { return _company; }
        }
        #endregion Model
    }
}
