﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// RConsultativeRestore 的摘要说明
/// </summary>
namespace Consultative
{
    public class RConsultativeRestore:IConsultativeRestore
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;

        public RConsultativeRestore()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }

        #region ICorporationRestore 成员
        /// <summary>
        /// 添加资讯评论
        /// </summary>
        /// <param name="conr"></param>
        /// <returns></returns>
        public int Insert(TConsultativeRestore conr)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
					new SqlParameter("@ConsultativeID", conr.ConsultativeID),
					new SqlParameter("@UserName", conr.UserName),
					new SqlParameter("@Detail", conr.Detail)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_ConsultativeRestore_Add", commandParameters);
        }
        /// <summary>
        ///
        /// </summary>
        /// <param name="conr"></param>
        /// <returns></returns>
        public int Update(TConsultativeRestore conr)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                   new SqlParameter("@ID",conr.ID ),
					new SqlParameter("@ConsultativeID", conr.ConsultativeID),
					new SqlParameter("@UserName", conr.UserName),
					new SqlParameter("@AddDate", conr.AddDate),
					new SqlParameter("@Detail", conr.Detail),
					new SqlParameter("@Shield", conr.Shield)

            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_ConsultativeRestore_Update", commandParameters);
        }
        /// <summary>
        /// 修改屏蔽信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateShield(TConsultativeRestore eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Shield", eui.Shield)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_ConsultativeRestore_UpdateShield", commandParameters);
        }
        /// <summary>
        /// 删除资讯评论
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_ConsultativeRestore") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到资讯评论所有信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_ConsultativeRestore"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到资讯评论信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID=" + ParamID),
                new SqlParameter("@strtableName", "W_ConsultativeRestore"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到资讯评论每一条详细信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TConsultativeRestore GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +Convert.ToInt32( id)), 
                new SqlParameter("@strTableName", "W_ConsultativeRestore"), 
                new SqlParameter("@strOrder", "") 
            };
            TConsultativeRestore info = new TConsultativeRestore();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["ConsultativeID"].ToString() != "")
                {
                    info.ConsultativeID = Convert.ToInt32(reader["ConsultativeID"].ToString());
                }
                info.UserName = reader["UserName"].ToString();
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                info.Detail = reader["Detail"].ToString();
                if (reader["Shield"].ToString() != "")
                {
                    info.Shield = Convert.ToBoolean(reader["Shield"].ToString());
                }
                info.IP = reader["IP"].ToString();
            }
            return info;
        }

        #endregion ICorporation 成员
    }
}
