﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// RConsultativeType 的摘要说明
/// </summary>
namespace Consultative
{
    public class RConsultativeType : IConsultativeType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;

        #region IConsultativeType 成员
        /// <summary>
        /// 添加资讯类别
        /// </summary>
        /// <param name="cont">资讯类别对象</param>
        /// <returns></returns>

        public int Insert(TConsultativeType cont)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               new SqlParameter("@Name", cont.Name),
               new SqlParameter("@ParentID",cont.ParentID)
              
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_ConsultativeType_Add", commandParameters);
        }
        /// <summary>
        /// 修改资讯类别
        /// </summary>
        /// <param name="cont">资讯类别对象</param>
        /// <returns></returns>
        public int Update(TConsultativeType cont)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID",cont.ID ),
				new SqlParameter("@Name", cont.Name)

            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_ConsultativeType_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除资讯类别
        /// </summary>
        /// <param name="ID"></param>
        ///  <param name="Tid">转向的哪个类别ID</param>
        ///  <param name="temp">判断是否删除,1、转移，0、删除</param>
        ///  <param name="ParentId">判断是否有子类别,0、父级，其它值为子类</param>
        /// <returns></returns>
        public int Delete(int ID,int Tid,int Temp,int ParentId)
        {
            //SqlParameter[] param = new SqlParameter[] 
            //{
            //    new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
            //    new SqlParameter("@strTableName", "W_ConsultativeType") 
            //};
            //return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
            SqlParameter[] param = new SqlParameter[]
            {
                new SqlParameter("@SelfId",ID),
                new SqlParameter("@Toid",Tid),
                new SqlParameter("@Type",Temp),
                new SqlParameter("@ParentId",ParentId)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "[SP_W_ConsultativeType_Delete]", param);
        }
        /// <summary>
        /// 得到所有一级资讯类别 
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere","where ParentID=0"),
                new SqlParameter("@strTableName", "W_ConsultativeType"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到资讯类别
        /// </summary>
        /// <param name="ParamID">资讯ID</param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ParentID=" + ParamID),
                new SqlParameter("@strtableName", "W_ConsultativeType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据资讯ID得到资讯类别
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TConsultativeType GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +Convert.ToInt32( id)), 
                new SqlParameter("@strTableName", "W_ConsultativeType"), 
                new SqlParameter("@strOrder", "") 
            };
            TConsultativeType info = new TConsultativeType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["ParentID"].ToString() != "")
                {
                    info.ParentID = Convert.ToInt32(reader["ParentID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                info.FULLID = reader["FULLID"].ToString();
            }
            return info;
        }

        #endregion ICorporationType 成员
    }
}
