﻿<%@ WebHandler Language="C#" Class="Name" %>
using System;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Text;
using System.Xml;
using UserInfo;
public class Name : IHttpHandler
{
    public void ProcessRequest(HttpContext context)
    {
        string Flag = context.Request["ID"].ToString();
        switch (Flag)
        {
            case "0":       //会员名检测
                CheckLoginName(context);
                break;
            case "1":       //邮箱检测
                CheckEmail(context);
                break;
            case "6":       //顶一下
                ClickCount(context);
                break;
            case "7":       //产品信息提交
                ProductUserInfo(context);
                break;
            case "8":       //提交评论
                SaveComment(context);
                break;
            case "9":       //保存会员的收藏
                SaveFavorites(context);
                break;
            case "10":
                GetKeywords(context);
                break;
            case "11":      //保存记事信息
                conserve(context);
                break;
            case "12":      //检查数据库链接
                CheckConnection(context);
                break;
            default:
                break;
        }
    }
    
    /// <summary>
    /// 检查数据库连接
    /// </summary>
    /// <param name="context"></param>
    private static void CheckConnection(HttpContext context)
    {
        string str1 = context.Request["server"];
        string str2 = context.Request["user"];
        string str3 = context.Request["password"];
        string str4 = context.Request["dataName"];
        if (Base.Common.GetConnectionState(str1, str2, str3, str4))
            context.Response.Write("1");
        else
            context.Response.Write("0");
    }

    /// <summary>
    /// 顶一下
    /// </summary>
    /// <param name="context"></param>
    private static void ClickCount(HttpContext context)
    {

        XmlDocument xml = new XmlDocument();
        // 解析 Body 中的 xml
        xml.Load(context.Request.InputStream);
        XmlElement s0 = xml.SelectSingleNode("/book/mode") as XmlElement;
        XmlElement s1 = xml.SelectSingleNode("/book/id") as XmlElement;
        string cou = s0.InnerText.ToString();
        string id = s1.InnerText.ToString();
        bool b;
        if (cou=="up")
        {
            b = Solely.Other.UpOnlyDate("W_Consultative", "CountUp=CountUp+1", "id =" + int.Parse(id));
        }
        if (cou=="down")
        {
            b = Solely.Other.UpOnlyDate("W_Consultative", "CountDown=CountDown+1", "id =" + int.Parse(id));
        }
        context.Response.Write("1"); 
    } 
    
    
    /// <summary>
    /// 用户名检测
    /// </summary>
    /// <param name="context"></param>
    private static void CheckLoginName(HttpContext context)
    {
        string userName = "";
        if(context.Request.QueryString["name"]!=null)
             userName = context.Request.QueryString["name"].ToString();
        if (userName == "")
        {
            context.Response.Write("2");
            return;
        }
        IUserInfo user = new RUserInfo();
        int UserId = user.GateI(userName);
        if (UserId == 1)
            context.Response.Write("1");
        else
        {
            Solely.UserRegistr set = Solely.UserRegistr.GateItem();
            if (set.BannedUser.Contains(userName.Trim()))
                context.Response.Write("1");
            else
                context.Response.Write("0");
        }
    }
    
    /// <summary>
    /// 判断邮箱
    /// </summary>
    /// <param name="contemail"></param>
    private static void CheckEmail(HttpContext context)
    {
        Solely.UserRegistr set = Solely.UserRegistr.GateItem();
        //if (true)
        //{
        //    context.Response.Write("5");
        //    return;
        //}
        //else
        //{
        string Email_user = context.Request["name"].ToString();
        string Kg = "/\\s/g,''";
        IUserInfo email = new RUserInfo();
        int Emailnameid = email.mailjiancha(Email_user);
        if (Email_user.Trim().Replace(Kg, "") == "")
        {
            context.Response.Write("2");
        }
        else if (Emailnameid == 1)
        {
            context.Response.Write("1");
        }
        else
        {
            IsInt(Email_user, context);
        }
        //}
    }



    /// <summary>
    /// 判断邮箱
    /// </summary>
    /// <param name="inString"></param>
    /// <returns></returns>
    public static void IsInt(string inString, HttpContext context)
    {
        string patrn = "^[_a-zA-Z0-9\\-\\.]+@([\\-_a-zA-Z0-9]+\\.)+[a-zA-Z0-9]{2,3}$";
        if (System.Text.RegularExpressions.Regex.IsMatch(inString, patrn))
        {
            context.Response.Write("0");
        }
        else
        {
            context.Response.Write("3");
        }

    }


    /// <summary>
    /// 取得热门关键字
    /// </summary>
    /// <param name="context"></param>
    private static void GetKeywords(HttpContext context)
    {
        XmlDocument xml = new XmlDocument();
        // 解析 Body 中的 xml
        xml.Load(context.Request.InputStream);
        XmlElement s0 = xml.SelectSingleNode("/book") as XmlElement;
        string mode = s0.InnerText.ToString();
        string Restr = "";
        string strUrl = Base.BasePage.Config.WebURL; 
        if (mode.ToLower() == "news")
        {
            strUrl += "Search/Search.aspx?type=" + mode + "&keyword=";
        }
        else if (mode.ToLower() == "company")
        {
            strUrl += "Search/Search.aspx?type=" + mode + "&keyword=";
        }
        else if (mode.ToLower() == "purchase")
        {
            strUrl += "Search/Search.aspx?type=" + mode + "&keyword=";
        }
        else if (mode.ToLower() == "supply")
        {
            strUrl += "Search/Search.aspx?type=" + mode + "&keyword=";
        }
        else if (mode.ToLower() == "sincereagent")
        {
            strUrl += "Search/Search.aspx?type=" + mode + "&keyword=";
        }
        else if (mode.ToLower() == "willagent")
        {
            strUrl += "Search/Search.aspx?type=" + mode + "&keyword=";
        }
        else if (mode.ToLower() == "expo")
        {
            strUrl += "Search/Search.aspx?type=" + mode + "&keyword=";
        }
        else if (mode.ToLower() == "exponews")
        {
            strUrl += "Search/Search.aspx?type=" + mode + "&keyword=";
        }       
        SqlParameter[] param = new SqlParameter[] 
        {
            new SqlParameter("@strSelect", "Name"), 
            new SqlParameter("@strwhere", " where Type='"+mode+"'"),
            new SqlParameter("@strtableName", "W_Keyword"), 
            new SqlParameter("@strOrder", "order by EditDate desc") 
        };
        DataTable strtable = SqlOperate.SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        if (strtable.Rows.Count > 0)
        {
            for (int i = 0; i < strtable.Rows.Count; i++)
            {
                Restr += "<a href=\"" + strUrl + strtable.Rows[i]["Name"].ToString() + "\" class=\"sh\">" + strtable.Rows[i]["Name"].ToString() + "</a>" + "\t";
            }
        }

        context.Response.Write(Restr);
    }

    /// <summary>
    /// 保存会员的收藏信息
    /// </summary>
    /// <param name="context">
    ///  type:  信息类型
    ///  id:    信息ID
    /// </param>
    private static void SaveFavorites(HttpContext context)
    {
        int intID = 0; //会员ID
        if (Base.BasePage.GetCookie("UserID") == null)   //没有登陆
        {
            context.Response.Write("0");
        }
        else
        {
            intID = int.Parse(Base.BasePage.GetCookie("UserID"));   //取得会员ID
        }
    }

    /// <summary>
    /// 保存资讯的评论
    /// </summary>
    /// <param name="context"></param>
    private static void SaveComment(HttpContext context)
    {

        XmlDocument xml = new XmlDocument();
        xml.Load(context.Request.InputStream);
        XmlElement s0 = xml.SelectSingleNode("/book/typeid") as XmlElement;
        XmlElement s1 = xml.SelectSingleNode("/book/name") as XmlElement;
        XmlElement s2 = xml.SelectSingleNode("/book/info") as XmlElement;
        Consultative.TConsultativeRestore TNews = new Consultative.TConsultativeRestore();
        Consultative.RConsultativeRestore RNews = new Consultative.RConsultativeRestore();
        TNews.ConsultativeID = Convert.ToInt32(s0.InnerText.ToString());
        TNews.UserName = s1.InnerText;
        TNews.Detail = s2.InnerText;
        string n1 = Convert.ToString(s1.InnerText);
        string n2 = Convert.ToString(s1.InnerText);
        string result = "defeat";
        if (RNews.Insert(TNews) == 1)
            result = "ok"; 
        context.Response.Write(result);
    }



    /// <summary>
    /// 保存获取产品信息的游客详细信息
    /// </summary>
    /// <param name="context"></param>
    private static void ProductUserInfo(HttpContext context)
    {
        string ProductID = context.Request["ProductID"].ToString();
        if (!Base.Common.CheckNum(ProductID))
        {
            context.Response.Write("noProduct");
        }
        string UserName = Base.GetRequest.GetRequestParameters(context.Request, "UTF-8")["content"]; //context.Request["UserName"].ToString();
        string Tel = context.Request["Tel"].ToString();  //Base.GetRequest.GetRequestParameters(context.Request, "UTF-8")["content"]; 
        string Fax = context.Request["Fax"].ToString(); //Base.GetRequest.GetRequestParameters(context.Request, "UTF-8")["content"]; 
        string CompanyName = context.Request["CompanyName"].ToString();
        string Email = context.Request["Email"].ToString();
        string Content = context.Request["content"].ToString();
        if (UserName == "" || Tel == "" || Content == "")
        {           
            context.Response.Write("用户名、电话、留言内容不能为空!");
            return;
        }
        if (Tel != null)
        {
            bool strTel = Base.Common.isCellphone(Tel.Trim());
            if (!strTel)
            {
                context.Response.Write("电话号码格式不正确,例如：13854322525");
                return;
            }
        }
        SqlParameter[] param = new SqlParameter[] 
        {
            new SqlParameter("@productId",Convert.ToInt32( ProductID)),
            new SqlParameter("@userName",UserName),
            new SqlParameter("@phone",Tel),
            new SqlParameter("@fax",Fax),
            new SqlParameter("@companyname",CompanyName),
            new SqlParameter("@email",Email),
            new SqlParameter("@content",Content)
        };
        try
        {

            int Result = SqlOperate.SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_VisitorRequest_Add", param);
            if (Result == 1)
            {
                context.Response.Write("留言成功!");
            }
            else
            {
                context.Response.Write(Result);
            }
        }
        catch (Exception ex)
        {
            context.Response.Write(ex.Message);
        }
        finally
        {

        }
    }
    
    /// <summary>
    /// 后台备忘录信息保存
    /// </summary>
    /// <param name="context"></param>
    private void conserve(HttpContext context)
    {
        //string strContent = context.Request["content"].ToString();
        string strContent = Base.GetRequest.GetRequestParameters(context.Request, "UTF-8")["content"];
        Base.XMLProcess xmldoc = new Base.XMLProcess("xml/notepad.xml");
        xmldoc.Update("/notepad/content", strContent);
        context.Response.Write(strContent);   
    }
    
    public bool IsReusable
    {
        get { return false; }
    }

}