﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Function;

namespace WebSenPageNo
{
    public partial class Control_PageNo : System.Web.UI.UserControl
    {
        private string _where;
        private string _strurl;  //链接字符串
        private int _pagecount;  //每页的记录数
        private int _pageindex;  //当前页
        private int _intcount;   //总记录数
        private int _pagesize=12;  //每页显示记录数量
        public int _intUpPage;   //上一页
        public int _intNextPage;  //下一页
        public int _intLastPage;  //末页
        private string _fldName;    //排序字段
        private string _strGetFields;    //返回列
        private string _table;   //查询的表   
        public string _key;
        public string _tb_Id;   //表Id

        //public string strFromTo;

        protected void Page_Load(object sender, EventArgs e)
        {
            
        }       
        /// <summary>
        /// where条件
        /// </summary>
        public string Where
        {
            get { return _where; }
            set { _where = value; }
        }
        /// <summary>
        /// 查询的表
        /// </summary>
        public string Table
        {
            get { return _table; }
            set { _table = value; }
        }
        /// <summary>
        /// 当前页
        /// </summary>
        public int Pageindex
        {
            get { return _pageindex; }
            set { _pageindex = value; }
        }
        /// <summary>
        /// 每页显示记录数量
        /// </summary>
        public int PageSize
        {
            get { return _pagesize; }
            set { _pagesize = value; }
        }
        /// <summary>
        /// 排序字段
        /// </summary>
        public string FldName
        {
            get { return _fldName; }
            set { _fldName = value; }
        }
        /// <summary>
        /// 返回列
        /// </summary>
        public string StrGetFields
        {
            get { return _strGetFields; }
            set { _strGetFields = value; }
        }
        /// <summary>
        /// 当前页面
        /// </summary>
        public string Strurl
        {
            get { return _strurl; }
            set { _strurl = value; }
        }
        /// <summary>
        /// 关键字
        /// </summary>
        public string Key
        {
            get { return _key; }
            set { _key = value; }
        }
        public string Tb_Id
        {
            get { return _tb_Id; }
            set { _tb_Id = value; }
        }
        /// <summary>
        /// 分页函数 得到总记录数
        /// </summary>
        public int CountTable(string strWhere, string tableName)
        {
            DataTable table = PageList.GetDataTable(strWhere, tableName);
            return Convert.ToInt32(table.Rows[0]["Total"]);
        }
        /// <summary>
        /// 
        /// </summary>
        public void BindDate()
        {
            int flag = CountTable(_where, _table);
            if (flag == 0)
                return;
            _intcount = flag;
            if (_key != null)
                _key = "&" + _key;
            else
                _key = "";

            if (_intcount != 0)
            {
                if (_intcount % _pagesize == 0)
                    _pagecount = _intcount / _pagesize;
                else
                    _pagecount = _intcount / _pagesize + 1;

                if (_pageindex >= 1 && _pageindex <= _pagecount)
                {
                    txt_PageNum.Text = _pageindex.ToString();
                    txt_begin.Text = _pageindex.ToString();
                }
                else
                {
                    txt_begin.Text = "1";
                    txt_PageNum.Text = "1";
                    _pageindex = 1;
                }

                if ((_pageindex - 1) < 1)
                    _intUpPage = 1;
                else
                    _intUpPage = _pageindex - 1;

                if ((_pageindex + 1) > _pagecount)
                    _intNextPage = _pagecount;
                else
                {
                    _intNextPage = _pageindex + 1;
                }

                _intLastPage = _pagecount;
                txt_pageCount.Text = _intcount.ToString();
                txt_pageAll.Text = _pagecount.ToString();
                if (_pageindex == 1)
                {
                    this.hyFirst.Enabled = false;
                    this.hyLast.Enabled = false;
                }
                else
                {
                    this.hyFirst.Enabled = true;
                    this.hyFirst.NavigateUrl = _strurl + "?page=1"+_key;
                    this.hyLast.Enabled = true;
                    this.hyLast.NavigateUrl = _strurl + "?page=" + _intUpPage + ""+_key;
                }
                if (_pageindex == (_intcount % _pagesize == 0 ? _intcount / _pagesize : (_intcount / _pagesize) + 1))
                {
                    this.hyNext.Enabled = false;
                    this.hyFoot.Enabled = false;
                }
                else
                {                    
                    this.hyNext.Enabled = true;
                    this.hyNext.NavigateUrl = _strurl + "?page=" + _intNextPage +""+_key;
                    this.hyFoot.Enabled = true;
                    this.hyFoot.NavigateUrl = _strurl + "?page=" + _intLastPage + ""+_key;
                }
            }
            else
            {
                return;
            }
        }
        /// <summary>
        /// 返回 查询的表数据
        /// </summary>
        public DataTable BindView()
        {
            BindDate();
            DataTable dtView=new DataTable();
            if(_tb_Id!=null)
                 dtView = Pagination.GetDataTable(_where, _table, 0, _fldName, _strGetFields, _pagesize, _pageindex, 0,_tb_Id);
            else
                 dtView = PageList.GetDataTable(_where, _table, 0, _fldName, _strGetFields, _pagesize, _pageindex, 0);
            return dtView;
        }
        /// <summary>
        /// 返回 查询的表数据 降序
        /// </summary>
        public DataTable BindViewDesc()
        {
            BindDate();
            DataTable dtView = new DataTable();
            if (_tb_Id != null)
                dtView = Pagination.GetDataTable(_where, _table, 1, _fldName, _strGetFields, _pagesize, _pageindex, 0, _tb_Id);
            else
                dtView = PageList.GetDataTable(_where, _table, 1, _fldName, _strGetFields, _pagesize, _pageindex, 0);
            return dtView;
        }
      
        protected void btn_go_Click(object sender, EventArgs e)
        {
            int page =1;
            if (_key != null || _key != "")
                _key = "&" + _key;
            else
                _key = "";
            if (GetRequest.isNum(txt_PageNum.Text.Trim()))
                page = Convert.ToInt32(txt_PageNum.Text.Trim());
            int sumCount;
            if (txt_pageAll.Text.Trim() == "" && txt_pageAll.Text.Trim() == null)
                sumCount = 1;
            else
                 sumCount = Convert.ToInt32(txt_pageAll.Text.Trim());
            if (page <= sumCount && page > 0)
            {
                txt_PageNum.Text = Convert.ToString(page);
            }
            else
            {
                if (page > sumCount)
                {
                    txt_PageNum.Text = Convert.ToString(sumCount);
                }
                else
                {
                    txt_PageNum.Text = "1";
                }
            }
            string strURl = Request.RawUrl;
            strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
            Response.Redirect(strURl + "?page=" + txt_PageNum.Text.Trim()+_key);
            Response.End();
        }


    }
}