﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class DestioneAd : nspBase.MemberBasePge 
{

    private int pageSize = 12;//这里设置分页尺寸
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../ErrorPage.aspx?Err=0");
            return;
        }
        else
        {
            if (!this.IsPostBack)
            {
                DataBindAdpale();
            }
        }
    }
    #region 数据绑定
    private void DataBindAdpale()
    {
        string strWhere = "1=1";
        string clum = "T_ID,Ad_Name,Ad_Type,Ad_Page,Ad_Width,Ad_Height,DayMoney,Ad_ImageAdrees,Ad_Adrees ";
        DataTable dt = Base.PageList.GetDataTable(strWhere, "W_Ad_Table", 0, "T_ID",clum, pageSize, Pageindex, 0);
        DataTable table = Base.PageList.GetDataTable(strWhere, "W_Ad_Table");
        PageCount = Convert.ToInt32(table.Rows[0]["Total"]);
        this.txt_pageCount.Text = PageCount.ToString();
        if (Pageindex == 1)
        {
            this.btn_pageFirst.Enabled = false;
            this.btn_pageLast.Enabled = false;
        }
        else
        {
            this.btn_pageFirst.Enabled = true;
            this.btn_pageLast.Enabled = true;
        }
        if (Pageindex == (PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1))
        {
            this.btn_pageNext.Enabled = false;
            this.btn_pageFoot.Enabled = false;
        }
        else
        {
            this.btn_pageNext.Enabled = true;
            this.btn_pageFoot.Enabled = true;
        }
        this.txt_begin.Text = Pageindex.ToString();
        this.txt_pageAll.Text = Convert.ToString((PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1));
        this.txt_PageNum.Text = Pageindex.ToString();
        this.GridView1.DataSource =dt.DefaultView;
        this.GridView1.DataBind();
    }
    #endregion 
    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e) 
    {
         GridViewRow row =GridView1.SelectedRow;
         System.Web.UI.WebControls.Label la = row.FindControl("lb_AdId") as System.Web.UI.WebControls.Label;
         Session["t_id"] = la.Text;
         Response.Redirect("~/member/Advertisement/M_AddAdInfo.aspx");
    }
    #region 分页事件
    protected void btn_pageFirst_Click(object sender, EventArgs e)
    {
        //首页事件
        this.Pageindex = 1;
        DataBindAdpale();
    }
    protected void btn_pageLast_Click(object sender, EventArgs e)
    {
        //上一页
        this.Pageindex--;
        DataBindAdpale();
    }
    protected void btn_pageNext_Click(object sender, EventArgs e)
    {
        //下一页
        this.Pageindex++;
        DataBindAdpale();
    }
    protected void btn_pageFoot_Click(object sender, EventArgs e)
    {
        //末页
        this.Pageindex = PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1;
        DataBindAdpale();
    }
    protected void btn_go_Click(object sender, EventArgs e)
    {
        //跳到指定的页
        string txtNumber = this.txt_PageNum.Text.ToString().Trim();
        int index = 1;
        if (Base.Common.CheckNum(txtNumber))
        {
            index = Convert.ToInt32(txtNumber);
            if (index >= 1 && index <= (PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1))
            {
                Pageindex = index;
                DataBindAdpale();
            }
            else
            {
                Pageindex = 1;
                this.txt_PageNum.Text = "输入错误";
            }
        }
        else
        {
            Pageindex = 1;
            this.txt_PageNum.Text = "输入错误";
        }
    }
    #endregion
}
