﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using System.Web.SessionState;
public partial class M_SelectAd : nspBase.MemberBasePge
{
    private int pageSize = 12;//这里设置分页尺寸
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
            return;
        }
        else
        {
            if (!this.IsPostBack)
            {
                BindData();
            }
        }
    }
    #region 绑定数据
    private void BindData()
    {
        string tbName = "W_Ad_MemberInfo INNER JOIN W_Ad_Table ON W_Ad_MemberInfo.T_ID= W_Ad_Table.T_ID";
        string clmName = "W_Ad_MemberInfo.Ad_Day,W_Ad_MemberInfo.M_ID,W_Ad_MemberInfo.Ad_ImageAdrees, W_Ad_MemberInfo.Ad_Adrees,W_Ad_MemberInfo.Ad_Auditing,W_Ad_Table.Ad_Type, W_Ad_Table.Ad_Name, W_Ad_Table.Ad_Height, W_Ad_Table.DayMoney, W_Ad_Table.Ad_Width";
        string strWhere = "";
        int userid = Convert.ToInt32(BasePage.GetCookie("UserID").ToString());
        if (BasePage.GetCookie("UserID").ToString() != null && BasePage.GetCookie("UserID").ToString() != "")
        {
            strWhere = "W_Ad_MemberInfo.[User_ID]=" + userid.ToString();
        }
        else
        {
            Response.Write("<script>alert('登陆未成功,请重新登陆');location.href=" + Base.BasePage.Config.WebURL + "/Login/Login.aspx;</script>");
        }
        DataTable dt = Base.PageList.GetDataTable(strWhere, tbName, 1, "W_Ad_MemberInfo.M_ID", clmName, pageSize, Pageindex, 0);
        DataTable table = Base.PageList.GetDataTable(strWhere, tbName);
        PageCount = Convert.ToInt32(table.Rows[0]["Total"]);
        this.txt_pageCount.Text = PageCount.ToString();
        if (Pageindex == 1)
        {
            this.btn_pageFirst.Enabled = false;
            this.btn_pageLast.Enabled = false;
        }
        else
        {
            this.btn_pageFirst.Enabled = true;
            this.btn_pageLast.Enabled = true;
        }
        if (Pageindex == (PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1))
        {
            this.btn_pageNext.Enabled = false;
            this.btn_pageFoot.Enabled = false;
        }
        else
        {
            this.btn_pageNext.Enabled = true;
            this.btn_pageFoot.Enabled = true;
        }
        this.txt_begin.Text = Pageindex.ToString();
        this.txt_pageAll.Text = Convert.ToString((PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1));
        this.txt_PageNum.Text = Pageindex.ToString();
        //绑定数据源
        this.Repeater1.DataSource = dt.DefaultView;
        this.Repeater1.DataBind();
    }
    #endregion
    protected void Repeater1_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.CommandName == "edit")
        {
            System.Web.UI.WebControls.Label l4 = e.Item.FindControl("lb_No") as System.Web.UI.WebControls.Label;
            if (l4.Text == "未通过")
            {
                System.Web.UI.WebControls.Label l = e.Item.FindControl("Lb_mid") as System.Web.UI.WebControls.Label;
                string url = "~/member/Advertisement/M_updateAdInfo.aspx?mid=" + l.Text.ToString();
                Response.Redirect(url);
            }
            else
            {
                Response.Write("<script>alert('审核通过，不能进行编辑了');</script>");
            }
        }
    }

    #region 分页事件
    protected void btn_pageFirst_Click(object sender, EventArgs e)
    {
        //首页事件
        this.Pageindex = 1;
        BindData();
    }
    protected void btn_pageLast_Click(object sender, EventArgs e)
    {
        //上一页
        this.Pageindex--;
        BindData();
    }
    protected void btn_pageNext_Click(object sender, EventArgs e)
    {
        //下一页
        this.Pageindex++;
        BindData();
    }
    protected void btn_pageFoot_Click(object sender, EventArgs e)
    {
        //末页
        this.Pageindex = PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1;
        BindData();
    }
    protected void btn_go_Click(object sender, EventArgs e)
    {
        //跳到指定的页
        string txtNumber = this.txt_PageNum.Text.ToString().Trim();
        int index = 1;
        if (Base.Common.CheckNum(txtNumber))
        {
            index = Convert.ToInt32(txtNumber);
            if (index >= 1 && index <= (PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1))
            {
                Pageindex = index;
                BindData();
            }
            else
            {
                Pageindex = 1;
                this.txt_PageNum.Text = "输入错误";
            }
        }
        else
        {
            Pageindex = 1;
            this.txt_PageNum.Text = "输入错误";
        }
    }
    #endregion
}
