﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Agent;
using Solely;

public partial class Member_Agent_SincereAgentAdd : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                ProvinceBind();
                int userid = Convert.ToInt32(GetCookie("UserID").ToString());
                int gradeid = Convert.ToInt32(GetCookie("GradeID").ToString());
                if (!Other.CheckUserBussinessCount(gradeid, "sincereagent", userid))
                {
                    Response.Redirect("../ErrorPage.aspx");
                }
            }
        }
        else
            Response.Redirect("../../login/login.aspx");
    }
    private void ProvinceBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/Province.xml"));
        dropRequire.DataSource = ds.Tables[0];
        dropRequire.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropRequire.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropRequire.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            myValue = lstParentType.SelectedValue;
            int userid = int.Parse(GetCookie("UserID"));
            TSincereAgent TSin = new TSincereAgent();
            TSin.UserID = userid;
            TSin.Name = txtName.Text.Trim();
            TSin.Title = txtTitle.Text;
            TSin.AgentType = int.Parse(myValue);
            TSin.Validity = radlValidity.SelectedValue;
            TSin.Brand = txtBrand.Text.Trim();
            TSin.Investment = dropInvestment.SelectedValue;
            TSin.Amount = Convert.ToDecimal(txtAmount.Text.Trim());
            TSin.InitialFee = Convert.ToDecimal(txtInitialFee.Text.Trim());
            TSin.Require = dropRequire.SelectedValue;
            if (txtCradle.Text != "")
                TSin.Cradle = txtCradle.Text;
            if (txtPayback.Text != "")
                TSin.Payback = Convert.ToDecimal(txtPayback.Text.Trim());
            if (txtPeriod.Text != "")
                TSin.Period = Convert.ToDecimal(txtPeriod.Text.Trim());
            if (txtConcession.Text != "")
                TSin.Concession = Convert.ToDecimal(txtConcession.Text.Trim());
            if (txtContract.Text != "")
                TSin.Contract = Convert.ToDecimal(txtContract.Text.Trim());
            if (radlisMoreBrand.SelectedValue != "")
                TSin.isMoreBrand = Convert.ToBoolean(radlisMoreBrand.SelectedValue);

            if (Common.CheckNum(txtCount.Text.Trim()))
            {
                TSin.Count = Convert.ToInt32(txtCount.Text.Trim());
            }
            if (Common.CheckNum(txtBusinessDate.Text.Trim()))
            {
                TSin.BusinessDate = Convert.ToInt32(txtBusinessDate.Text.Trim());
            }
            myValue = "";
            if (chklBusinessMode.SelectedValue != "")
            {
                foreach (ListItem li in chklBusinessMode.Items)
                {
                    if (li.Selected)
                    {
                        myValue += li.Value + ',';
                    }
                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                TSin.BusinessMode = myValue;
            }
            myValue = "";
            if (chklBusinessMode.SelectedValue != "")
            {
                foreach (ListItem li in chklDevelopmental.Items)
                {
                    if (li.Selected)
                    {
                        myValue += li.Value + ',';
                    }
                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                TSin.Developmental = myValue;
            }

            TSin.Detail = Detail.Value;
            TSin.Picture = ImgUrl1.Value;
            ISincereAgent RSin = new RSincereAgent();
            int isEmail = 0;
            RSin.Insert(TSin, out isEmail);
            ShowMessage("商机发布成功！", "Agent/SincereAgentList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
}
