﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Agent;
using System.Data.SqlClient;

public partial class Member_Agent_SincereAgentEdit : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
            return;
        }
        else
        {
            if (!IsPostBack)
            {
                ProvinceBind();
                Bind();
            }
        }
    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null)
        {
            int id = int.Parse(Request.QueryString["ID"].ToString());
            ISincereAgent RSin = new RSincereAgent();
            TSincereAgent TSin = RSin.GateItem(id);
            if (TSin.AgentType != null)
            {
                lstParentType.SelectedValue = TSin.AgentType.ToString();
            }
            txtName.Text = TSin.Name;
            txtTitle.Text = TSin.Title;
            radlValidity.SelectedValue = TSin.Validity;
            txtBrand.Text = TSin.Brand;
            dropInvestment.SelectedValue = TSin.Investment;
            txtAmount.Text = TSin.Amount.ToString();
            txtInitialFee.Text = TSin.InitialFee.ToString();
            dropRequire.SelectedValue = TSin.Require;
            if (TSin.Cradle != "" && TSin.Cradle != null)
            {
                txtCradle.Text = TSin.Cradle;
            }
            if (TSin.Payback.ToString() != "" && TSin.Payback.ToString() != "0")
            {
                txtPayback.Text = TSin.Payback.ToString();
            }
            if (TSin.Period.ToString() != "" && TSin.Period.ToString() != "0")
            {
                txtPeriod.Text = TSin.Period.ToString();
            }
            if (TSin.Concession.ToString() != "" && TSin.Concession.ToString() != "0")
            {
                txtConcession.Text = TSin.Concession.ToString();
            }
            if (TSin.Contract.ToString() != "" && TSin.Contract.ToString() != "0")
            {
                txtContract.Text = TSin.Contract.ToString();
            }
            if (TSin.Count.ToString() != "" && TSin.Count.ToString() != "0")
            {
                txtCount.Text = TSin.Count.ToString();
            }
            if (TSin.isMoreBrand.ToString() != "")
            {
                radlisMoreBrand.SelectedValue = TSin.isMoreBrand.ToString();
            }
            if (TSin.BusinessDate.ToString() != "" && TSin.BusinessDate.ToString() != "0")
            {
                txtBusinessDate.Text = TSin.BusinessDate.ToString();
            }
            if (TSin.BusinessMode != "" && TSin.BusinessMode != null)
            {
                string[] str = TSin.BusinessMode.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    chklBusinessMode.Items[Convert.ToInt32(str[i])].Selected = true;
                }
            }
            if (TSin.Developmental != "" && TSin.Developmental != null)
            {
                string[] str = TSin.Developmental.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    chklDevelopmental.Items[Convert.ToInt32(str[i])].Selected = true;
                }
            }
            Detail.Value = TSin.Detail;
            ImgUrl1.Value = TSin.Picture;
            ImgUrl.Src = TSin.Picture;
        }
    }
    private void ProvinceBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/Province.xml"));
        dropRequire.DataSource = ds.Tables[0];
        dropRequire.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropRequire.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropRequire.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            //myValue = lstSonType.SelectedValue;
            myValue = lstParentType.SelectedValue;
            TSincereAgent TSin = new TSincereAgent();
            if (Request.QueryString["ID"] != null)
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSin.ID = id;
            }
            TSin.Name = txtName.Text.Trim();
            TSin.Title = txtTitle.Text;
            TSin.AgentType = int.Parse(myValue);
            TSin.Validity = radlValidity.SelectedValue;
            TSin.Brand = txtBrand.Text.Trim();
            TSin.Investment = dropInvestment.SelectedValue;
            TSin.Amount = Convert.ToDecimal(txtAmount.Text.Trim());
            TSin.InitialFee = Convert.ToDecimal(txtInitialFee.Text.Trim());
            TSin.Require = dropRequire.SelectedValue;
            if (txtCradle.Text != "")
                TSin.Cradle = txtCradle.Text.Trim();
            if (txtPayback.Text != "")
                TSin.Payback = Convert.ToDecimal(txtPayback.Text.Trim());
            if (txtPeriod.Text != "")
                TSin.Period = Convert.ToDecimal(txtPeriod.Text.Trim());
            if (txtConcession.Text != "")
                TSin.Concession = Convert.ToDecimal(txtConcession.Text.Trim());
            if (txtContract.Text != "")
                TSin.Contract = Convert.ToDecimal(txtContract.Text.Trim());
            if (radlisMoreBrand.SelectedValue != "")
                TSin.isMoreBrand = Convert.ToBoolean(radlisMoreBrand.SelectedValue);

            if (Common.CheckNum(txtCount.Text.Trim()))
            {
                TSin.Count = Convert.ToInt32(txtCount.Text.Trim());
            }
            if (Common.CheckNum(txtBusinessDate.Text.Trim()))
            {
                TSin.BusinessDate = Convert.ToInt32(txtBusinessDate.Text.Trim());
            }
            myValue = "";
            if (chklBusinessMode.SelectedValue != "")
            {
                foreach (ListItem li in chklBusinessMode.Items)
                {
                    if (li.Selected)
                    {
                        myValue += li.Value + ',';
                    }

                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                TSin.BusinessMode = myValue;
            }
            myValue = "";
            if (chklBusinessMode.SelectedValue != "")
            {
                foreach (ListItem li in chklDevelopmental.Items)
                {
                    if (li.Selected)
                    {
                        myValue += li.Value + ',';
                    }

                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                TSin.Developmental = myValue;
            }
            TSin.Detail = Detail.Value;
            TSin.Picture = ImgUrl1.Value;
            ISincereAgent RSin = new RSincereAgent();
            RSin.Update(TSin);
            ShowMessage("商机修改成功！", "Agent/SincereAgentList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }

}
