﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Certificate;
using Base;

public partial class member_Certificate_CertificateEdit :nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
            return;
        }
        else
        {
            if (!IsPostBack)
            {
                Bind();
            }
        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"]);
        ICertificate RCerti = new RCertificate();
        TCertificate TCerti=RCerti.GateItem(id);
        this.txtName.Text = TCerti.Name;
        this.ImgUrl.Src= TCerti.URL;
        this.ImgUrl1.Value = TCerti.URL;
        this.txtOrganization.Text = TCerti.Organization;
        this.txtLicenceDate.Text = TCerti.LicenceDate.ToShortDateString();
        this.txtExpiryDate.Text = TCerti.ExpiryDate.ToShortDateString();
    }
    protected void btnServer_Click(object sender, EventArgs e)
    {
        try
        {
            int id = int.Parse(Request.QueryString["ID"]);
            ICertificate RCerti = new RCertificate();
            TCertificate TCerti = new TCertificate();
            TCerti.ID = id;
            TCerti.UserID = int.Parse(Request.QueryString["UserID"]);
            TCerti.Name = this.txtName.Text;
            TCerti.URL = ImgUrl1.Value;
            TCerti.Organization = this.txtOrganization.Text;
            TCerti.LicenceDate =Convert.ToDateTime( this.txtLicenceDate.Text);
            TCerti.ExpiryDate =Convert.ToDateTime( this.txtExpiryDate.Text);
            RCerti.Update(TCerti);
            ShowMessage("证书修改成功！", "Certificate/Certificate.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("证书修改失败！", "Certificate/Certificate.aspx");
        }

    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("Certificate.aspx");
    }
}
