﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UserInfo;　

public partial class member_Corporation_CompanyShow : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                Bind();
            }
        }
        else
        {
            Response.Redirect("../login/login.aspx");
        }       
     this.country.Attributes.Add("onChange", "diqu(this)");
    }
    /// <summary>
    /// 绑定公司信息
    /// </summary>
    private void Bind()
    {
        int ID = int.Parse(GetCookie("UserID"));
        if (ID > 0)
        {
            IUserInfo RCorp = new RUserInfo();
            TUserInfo TCorp = RCorp.GateItem(ID);


            this.txtCompanyName.Text = TCorp.CompanyName;
            this.radlCompanyNature.SelectedValue = TCorp.CompanyNature;
            this.chklBusinessModel.SelectedValue = TCorp.BusinessModel;
            this.txtDealinAdd.Text = TCorp.DealinAdd;
            this.txtProduct.Text = TCorp.Product;
            //this.txtIndustry.Text = TCorp.Industry;
            if (TCorp.Industry != null)
            {
                string[] str = TCorp.Industry.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (i == 0)
                        this.txtSortB.Value = str[i];
                    else if (i == 1)
                        this.txtSortM.Value = str[i];
                    else
                        this.txtSortS.Value = str[i];
                }
            }
            this.Summary.Value = TCorp.Summary;

            this.txtStreet.Text = TCorp.Street;
            this.txtPostalcode.Text = TCorp.Postalcode;
            this.txtURL.Text = TCorp.URL;
            this.txtCapital.Text = TCorp.Capital.ToString();
            this.txtEstablished.Text = TCorp.Established.ToShortDateString();
            this.txtRegisterAddress.Text = TCorp.RegisterAddress;
            this.country.Value = TCorp.Country;
            this.txtProvince.Value = TCorp.Province;
            this.txtCity.Value = TCorp.City;
            this.txtCounty.Value = TCorp.Area;
            this.txtCorporate.Text = TCorp.Corporate;
            if (TCorp.Logo == "")
            {
                this.ImgUrl1.Value = "../../Images/System/wutu.gif";
                this.ImgUrl.Src = "../../Images/System/wutu.gif";
            }
            else
            {
                this.ImgUrl.Src = Base.Common.ProcessImageUrl(TCorp.Logo);
                this.ImgUrl1.Value = TCorp.Logo;
            }
            ViewState["GradeID"] = TCorp.GradeID;
            if (TCorp.BusinessModel != null)
            {
                for (int i = 0; i < chklBusinessModel.Items.Count; i++)
                {
                    if (TCorp.BusinessModel.Contains(chklBusinessModel.Items[i].Value))
                    {
                        this.chklBusinessModel.Items[i].Selected = true;
                    }
                }
            }
        }
        else
        {
            HttpContext.Current.Response.Write("<script>location.href='/Error.aspx?err=5';</script>");
        }
    }
    protected void btnServer_Click(object sender, EventArgs e)
    {

        try
        {
            string myValue = "",myValue1="";
            int ID = int.Parse(GetCookie("UserID"));
            string CompanyName = this.txtCompanyName.Text;
            string CompanyNature = this.radlCompanyNature.Text;
            foreach (ListItem li in chklBusinessModel.Items)
            {
                if (li.Selected)
                {
                    myValue += li.Value + ',';
                }

            }
            if (myValue != "")
            {
                myValue = myValue.Substring(0, myValue.Length - 1);
            }
            int Capital = int.Parse(this.txtCapital.Text);
            DateTime Established = Convert.ToDateTime(this.txtEstablished.Text);
            string RegisterAddress = this.txtRegisterAddress.Text;
            string Country = this.country.Value;
            string Province = Request.Form["ctl00$ContInfo$province"];
           
            string City = Request.Form["ctl00$ContInfo$city"];
            string County = Request.Form["ctl00$ContInfo$county"];
            string DealinAdd = this.txtDealinAdd.Text;
            string Postalcode = this.txtPostalcode.Text;
            string Product = this.txtProduct.Text;
            if (Request.Form["ctl00$ContInfo$SortB"] != null && Request.Form["ctl00$ContInfo$SortB"] != "")
                myValue1 += Request.Form["ctl00$ContInfo$SortB"] + ",";
            if (Request.Form["ctl00$ContInfo$SortM"] != null && Request.Form["ctl00$ContInfo$SortM"] != "")
                myValue1 += Request.Form["ctl00$ContInfo$SortM"] + ",";
            if (Request.Form["ctl00$ContInfo$SortS"] != null && Request.Form["ctl00$ContInfo$SortS"] != "")
                myValue1 += Request.Form["ctl00$ContInfo$SortS"];
            string Industry = myValue1;
            string Summary = this.Summary.Value;
            string Street = this.txtStreet.Text;
            string URL = this.txtURL.Text;
            string Corporate = this.txtCorporate.Text;
            string Logo = this.ImgUrl1.Value.ToString();
            
            TUserInfo TCorp = new TUserInfo();
            TCorp.UserID = ID;
            TCorp.CompanyName = CompanyName;
            TCorp.CompanyNature = CompanyNature;
            TCorp.BusinessModel = myValue;
            TCorp.Capital = Capital;
            TCorp.Established = Established;
            TCorp.RegisterAddress = RegisterAddress;
            TCorp.Country = Country;
            TCorp.Province = Province;
            TCorp.City = City;
            TCorp.Area = County;
            TCorp.DealinAdd = DealinAdd;
            TCorp.Product = Product;
            TCorp.Industry = Industry;
            TCorp.Summary = Summary;
            TCorp.Street = Street;
            TCorp.Postalcode = Postalcode;
            TCorp.URL = URL;
            TCorp.Corporate = Corporate;
            TCorp.Logo = Logo;
            TCorp.GradeID =Convert.ToInt32(ViewState["GradeID"].ToString());
            IUserInfo RCorp = new RUserInfo();
            RCorp.UpdateCorpInfo(TCorp);
            this.lblMessage.Visible = true;
            this.lblMessage.Text = "公司信息修改成功！";
            Bind();
        }
        catch (Exception ex)
        {          
            ShowMessage(ex.Message);   
        }
    }

    private void showview(string reStr)
    {
        this.Label1.Text = reStr;
       // ImgLogo.ImageUrl = "~/" + Label1.Text;
    }
}
