﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;
using Solely;

public partial class Member_Expo_ExpoAdd : nspBase.MemberBasePge
{

    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                Bind();
                int userid = Convert.ToInt32(GetCookie("UserID").ToString());
                int gradeid = Convert.ToInt32(GetCookie("GradeID").ToString());
                if (!Other.CheckUserBussinessCount(gradeid, "expo", userid))
                {
                    Response.Redirect("../ErrorPage.aspx");
                }
            }
        }
        else
        {
            Response.Redirect("../../login/login.aspx");
        }
    }
    private void Bind()
    {
        IExpoType RExpoType = new RExpoType();
        DataTable dt = RExpoType.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "Type";
        dropTypeID.DataBind();

    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int userid = Convert.ToInt32(GetCookie("UserID").ToString());
            TExpo TExpo = new TExpo();
            TExpo.UserID = userid;
            TExpo.Title = Base.Common.RemoveHTML(txtTitle.Text);
            TExpo.TypeID = int.Parse(dropTypeID.SelectedValue);
            TExpo.StartDate = Convert.ToDateTime(txtStartDate.Text);
            TExpo.EndDate = Convert.ToDateTime(txtEndDate.Text);
            TExpo.Place = txtPlace.Text;
            TExpo.Authorize = txtAuthorize.Text;
            TExpo.FrontFor = txtFrontFor.Text;
            TExpo.Undertake = txtUndertake.Text;
            TExpo.Aidance = txtAidance.Text;
            TExpo.Summary = txtSummary.Text;
            TExpo.Range = txtRange.Text;
            TExpo.Period = dropPeriod.SelectedValue;
            TExpo.ExpoType = dropExpoType.SelectedValue;
            TExpo.Homepage = txtHomepage.Text;
            TExpo.Picture = ImgUrl1.Value;
            if (!string.IsNullOrEmpty(txtShowArea.Text))
            {
                if (GetRequest.isNum(txtShowArea.Text))
                {
                    TExpo.ShowArea = int.Parse(txtShowArea.Text);
                }
                else
                {
                    TExpo.ShowArea = 0;
                }
            }
           
            if (!string.IsNullOrEmpty(txtBusinessmen.Text))
            {
                if (GetRequest.isNum(txtBusinessmen.Text))
                {
                    TExpo.Businessmen = int.Parse(txtBusinessmen.Text);
                }
                else
                {
                    TExpo.Businessmen = 0;
                }
            }
            
            if (!string.IsNullOrEmpty(txtSpectator.Text))
            {
                if (GetRequest.isNum(txtSpectator.Text))
                {
                    TExpo.Spectator = int.Parse(txtSpectator.Text);
                }
                else
                {
                    TExpo.Spectator = 0;
                }
            }

            if (!string.IsNullOrEmpty(txtPrice.Text))
            {
                if (GetRequest.isNum(txtPrice.Text))
                {
                    TExpo.Price = int.Parse(txtPrice.Text);
                }
                else
                {
                    TExpo.Price = 0;
                }
            }

            if (!string.IsNullOrEmpty(txtMinNum.Text))
            {
                if (GetRequest.isNum(txtMinNum.Text))
                {
                    TExpo.MinNum = int.Parse(txtMinNum.Text);
                }
                else
                {
                    TExpo.MinNum = 0;
                }
            }
            
            IExpo RExpo = new RExpo();
            int isEmail = 0;
            RExpo.Insert(TExpo, out isEmail);
            ShowMessage("展会信息添加成功！", "Expo/ExpoList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("展会信息添加失败！", "Expo/ExpoList.aspx");
        }
    }

}
