﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class Member_Expo_ExpoEdit : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
            return;
        }
        else
        {
            if (!IsPostBack)
            {
                ExpoTypeBind();
                Bind();
            }
        }
    }
    private void ExpoTypeBind()
    {
        IExpoType RExpoType = new RExpoType();
        DataTable dt = RExpoType.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "Type";
        dropTypeID.DataBind();
    }
    private void Bind()
    {
        int id = 0;
        if (Request.QueryString["ID"] != null)
        {
            id = int.Parse(Request.QueryString["ID"].ToString());
        }
        IExpo RExpo = new RExpo();
        TExpo TExpo=RExpo.GateItem(id);
        txtTitle.Text = TExpo.Title;
        dropTypeID.SelectedValue = TExpo.TypeID.ToString();
        txtStartDate.Text = TExpo.StartDate.ToShortDateString();
        txtEndDate.Text = TExpo.EndDate.ToShortDateString();
        txtPlace.Text = TExpo.Place;
        txtAuthorize.Text = TExpo.Authorize;
        txtFrontFor.Text = TExpo.FrontFor;
        txtUndertake.Text = TExpo.Undertake;
        txtAidance.Text = TExpo.Aidance;
        txtSummary.Text = TExpo.Summary;
        txtRange.Text = TExpo.Range;
        dropPeriod.SelectedValue = TExpo.Period;
        dropExpoType.SelectedValue = TExpo.ExpoType;
        txtHomepage.Text = TExpo.Homepage;
        ImgUrl.Src = TExpo.Picture;
        ImgUrl1.Value=TExpo.Picture;
        txtShowArea.Text = TExpo.ShowArea.ToString();
        txtBusinessmen.Text = TExpo.Businessmen.ToString();
        txtSpectator.Text = TExpo.Spectator.ToString();
        txtPrice.Text = TExpo.Price.ToString();
        txtMinNum.Text = TExpo.MinNum.ToString();
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int id = 0;
            if (Request.QueryString["ID"] != null)
            {
                id = int.Parse(Request.QueryString["ID"].ToString());
            }
            TExpo TExpo = new TExpo();
            TExpo.ID = id;
            TExpo.Title = txtTitle.Text;
            TExpo.TypeID = int.Parse(dropTypeID.SelectedValue);
            TExpo.StartDate = Convert.ToDateTime(txtStartDate.Text);
            TExpo.EndDate = Convert.ToDateTime(txtEndDate.Text);
            TExpo.Place = txtPlace.Text;
            TExpo.Authorize = txtAuthorize.Text;
            TExpo.FrontFor = txtFrontFor.Text;
            TExpo.Undertake = txtUndertake.Text;
            TExpo.Aidance = txtAidance.Text;
            TExpo.Summary = txtSummary.Text;
            TExpo.Range = txtRange.Text;
            TExpo.Period = dropPeriod.SelectedValue;
            TExpo.ExpoType = dropExpoType.SelectedValue;
            TExpo.Homepage = txtHomepage.Text;
            TExpo.Picture = ImgUrl1.Value;
            TExpo.ShowArea = int.Parse(txtShowArea.Text);
            TExpo.Businessmen = int.Parse(txtBusinessmen.Text);
            TExpo.Spectator = int.Parse(txtSpectator.Text);
            TExpo.Price = int.Parse(txtPrice.Text);
            TExpo.MinNum = int.Parse(txtMinNum.Text);
            IExpo RExpo = new RExpo();
            RExpo.Update(TExpo);
            ShowMessage("展会信息修改成功！", "Expo/ExpoList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("展会信息修改失败！", "Expo/ExpoList.aspx");
        }
    }

    protected void btnBace_Click(object sender, EventArgs e)
    {
        Response.Write("<script> window.location.href='ExpoList.aspx'</script>");
    }
}
