﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class Member_Expo_ExpoList : nspBase.MemberBasePge
{
    string verify = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!CheckCookies())
            {
                Response.Redirect("../../login/login.aspx");
                return;
            }
            else
            {

                ExpoTypeBind();

                Bind();
            }
        }
    }

    private void Bind()
    {

        btnDelete.Attributes.Add("onclick", "return confirm('你确认要删除吗？')");
        int Userid = int.Parse(GetCookie("UserID"));
        if (Userid > 0)
        {
            int PageIndex = 0;
            if (HttpContext.Current.Request.QueryString["page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"].ToString());
            if (PageIndex <= 0) PageIndex = 1;
            string strWhere = " a.UserID=" + Userid;
            if (verify == "")
            {
                verify = "1";
            }
            if (Request.QueryString["Verify"] != null && Request.QueryString["Verify"] != "")
            {

                if (Request.QueryString["Verify"] == "4")//过期信息
                {
                    strWhere += " and (datediff(day,EndDate,getdate())>0)";
                }
                else if (Request.QueryString["Verify"] == "3")//审核中信息
                {
                    strWhere += " and Verify =";
                    strWhere += Request.QueryString["Verify"];
                }
                else if (Request.QueryString["Verify"] == "2")//未通过
                {
                    strWhere += " and Verify =";
                    strWhere += Request.QueryString["Verify"];
                }
                else //已发布上网
                {
                    strWhere += " and (datediff(day,EndDate,getdate())<0) and Verify =";
                    strWhere += Request.QueryString["Verify"];
                }
                verify = Request.QueryString["Verify"];
            }
            else //默认进入已发布上网
            {
                strWhere += " and Verify =1 and (datediff(day,EndDate,getdate())<0)";
            }
            if (Request.QueryString["TypeID"] != null && Request.QueryString["TypeID"] != "")
            {
                strWhere = " a.UserID=" + Userid + " and TypeID=" + Request.QueryString["TypeID"].ToString();
            }
            string strURl = Request.RawUrl;
            strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
            PageNo1.Strurl = strURl;
            PageNo1.FldName = "a.AddDate";
            PageNo1.Table = "W_Expo as a LEFT JOIN W_ExpoType as b on a.TypeID=b.ID";
            PageNo1.StrGetFields = "a.*,b.Type";
            PageNo1.PageSize = 12;
            DataTable dt = new DataTable();
            if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
            {
                PageNo1.Pageindex = Int32.Parse(Request.QueryString["page"].ToString());
                if (Session["strWhere"] != null)
                    strWhere = Session["strWhere"].ToString();
                PageNo1.Where = strWhere;
                dt = PageNo1.BindViewDesc();
            }
            else {
                PageNo1.Pageindex = 1;
                PageNo1.Where = strWhere;
                Session["strWhere"] = strWhere;
                dt = PageNo1.BindViewDesc();
            }
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "<font color='red'>暂无数据</font>";
            }
            else
                lblMessage.Visible = false;
            grdExpo.DataSource = dt.DefaultView;
            grdExpo.DataBind();
            dt.Clear();
            dt.Dispose();
            SetColor();
        }
        else
            Response.Redirect("../login/login.aspx");
    }


    /// <summary>
    /// 设置颜色
    /// </summary>
    private void SetColor()
    {
        if (Request.QueryString["Verify"] != null)
        {
            if (Request.QueryString["Verify"] == "3")
                this.menu2.Attributes.Add("class", "MenuLiCheck");
            else if (Request.QueryString["Verify"] == "2")
                this.menu3.Attributes.Add("class", "MenuLiCheck");
            else if (Request.QueryString["Verify"] == "4")
                this.menu4.Attributes.Add("class", "MenuLiCheck");
            else
                this.menu1.Attributes.Add("class", "MenuLiCheck");
        }
        else
            this.menu1.Attributes.Add("class", "MenuLiCheck");
    }
    private void ExpoTypeBind()
    {
        IExpoType RExpo = new RExpoType();
        DataTable dt = RExpo.GetDataTable();
        dropExpoType.DataSource = dt.DefaultView;
        dropExpoType.DataValueField = "ID";
        dropExpoType.DataTextField = "Type";
        dropExpoType.DataBind();
        ListItem li = new ListItem("--+所有分类信息+--", "0");
        dropExpoType.Items.Add(li);
        li.Selected = true;

    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }

    //搜索
    protected void btnSelect_Click(object sender, EventArgs e)
    {
       
        int Userid = int.Parse(GetCookie("UserID"));
        string strWhere = " a.UserID=" + Userid;
        if (txtKeyword.Text.Trim() != "")
        {
            strWhere += " and Title like '%" + txtKeyword.Text.Trim() + "%'";
        }
        if (dropExpoType.SelectedValue != "" && dropExpoType.SelectedValue != "0")
        {
            strWhere += " and TypeID=" + dropExpoType.SelectedValue;
        }
        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void grdExpo_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < grdExpo.Rows.Count; i++)
        {
            CheckBox cbox = grdExpo.Rows[i].FindControl("CheckBox1") as CheckBox;
            if (cbox.Checked == true)
            {
                int id = int.Parse(grdExpo.DataKeys[i].Value.ToString());
                IExpo RExpo = new RExpo();
                RExpo.Delete(id);
            }
        }
        Bind();
    }

}
