﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class Member_Expo_ExpoNewsAdd : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
            return;
        }
        else
        {
            if (!IsPostBack)
            {
                Bind();
            }
        }
    }
    private void Bind()
    {
        IExpoNewsType RExpo = new RExpoNewsType();
        DataTable dt = RExpo.GetDataTable();
        dropType.DataSource = dt.DefaultView;
        dropType.DataValueField = "ID";
        dropType.DataTextField = "Type";
        dropType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            TExpoNews TExpo = new TExpoNews();
            if (txtTitle.Text.Trim() != "")
                TExpo.Title = txtTitle.Text;
            else
            {
                ShowMessage("信息标题不能为空!");
                return;
            }
            TExpo.TypeID = int.Parse(dropType.SelectedValue);          
            if (ImgUrl1.Value.Trim() != "")
                TExpo.Picture = ImgUrl1.Value;
            else
                TExpo.Picture = "/Images/System/wutu.gif";
            TExpo.Attribute = myValue;
            TExpo.Origin = txtOrigin.Text;
            if(Detail.Value!="")
                TExpo.Detail = Detail.Value;
            else
            {
                ShowMessage("详细信息不能为空!");
                return;
            }
            IExpoNews RExpo = new RExpoNews();
            RExpo.Insert(TExpo);
            ShowMessage("展会资讯添加成功！", "Expo/ExpoNewsList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("展会资讯添加失败！", "Expo/ExpoNewsList.aspx");
        }
    }
}
