﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class Member_Expo_ExpoNewsEdit : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Response.Redirect("../../login/login.aspx"); return;
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
            return;
        }
        else
        {
            if (!IsPostBack)
            {
                ExpoNewsTypeBind();
                Bind();
            }
        }
      
    }
    private void ExpoNewsTypeBind()
    {
        IExpoNewsType RExpo = new RExpoNewsType();
        DataTable dt = RExpo.GetDataTable();
        dropType.DataSource = dt.DefaultView;
        dropType.DataValueField = "ID";
        dropType.DataTextField = "Type";
        dropType.DataBind();
    }
    private void Bind()
    { 
        int id=0;
        if (Request.QueryString["ID"] != null)
        {
            id = int.Parse(Request.QueryString["ID"].ToString());

            IExpoNews RExpo = new RExpoNews();
            TExpoNews TExpo = RExpo.GateItem(id);
            txtTitle.Text = TExpo.Title;
            dropType.SelectedValue = TExpo.TypeID.ToString();
            this.ImgUrl.Src=TExpo.Picture;
            this.ImgUrl1.Value=TExpo.Picture;
            txtOrigin.Text = TExpo.Origin;
            Detail.Value = TExpo.Detail;
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int id=0;
            if (Request.QueryString["ID"] != null)
            {
                id = int.Parse(Request.QueryString["ID"].ToString());
            }
            string myValue = "";
            TExpoNews TExpo = new TExpoNews();
            TExpo.ID = id;
            TExpo.Title = txtTitle.Text;
            TExpo.TypeID = int.Parse(dropType.SelectedValue);
            TExpo.Picture = ImgUrl1.Value;
            TExpo.Attribute = myValue;
            TExpo.Origin = txtOrigin.Text;
            TExpo.Detail = Detail.Value;
            TExpo.Verify = "3";
            IExpoNews RExpo = new RExpoNews();
            RExpo.Update(TExpo);
            ShowMessage("展会资讯修改成功！", "Expo/ExpoNewsList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("展会资讯修改失败！", "Expo/ExpoNewsList.aspx");
        }
    }
    protected void btnBack_Click(object sender, EventArgs e)
    { 
      Response.Write("<script > window.location.href='ExpoNewsList.aspx'</script>");
    }
    
}
