﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Expo;
using Base;

public partial class Member_Expo_ExpoNewsList : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
            return;
        }
        else
        {
            if (!IsPostBack)
            {
                ExpoNewsTypeBind();
                Bind();
            }
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "return confirm('你确认要删除吗？')");
        string strWhere = "1=1";
        if (txtKeyword .Text.Trim()!= "")
        {
            strWhere = strWhere + " and Title like '%" + txtKeyword.Text.Trim() + "%' ";
        }
        if (dropExpoNewsType.SelectedValue.ToString()!="0")
        {
            strWhere = strWhere + " and W_ExpoNews.TypeID =" + dropExpoNewsType.SelectedValue.ToString().Trim();
        }
        if (Request.QueryString["TypeID"] != null && Request.QueryString["TypeID"] != "")
        {
            strWhere = "W_ExpoNews.TypeID =" + Request.QueryString["TypeID"].ToString();
        }
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        
        PageNo1.Strurl = strURl;
        PageNo1.FldName = "AddDate";
        PageNo1.Table = "W_ExpoNews INNER JOIN W_ExpoNewsType on W_ExpoNews.TypeID = W_ExpoNewsType.ID";
        PageNo1.StrGetFields = "W_ExpoNews.*, W_ExpoNewsType.Type";
        PageNo1.PageSize = 12;

        DataTable dt = new DataTable();
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Int32.Parse(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            dt = PageNo1.BindViewDesc();
        }
        else {
            PageNo1.Pageindex = 1;
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            dt = PageNo1.BindViewDesc();
        }
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblMessage.Text = "<font color='red'>暂无数据</font>";
        }
        else
            lblMessage.Visible = false;
        grdExpoNews.DataSource = dt.DefaultView;
        grdExpoNews.DataBind();
        dt.Clear();
        dt.Dispose();       
    }
    private void ExpoNewsTypeBind()
    {
        IExpoNewsType RExpo = new RExpoNewsType();
        DataTable dt = RExpo.GetDataTable();
        dropExpoNewsType.DataSource = dt.DefaultView;
        dropExpoNewsType.DataValueField = "ID";
        dropExpoNewsType.DataTextField = "Type";
        dropExpoNewsType.DataBind();
        ListItem li = new ListItem("--+所有分类信息+--", "0");
        dropExpoNewsType.Items.Add(li);
        li.Selected = true;
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < grdExpoNews.Rows.Count; i++)
        {
            CheckBox cbox = (CheckBox)grdExpoNews.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = int.Parse(grdExpoNews.DataKeys[i].Value.ToString());
                IExpoNews RExpo = new RExpoNews();
                RExpo.Delete(id);
            }
        }
        Bind();
    }
    protected void grdConsultative_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdExpoNews.SelectedIndex = e.NewPageIndex;
        Bind();
    }
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        if (txtKeyword.Text.Trim() != "")
        {
            strWhere = strWhere + " and Title like '%" + txtKeyword.Text.Trim() + "%' ";
        }
        if (dropExpoNewsType.SelectedValue.ToString() != "0")
        {
            strWhere = strWhere + " and W_ExpoNews.TypeID =" + dropExpoNewsType.SelectedValue.ToString().Trim();
        }
        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void grdExpoNews_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }

}
