﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Solely;
using WebBasicInfo;
using UserInfo;
using VipGrade;

public partial class Member_Index : nspBase.MemberBasePge
{
    public string strGrade;
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (CheckCookies())
            {
                if (!IsPostBack)
                {
                    Bind();
                }
            }
            else
            {
               // ClientScript.RegisterStartupScript(GetType(),"","alert('abc')",true);
                //Response.Redirect("../login/HelpKey.aspx");
                Response.Redirect("~/login/login.aspx");
            }
        }
        catch(Exception ex)
        {
            // Response.Redirect("../Error.aspx");
            Response.Write(ex.Message);
        }

    }

    /// <summary>
    /// 会员中心首页
    /// </summary>
    private void Bind()
    {
        BasicBind();
        Product();
        ConsultativeBind();
        ExpoNewsBind();
        NewsBind();
    }
    /// <summary>
    /// 会员身份及网站咨询热线信息
    /// </summary>
    private void BasicBind()
    {
        IWebBasicInfo rbasic = new RWebBasicInfo();
        TWebBasicInfo tbasic = rbasic.GateItem();
        lblHotTel.Text = tbasic.HotTel;//热线电话

        IUserInfo ruser = new RUserInfo();
        TUserInfo tuser = ruser.GateItem(int.Parse(GetCookie("UserID")));

        IVipGrade grade = new RVipGrade();
        DataSet dt = grade.GetDataTable();

        if (dt.Tables[0].Rows.Count == 0)     //没有会员等级
        {
            //Response.Redirect("");
        }
        else if (dt.Tables[0].Rows.Count == 1)
        {
            strGrade = "您现在是" + dt.Tables[0].Rows[0]["Name"].ToString() + ",可以享受" + BasePage.Config.WebName + "的特权服务";
        }
        else
        {
            string strGradeName = "普通会员";
            for (int i = 0; i < dt.Tables[0].Rows.Count; i++)
            {
                if (dt.Tables[0].Rows[i]["ID"].ToString() == GetCookie("GradeID"))
                {
                    strGradeName = dt.Tables[0].Rows[i]["Name"].ToString();
                }
            }
            if (strGradeName != dt.Tables[0].Rows[0]["Name"].ToString())
            {
                strGrade = " 您现在是" + strGradeName + ",无法享受" + BasePage.Config.WebName + "的特权服务，建议您升级为" + dt.Tables[0].Rows[0]["Name"].ToString();
            }
            else
            {
                strGrade = "您现在是" + dt.Tables[0].Rows[0]["Name"].ToString() + ",可以享受" + BasePage.Config.WebName + "的特权服务";
            }
        }
        this.Introduce.InnerHtml = dt.Tables[0].Rows[0]["Name"].ToString() + "是" + BasePage.Config.WebName + "的一种会员身份，拥有多种优势、多种增值服务，及享有网站各种推广、优惠的活动的优先权利！";
       
    }
    /// <summary>
    /// 行业资讯
    /// </summary>
    private void ConsultativeBind()
    {
        int Pageindex = 1;
        int pageSize = 5;
        string strWhere = "1=1";
        string table = "W_ConsultativeType as b  Right  JOIN W_Consultative as a  ON a.TypeID = b.ID ";
        string select = "a.*,b.Name,(select count(*) from W_ConsultativeRestore as c where c.ConsultativeID=a.ID)as time";
        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "a.AddDate", select, pageSize, Pageindex, 0);
        dlstConsultative.DataSource = dt.DefaultView;
        dlstConsultative.DataBind();
        dt.Clear();
        dt.Dispose();
    }
    /// <summary>
    ///展会资讯 
    /// </summary>
    private void ExpoNewsBind()
    {
        int Pageindex = 1;
        int pageSize = 4;
        string strWhere = "1=1";
        string table = "W_Expo left JOIN W_ExpoType on W_Expo.TypeID = W_ExpoType.ID";
        string select = "W_Expo.*, W_ExpoType.Type";
        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "W_Expo.AddDate", select, pageSize, Pageindex, 0);
        dlstExpoNews.DataSource = dt.DefaultView;
        dlstExpoNews.DataBind();
    }
    /// <summary>
    /// 公司新闻
    /// </summary>
    private void NewsBind()
    {
        int Pageindex = 1;
        int pageSize = 4;
        int Userid = int.Parse(GetCookie("UserID"));
        string strWhere = "UserID=" + Userid;
        string table = "C_News";
        string select = "*";
        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "AddDate", select, pageSize, Pageindex, 0);
        dlstNews.DataSource = dt.DefaultView;
        dlstNews.DataBind();
    }
    /// <summary>
    /// 未审核、过期、未读留言的商机信息
    /// </summary>
    private void Product()
    {
        int Message = 0;
        int UnreadMessageCount = 0;
        int PastDueCount = 0;
        int UnauditedCount = 0;
        try
        {
            int Userid = int.Parse(GetCookie("UserID"));
            Other.CheckUserProductCount(Userid, out UnreadMessageCount, out PastDueCount, out UnauditedCount);
        }
        catch
        {
            return;
        }
        lblUnreadMesage.Text = UnreadMessageCount.ToString();
        lblPastDue.Text = PastDueCount.ToString();
        lblUnaudited.Text = UnauditedCount.ToString();
        if (UnreadMessageCount != 0)
            Message++;
        if (PastDueCount != 0)
            Message++;
        if (UnauditedCount != 0)
            Message++;
        lblMesage.Text = Message.ToString();
    }
}
