﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspJob;
using nspBase;

public partial class Member_Job_JobAdd : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            if (!CheckCookies())
            {
               Response.Redirect("../../login/login.aspx");
            }
            else
            {
                Bind();//绑定数据
            }
        }

    }

    ///**************************************************
    /// <summary>
    /// depiction：对职位类别绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-1
    ///**************************************************
    private void Bind()
    {
        Rjob jobtype = new Rjob();
        DataTable dt = jobtype.GetDataType("C_JobType");
        if (dt.Rows.Count == 0)
            return;
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "TypeName";
        dropTypeID.DataBind();
    }
    ///**************************************************
    /// <summary>
    /// depiction：对职位的新增
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-1
    ///**************************************************
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (!this.IsValid)
        {
            return;
        }
        try
        {
             int userid = Convert.ToInt32(GetRequest.GetCookie("UserID").ToString());//获取企业编号 
            TJob tjob = new TJob();
            Rjob rjob = new Rjob();
            if (rjob.GetDataPositionExists(this.txtposition.Text,userid))
            {
                lblmessage.Text = "该职位名称已经存在，请更换别的名称";
                this.divfail.Visible = true;
                return;
            }
            else
            {
                lblmessage.Text = "";
            }

            if (userid != 0)
            {
                tjob.UserID = userid;//企业会员id
            }
            tjob.Position = this.txtposition.Text.ToString().Trim();//职位名称
            tjob.JobCount = Convert.ToInt32(this.txtcount.Text.ToString().Trim());//招聘人数
            tjob.Degree = this.txteducation.Text.ToString().Trim();//学历
            if (Convert.ToInt32(txtage1.Text.ToString().Trim()) >= Convert.ToInt32(txtage2.Text.ToString().Trim()))
            {
                lblwrong.Text = "起始年龄不能大于终止年龄";
                this.divfail.Visible = true;

                return;
            }
            else
            {
                lblwrong.Text = "";
            }
            if (Convert.ToInt32(txtage1.Text.ToString().Trim()) <= 0 || Convert.ToInt32(txtage1.Text.ToString().Trim()) > 100)
            {

                lblwrong.Text = "年龄不能小于0，或者大于100";
                this.divfail.Visible = true;
                return;
            }
            else
            {
                lblwrong.Text = "";
            }
            if (Convert.ToInt32(txtage1.Text.ToString().Trim()) < Convert.ToInt32(txtage2.Text.ToString().Trim()))
            {
                if (Convert.ToInt32(txtage1.Text.ToString().Trim()) > 0 && Convert.ToInt32(txtage1.Text.ToString().Trim()) < 100)
                {
                    tjob.AgeRequest = this.txtage1.Text.ToString().Trim() + "~" + this.txtage2.Text.ToString().Trim();//年龄要求
                }
            }

            tjob.TypeID =Convert.ToInt32(dropTypeID.SelectedValue);
            tjob.Experience = this.txtwork.Text.ToString().Trim();//工作经验
            tjob.WorkTemper = this.txtTemper.Text.ToString().Trim();//工作性质
            tjob.Address = this.txtaddress.Text.ToString().Trim();//工作地址
            tjob.SalaryLevel = this.dropsalary.SelectedValue;//薪水要求
            tjob.Sex = this.dropsex.SelectedValue;//性别要求
            tjob.EnglishLevel = this.dropEnlish.SelectedValue;//英文水平
            tjob.ComputerLevel = this.dropcomputer.SelectedValue;//计算机水平
            DateTime dt1 = Convert.ToDateTime(enddate.Text.ToString());
            DateTime dt2 = Convert.ToDateTime(DateTime.Now.ToLongDateString());
            if (dt1 < dt2)
            {
                Lblmsgtime.Text = "截止日期不能小于当前日期";
                return;
            }
            tjob.EndDate = Convert.ToDateTime(GetShortDate(enddate.Text.ToString().Trim()));//截止日期
            int count = rjob.Insert(tjob);//调用数据层里的增加方法

            if (count > 0)//如果count大于0，那么增加成功
            {
                this.divfail.Visible = false;
                ShowMessage("恭喜您，职位信息发布成功！", "Job/CompanyJobList.aspx?class=MenuLiCheck");
            }
            else
            {
                this.divfail.Visible = true;
            }
        }
        catch
        {
            this.divfail.Visible = true;
            divfail.InnerHtml = "服务器繁忙，请稍后再试";
        }

    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>location.assign('CompanyJobList.aspx');</script>");
    }
}
