﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspJob;
using Base;

public partial class Member_Job_JobEdit : nspBase.MemberBasePge
{
    string age = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (!CheckCookies())
            {
                Response.Redirect("../../login/login.aspx");
            }
            else
            {
                BindPosition();
                Bind();
            }
        }

    }
    ///**************************************************
    /// <summary>
    /// depiction：对职位类别绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    private void BindPosition()
    {
        Rjob jobtype = new Rjob();
        DataTable dt = jobtype.GetDataType("C_JobType");
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "TypeName";
        dropTypeID.DataBind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于获取页面传过来的值、然后绑定控件。
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************
    public void Bind()
    {
        string id = "";
        string age1 = "";
        string age2 = "";
        if (Request.QueryString["ID"] != null)
        {
            id = Request["id"];
        }
        Rjob ijob = new Rjob();
        DataTable table = ijob.GetDataTable("C_Job", id);
        if (table.Rows.Count != 0)
        {
            this.dropTypeID.SelectedValue = table.Rows[0]["TypeID"].ToString();
            this.txtposition.Text = table.Rows[0]["Position"].ToString();
            this.txtcount.Text = table.Rows[0]["Count"].ToString();
            this.txteducation.SelectedValue = table.Rows[0]["Degree"].ToString();
            age = table.Rows[0]["AgeRequest"].ToString();
            age1 = age.Substring(0, age.LastIndexOf('~'));
            age2 = age.Substring(age.LastIndexOf('~') + 1);
            this.txtage1.Text = age1;
            this.txtage2.Text = age2;
            this.txtwork.Text = table.Rows[0]["Experience"].ToString();
            this.txtTemper.Text = table.Rows[0]["WorkTemper"].ToString();
            this.txtaddress.Text = table.Rows[0]["Address"].ToString();
            this.dropsalary.SelectedValue = table.Rows[0]["SalaryLevel"].ToString();
            this.dropsex.SelectedValue = table.Rows[0]["Sex"].ToString();
            this.dropEnlish.SelectedValue = table.Rows[0]["EnglishLevel"].ToString();
            this.dropcomputer.SelectedValue = table.Rows[0]["ComputerLevel"].ToString();
            this.txtenddate.Text = GetShortDate(table.Rows[0]["EndDate"].ToString());
        }
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于更新数据
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-2
    ///**************************************************

    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (!this.IsValid)
        {
            return;
        }
        try
        {
            string id = "";
            if (Request.QueryString["ID"] != null)
            {
                id = Request["id"];
            }
            TJob tj = new TJob();
            IJob ij = new Rjob();
            tj.ID = Convert.ToInt32(id);
            tj.TypeID = Convert.ToInt32(this.dropTypeID.SelectedValue);
            tj.Position = this.txtposition.Text;
            tj.JobCount = Convert.ToInt32(this.txtcount.Text);
            tj.Degree = this.txteducation.SelectedValue;
            tj.AgeRequest = this.txtage1.Text + "~" + this.txtage2.Text;
            if (Convert.ToInt32(txtage1.Text.ToString().Trim()) >= Convert.ToInt32(txtage2.Text.ToString().Trim()))
            {
                lblwrong.Text = "起始年龄不能大于终止年龄";
                this.pnlFail.Visible = true;
                this.pnlSucess.Visible = false;
                return;
            }
            else
            {
                lblwrong.Text = "";
            }
            if (Convert.ToInt32(txtage1.Text.ToString().Trim()) <= 0 || Convert.ToInt32(txtage1.Text.ToString().Trim()) > 100)
            {

                lblwrong.Text = "年龄不能小于0，或者大于100";
                this.pnlFail.Visible = true;
                this.pnlSucess.Visible = false;
                return;
            }
            else
            {
                lblwrong.Text = "";
            }
            tj.Experience = this.txtwork.Text;
            tj.WorkTemper = this.txtTemper.Text;
            tj.Address = this.txtaddress.Text;
            tj.SalaryLevel = this.dropsalary.SelectedValue;
            tj.Sex = this.dropsex.SelectedValue;
            tj.EnglishLevel = this.dropEnlish.SelectedValue;
            tj.ComputerLevel = this.dropcomputer.SelectedValue;
            DateTime dt1 = Convert.ToDateTime(txtenddate.Text.ToString());
            DateTime dt2 = Convert.ToDateTime(DateTime.Now.ToLongDateString());
            if (dt1 < dt2)
            {
                Lblmsgtime.Text = "截止日期不能小于当前日期";
                return;
            }
            tj.EndDate = Convert.ToDateTime(GetShortDate(this.txtenddate.Text));
             
            int count = ij.Update(tj);
            if (count > 0)
            {
                //页面跳转
                this.pnlSucess.Visible = true;
                ShowMessage("恭喜您，职位信息修改成功！", "Job/CompanyJobList.aspx?class=MenuLiCheck");
            }

        }
        catch (Exception error)
        {
            Response.Write(error.Message);
            //异常处理
        }
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>location.assign('CompanyJobList.aspx');</script>");
    }
}
