﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspJob;
using Base;

public partial class Job_ResumeAdd : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            this.lblHead.Text = Common.GetBottom(lblHead.Text);
            this.bt.Text = Common.GetBottom(bt.Text);
            PositionTypeBind();

        }
    }
    ///**************************************************
    /// <summary>
    /// depiction：对职位类别绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-1
    ///**************************************************
    private void PositionTypeBind()
    {

        RResume jobtype = new RResume();
        DataTable dt = jobtype.GetDataTable("C_JobType");
        DrpTypePosition.DataSource = dt.DefaultView;
        DrpTypePosition.DataValueField = "ID";
        DrpTypePosition.DataTextField = "TypeName";
        DrpTypePosition.DataBind();
    }

    ///**************************************************
    /// <summary>
    /// depiction：此方法用于保存简历信息
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-4
    ///**************************************************
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (!this.IsValid)
        {
            return;
        }
        int num = 0;
        RUser ru = new RUser();
        TUser tu = new TUser();
        TResume tr = new TResume();
        RResume rr = new RResume();
        try
        {
            if (rr.CheckUser(this.txtLoginName.Text))
            {
                tu.LoginName = this.txtLoginName.Text;
                this.checkUser.Text = "";
            }
            else
            {
                this.checkUser.Text = "登陆名已存在，请更换登陆名";
                return;
            }
            tu.password = this.txtPassword.Value;
            tr.WantPosition = this.txtPosition.Text;
            tr.Photo = ImgUrl1.Value;
            tr.DateofBirth = Convert.ToDateTime(this.txtAge.Text.ToString());
            tr.GraduateSchool = this.txtGraduteSchool.Text;
            tr.WantAddress = this.txtWantAddress.Text;
            tr.JobDescription = GetRequest.RemoveHTMLForEditor(this.txtDescription.Text);
            tr.NativePlace = txtNative.Text;
            tr.PersResume = GetRequest.RemoveHTMLForEditor(this.txtPersonResum.Text);
            tr.Name = this.txtName.Text;
            tr.QQ = this.txtQQ.Text;
            tr.Telephone = this.txtTelphone.Text;
            tr.Mobile = this.txtMobel.Text;
            tr.Email = this.txtEmail.Text;
            tr.ContactAddress = this.txtAddress.Text;
            tr.Txtwork = txtwork.SelectedItem.ToString();
            tr.MaritalStatus = Radhunyin.SelectedValue;
            tr.Sex = DrpSex.SelectedValue;
            tr.HighestEducation = txteducation.SelectedValue;
            tr.ComputerRequest = dropcomputer.SelectedValue;
            tr.EnglishRequest = dropEnlish.SelectedValue;
            tr.TalentType = DrpTypePosition.SelectedValue.ToString();
            tr.WantSalary = dropsalary.SelectedValue;
            int num1 = rr.Insert(tr);//添加简历
            int num2 = ru.Insert(tu);//添加用户
            Response.Cookies["uName"].Value = txtLoginName.Text;//保存用户名到cookie中
            Response.Cookies["uName"].Expires = DateTime.Now.AddDays(1);
            Response.Cookies["uPwd"].Value = tu.password;//保存用户名到cookie中
            Response.Cookies["uPwd"].Expires = DateTime.Now.AddDays(1);
            //申请完职位后，然后进行注册  职位的应聘操作
            int ResumeId = 0;//简历ID
            int JobId = 0;//职位ID
            if (Session["jobid"] != null && Request.Cookies["uName"] != null)
            {
                ResumeId = ru.GetResumeIdByName(Request.Cookies["uName"].Value);
                JobId = Convert.ToInt32(Session["jobid"].ToString());
                num = ru.InsertJobResume(ResumeId, JobId);
            }
            if (num1 > 0 && num2 > 0)
            {
                this.divSucess.Visible = true;
                divSucess.InnerHtml = "注册成功";
                Response.Write("<script>location.assign('Index.aspx');</script>");
            }
            if (num > 0)
            {
                this.divSucess.Visible = true;
                divSucess.InnerHtml = "申请职位成功";
                Response.Write("<script>location.assign('PositionList.aspx');</script>");
            }
        }
        catch
        {
            this.divSucess.Visible = true;
            divSucess.InnerHtml = "系统繁忙，请稍后再试！"; //异常处理
        }

    }
}
