﻿<%@ Page Language="C#" MasterPageFile="~/Member/UserManage.master" AutoEventWireup="true"
    CodeFile="ProblemsList.aspx.cs" Inherits="Member_Know_KnowProblemsList" Title="管理我的提问" %>

<%@ Register Src="../../Control/PageNo.ascx" TagName="PageNo" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContInfo" runat="Server">
    <div id="sub_content">
        <div class="pagetitle">
            管理我的提问</div>
        <div class="main_Supply_nav">
            <ul>
                <li id="menu1" runat="server"><a href="ProblemsList.aspx">全部问题</a></li>
                <li id="menu2" runat="server"><a href="ProblemsList.aspx?v=1">已解决</a></li>
                <li id="menu3" runat="server"><a href="ProblemsList.aspx?v=0">待解决</a></li>
            </ul>
        </div>
        <asp:GridView ID="grdProblem" runat="server" AutoGenerateColumns="False" CssClass="table_main">
            <Columns>
                <asp:TemplateField HeaderText="标题">
                    <ItemTemplate>
                        <a href="<%=WebUrl %>Know/Detail-<%# Eval("ID") %><%=Rewrite %>" target="_blank">
                            <%# Eval("Caption") %>
                        </a></a>
                    </ItemTemplate>
                    <ItemStyle CssClass="leftt" />
                </asp:TemplateField>
                <asp:BoundField DataField="AnswerCount" HeaderText="回答数" />
                <asp:TemplateField HeaderText="是否审核">
                    <ItemTemplate>
                        <%# Eval("Verify").ToString()== "True" ? "已审" : "未审"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="问题状态">
                    <ItemTemplate>
                        <%# Eval("State").ToString() == "True" ? "已结贴" : "未结贴"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="提问时间">
                    <ItemTemplate>
                        <asp:Label ID="Label1" runat="server" Text='<%# Base.Common.GetShortDate(Eval("AddDate").ToString()) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="UserName" HeaderText="提问人" />
            </Columns>
            <HeaderStyle CssClass="header" />
        </asp:GridView>
        <asp:Label ID="lblMessage" runat="server" Text="Label" Visible="False"></asp:Label>
        <div class="paging">
		 <p>
            <uc1:PageNo ID="PageNo1" runat="server" />
	     </p>
        </div>
    </div>
</asp:Content>
