﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Corporation.Link;


public partial class member_Link_LinkEdit : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                Bind();
            }
        }
        else
        {
            Response.Redirect("../../login/login.aspx");
        }
    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null)
        {
            int id = int.Parse(Request.QueryString["ID"].ToString());
            ILink RLink = new RLink();
            TLink TLink = RLink.GateItem(id);
            txtName.Text = TLink.Name;
            txtUrl.Text = TLink.Url;
            ImgUrl1.Value = ProcessImageUrl(TLink.Logo);
            ImgUrl.Src = ProcessAbsoluteUrl(TLink.Logo.ToString());
  
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TLink TLink = new TLink();
                TLink.ID = id;
                TLink.Name = txtName.Text.Trim();
                TLink.Url = txtUrl.Text;
                TLink.Logo = Common.ProcessImageUrl(ImgUrl1.Value);
                ILink RLink = new RLink();
                RLink.Update(TLink);
                ShowMessage("友情链接修改成功！", "Link/LinkList.aspx");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }
    protected void btnBack_Click(object sender, EventArgs e)
    {
        Response.Write("<script language=javascript>window.location.href='LinkList.aspx'</script>");
    }
}
