﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Message;
using Base;

public partial class member_Message_MessageAdd : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
        }
        else
        {
            if (!IsPostBack)
            {
                Bind();
            }
        }
    }
    private void Bind()
    {
        //取得留言信息
        Message.TMessage tm = new TMessage();
        IMessage im = new RMessage();
        if(!string.IsNullOrEmpty(Request.QueryString["id"].ToString()))
        {
            if(! Base.Common.CheckNum( Request.QueryString["id"].ToString()))
            {
                ShowMessage("该留言不存在！","");
                return;
            }
        }
        else
        {
            ShowMessage("该留言不存在！","");
            return;
        }

        Solely.Other.UpOnlyDate("C_Message", " [Restore]=1 ", " ID=" + int.Parse(Request.QueryString["id"].ToString()));
         

        tm = im.GateItem(int.Parse(Request.QueryString["id"].ToString()));
        this.lblDate.Text = tm.Date.ToString();
        this.lblInfo.Text = tm.Info.ToString();
        this.lblTitle.Text = tm.Title.ToString();
        this.txtTitle.Text = "回复：" + tm.Title.ToString();
        this.ViewState["strNature"] = tm.Nature.ToString();
        this.ViewState["intReceiveUserID"] = tm.SendUserID;

        //取得留言人信息
        UserInfo.TUserInfo tu = new UserInfo.TUserInfo();
        UserInfo.IUserInfo iu = new UserInfo.RUserInfo();
        if(!string.IsNullOrEmpty(Base.GetRequest.GetQueryStringValue("uid")))
        {
            if(! Base.Common.CheckNum( Request.QueryString["uid"].ToString()))
            {
                ShowMessage("留言人不存在！","");
                return;
            }
        }
        else
        {
            ShowMessage("留言人不存在！","");
            return;
        }
        tu = iu.GateItem(int.Parse(Request.QueryString["uid"].ToString()));
        this.CompanyName.InnerText = tu.CompanyName.ToString();
        this.CompanyName.HRef = Base.BasePage.Config.WebURL + "Shop/index/" + tu.LoginName.ToString() + ".shtml";
        this.txtLinkName.Text = tu.LinkName.ToString();
        
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (txtTitle.Text.Trim() == "" || txtInfo.Text.Trim() == "")
        {
            lblMessage.Visible = true;
            lblMessage.Text = "标题、内容不能为空！";
            return;
        }
        if (Request.QueryString["uid"].ToString() != null)
        {
            try
            {
              
                TMessage TM = new TMessage();
                TM.ReceiveUserID = (int)this.ViewState["intReceiveUserID"];
                TM.SendUserID= Convert.ToInt32(Base.BasePage.GetCookie("UserID"));
                TM.Title = txtTitle.Text;
                TM.Info = txtInfo.Text;
                TM.Date = DateTime.Now;
                TM.Nature = this.ViewState["strNature"].ToString();
                IMessage RM = new RMessage();
                RM.Insert(TM);
                Solely.Other.UpOnlyDate("C_Message", " [Restore]=2 ", " ID=" + int.Parse(Request.QueryString["id"].ToString()));
                ShowMessage("留言成功！", "Message/ReceiveMessage.aspx");
            }
            catch (Exception ex)
            {
                ShowMessage(ex.Message);
               
            }
           
        }
       
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("ReceiveMessage.aspx");
    }
}
