﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Message;
using Base;

public partial class member_Message_SendMessage :nspBase.MemberBasePge
{
    private int pageSize = 12;//这里设置分页尺寸
    #region 分页属性
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../../login/login.aspx");
        }
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        int Userid = Convert.ToInt32(Base.BasePage.GetCookie("UserID"));

        string[] str = new string[4];
        str[0] = "SendUserID=" + Userid;
        str[1] = "";
        str[2] = "";
        str[3] = "";
        pbind(str, Pageindex);

    }

    /// <summary>
    /// 取得分页数据
    /// </summary>
    /// <param name="strWhere">查询条件</param>
    /// <param name="intPageIndex">第几页</param>
    private void pbind(string[] str, int PageIndex)
    {
        int intCount = 0;
        PageCount = intCount;
        IMessage RMess = new RMessage();
        DataTable dt = RMess.GetDataTable(str, Pageindex, out intCount);
        PageCount = intCount;
        this.txt_pageCount.Text = PageCount.ToString();
        if (Pageindex == 1)
        {
            this.txt_pageFirst.Visible = false;
            this.txt_pageLast.Visible = false;
        }
        else
        {
            this.txt_pageFirst.Visible = true;
            this.txt_pageLast.Visible = true;
        }
        if (Pageindex == (PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1))
        {
            this.txt_pageNext.Visible = false;
            this.txt_pageFoot.Visible = false;
        }
        else
        {
            this.txt_pageNext.Visible = true;
            this.txt_pageFoot.Visible = true;
        }
        this.txt_begin.Text = Pageindex.ToString();
        this.txt_pageAll.Text = Convert.ToString((PageCount % pageSize == 0 ? PageCount / pageSize : (PageCount / pageSize) + 1));
        this.txt_PageNum.Text = Pageindex.ToString();
        grdMessage.DataSource = dt.DefaultView;
        grdMessage.DataBind();
    }


    #region 分页事件方法
    protected void txt_pageFirst_Click(object sender, EventArgs e)
    {
        //首页
        this.Pageindex = 1;
        Bind();
    }
    protected void txt_pageLast_Click(object sender, EventArgs e)
    {
        //上一页
        this.Pageindex--;
        Bind();
    }
    protected void txt_pageNext_Click(object sender, EventArgs e)
    {
        //下一页
        this.Pageindex++;
        Bind();
    }
    protected void txt_pageFoot_Click(object sender, EventArgs e)
    {
        //末页
        this.Pageindex = PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1;
        Bind();
    }
    protected void Lk_go_Click(object sender, EventArgs e)
    {
        //跳到指定的页
        string txtNumber = this.txt_PageNum.Text.ToString().Trim();
        int index = 1;
        if (Base.Common.CheckNum(txtNumber))
        {
            index = Convert.ToInt32(txtNumber);
            if (index >= 1 && index <= (PageCount % pageSize == 0 ? PageCount / pageSize : PageCount / pageSize + 1))
            {
                Pageindex = index;
                Bind();
            }
            else
            {
                Pageindex = 1;
                this.txt_PageNum.Text = "1";
            }
        }
        else
        {
            Pageindex = 1;
            this.txt_PageNum.Text = "1";
        }
    }
    #endregion
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return string.Empty;
    }
    public string GetCharacter(string str_Value)
    {
        if (str_Value == "1")
        {
            return "已读";
        }
        else if (str_Value == "0")
        {
            return "未读";
        }
        else
        {
            return "已回复";
        }
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdMessage.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdMessage.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                int UserID = Convert.ToInt32(grdMessage.DataKeys[i].Value);
                IMessage RM = new RMessage();
                int m = RM.Delete(UserID);
            }
        }
        Bind();
    }
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        string Userid = Base.BasePage.GetCookie("UserID");
        string Info = this.txtMessage.Text.Trim();
        Info = Base.GetRequest.Filter(Info);
        string State = dropMessageState.SelectedValue;
        string Date = dropMessageDate.SelectedValue;


        string[] str = new string[4];
        str[0] = "SendUserID=" + Userid;
        str[1] = Info;
        str[2] = State;
        str[3] = Date;
        pbind(str, Pageindex);
    }

    public string GetNewTitle(string LoginName)
    {
        string Restr = "<a href=\"" + Base.BasePage.Config.WebURL + "Shops/index/" + LoginName + BasePage.Config.Rewrite + "\" target=\"blank\">" + LoginName + "</a>";
        return Restr;
    }
}
