﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UserInfo;
using Email.Subscription;


public partial class Member_Subscription_SubscriptionChangeEmail : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                EmailBind();
            }
        }
        else
            Response.Redirect("../../login/login.aspx");
    }
    private void EmailBind()
    {
        int userid = int.Parse(GetCookie("UserID"));
        IUserInfo ruser = new RUserInfo();
        TUserInfo tuser = ruser.GateItem(userid);
        lblEmail.Text = tuser.Email;
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        int userid = int.Parse(GetCookie("UserID"));
        SubscriptionEmail news = new SubscriptionEmail();
        news.UserID = userid;
        if (Base.GetRequest.isMail(txtEmail.Text.Trim()))
        {
            news.Email = txtEmail.Text.Trim();
        }
        else
        {
            ShowMessage("邮箱格式不正确");
            return;
        }
        news.Update(news);
        ShowMessage("邮箱修改成功！", "Subscription/SubscriptionNewsAdd.aspx");
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("SubscriptionNewsList.aspx");
    }
}
