﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Product;
using UserInfo;
using AdminRights;
using Favorites;

public partial class member_Trade_FavoriteList : nspBase.MemberBasePge
{
    protected string WebUrl, Rewrite;
    protected void Page_Load(object sender, EventArgs e)
    {
        WebUrl = Base.BasePage.Config.WebURL;
        Rewrite = Base.BasePage.Config.Rewrite;
        if (CheckCookies())
        {
            if (!Page.IsPostBack)
            {
                Bind();
            }
        }
        else
            Response.Redirect("../../login/login.aspx");
    }
    private void Bind()
    {
        int Userid = int.Parse(GetCookie("UserID"));
        if (Userid > 0)
        {
            int page = 1;
            string strWhere = "";
            string strselect = "";
            string table = "";
            DataTable dt = new DataTable();
            if (Request.QueryString["content_type"] != null && Request.QueryString["content_type"] != "")
            {
                string type = Request.QueryString["content_type"].ToString();
                switch (type.ToUpper())
                {
                    case "SUPPLY":
                        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
                        {
                            page = int.Parse(Request.QueryString["page"].ToString());
                        }
                        strselect = "U_UserInfo.CompanyName,U_UserInfo.QQ,C_Supply.*";
                        table = "C_Supply INNER JOIN U_UserInfo ON C_Supply.UserID =U_UserInfo.UserID INNER JOIN U_Favorites ON C_Supply.ID = U_Favorites.ProductID";
                        strWhere = "1=1 and U_Favorites.Type='Supply' and U_Favorites.UserID=" + Userid;
                        dt = PageList.GetDataTable(strWhere, table, 1, "C_Supply.AddDate", "*", 10, page, 0);
                        dlstSupply.DataSource = dt.DefaultView;
                        dlstSupply.DataBind();
                        lblPagination.Text = PageList.GoToPager(page, 10, "FavoriteList.aspx?content_type=" + type + "&page", strWhere, table);
                        pnlPurchase.Visible = false;
                        pnlCompany.Visible = false;
                        break;
                    case "PURCHASE":
                        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
                        {
                            page = int.Parse(Request.QueryString["page"].ToString());
                        }
                        strselect = "U_UserInfo.CompanyName,U_UserInfo.QQ,C_Purchase.*";
                        table = "C_Purchase INNER JOIN U_UserInfo ON C_Purchase.UserID =U_UserInfo.UserID INNER JOIN U_Favorites on U_Favorites.ProductID=C_Purchase.ID";
                        strWhere = "1=1 and U_Favorites.Type='Purchase' and U_Favorites.UserID=" + Userid;
                        dt = PageList.GetDataTable(strWhere, table, 1, "C_Purchase.AddDate", "*", 10, page, 0);

                        dlstPurchase.DataSource = dt.DefaultView;
                        dlstPurchase.DataBind();
                        lblPagination.Text = PageList.GoToPager(page, 10, "FavoriteList.aspx?content_type=" + type + "&page", strWhere, table);
                        pnlSupply.Visible = false;
                        pnlCompany.Visible = false;
                        break;
                    case "COMPANY":
                        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
                        {
                            page = int.Parse(Request.QueryString["page"].ToString());
                        }
                        strselect = "U_UserInfo.*";
                        table = "U_UserInfo INNER JOIN U_Favorites on U_UserInfo.UserID=U_Favorites.ProductID";
                        strWhere = "1=1 and U_Favorites.Type='Company' and U_Favorites.UserID=" + Userid;
                        dt = PageList.GetDataTable(strWhere, table, 0, "U_UserInfo.UserID", "*", 10, page, 0);
                        dlstCompany.DataSource = dt.DefaultView;
                        dlstCompany.DataBind();
                        lblPagination.Text = PageList.GoToPager(page, 10, "FavoriteList.aspx?content_type=" + type + "&page", strWhere, table);
                        pnlSupply.Visible = false;
                        pnlPurchase.Visible = false;
                        break;
                    default:
                        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
                        {
                            page = int.Parse(Request.QueryString["page"].ToString());
                        }
                        strselect = "U_UserInfo.CompanyName,U_UserInfo.QQ,C_Supply.*";
                        table = "C_Supply INNER JOIN U_UserInfo ON C_Supply.UserID =U_UserInfo.UserID INNER JOIN U_Favorites ON C_Supply.ID = U_Favorites.ProductID";
                        strWhere = "1=1 and U_Favorites.Type='Supply' and U_Favorites.UserID=" + Userid;
                        dt = PageList.GetDataTable(strWhere, table, 1, "C_Supply.AddDate", "*", 10, page, 0);
                        dlstSupply.DataSource = dt.DefaultView;
                        dlstSupply.DataBind();
                        lblPagination.Text = PageList.GoToPager(page, 10, "FavoriteList.aspx?content_type=" + type + "&page", strWhere, table);
                        pnlPurchase.Visible = false;
                        pnlCompany.Visible = false;
                        break;
                        break;
                }
            }
            else
            {
                if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
                {
                    page = int.Parse(Request.QueryString["page"].ToString());
                }
                strselect = "U_UserInfo.CompanyName,U_UserInfo.QQ,C_Supply.*";
                table = "C_Supply INNER JOIN U_UserInfo ON C_Supply.UserID =U_UserInfo.UserID INNER JOIN U_Favorites ON C_Supply.ID = U_Favorites.ProductID";
                strWhere = "1=1 and U_Favorites.Type='Supply' and U_Favorites.UserID=" + Userid;
                dt = PageList.GetDataTable(strWhere, table, 1, "C_Supply.AddDate", "*", 10, page, 0);
                dlstSupply.DataSource = dt.DefaultView;
                dlstSupply.DataBind();
                lblPagination.Text = PageList.GoToPager(page, 10, "FavoriteList.aspx?content_type=Supply&page", strWhere, table);
                pnlPurchase.Visible = false;
                pnlCompany.Visible = false;
            }
            SetColor();
        }
    }


    /// <summary>
    /// 设置颜色
    /// </summary>
    private void SetColor()
    {
        if (Request.QueryString["content_type"] != null)
        {
            if (Request.QueryString["content_type"] == "Purchase")
                this.menu2.Attributes.Add("class", "MenuLiCheck");
            else if (Request.QueryString["content_type"] == "Company")
                this.menu3.Attributes.Add("class", "MenuLiCheck");
            else
                this.menu1.Attributes.Add("class", "MenuLiCheck");
        }
        else
            this.menu1.Attributes.Add("class", "MenuLiCheck");

    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["content_type"] == "Supply")
        {
            for (int i = 0; i <= dlstSupply.Items.Count - 1; i++)
            {

                CheckBox cbox = (CheckBox)dlstSupply.Items[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {

                    int ID = Convert.ToInt32(dlstSupply.DataKeys[i]);
                    IFavorites RM = new RFavorites();
                    int m = RM.Delete(ID);
                }
            }
        }
        else if (Request.QueryString["content_type"] == "Purchase")
        {
            for (int i = 0; i <= dlstPurchase.Items.Count - 1; i++)
            {

                CheckBox cbox = (CheckBox)dlstPurchase.Items[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {

                    int ID = Convert.ToInt32(dlstPurchase.DataKeys[i]);
                    IFavorites RM = new RFavorites();
                    int m = RM.Delete(ID);
                }
            }
        }
        else if (Request.QueryString["content_type"] == "Company")
        {
            for (int i = 0; i <= dlstCompany.Items.Count - 1; i++)
            {

                CheckBox cbox = (CheckBox)dlstCompany.Items[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {

                    int ID = Convert.ToInt32(dlstCompany.DataKeys[i]);
                    IFavorites RM = new RFavorites();
                    int m = RM.Delete(ID);
                }
            }
        }
        else
        {
            for (int i = 0; i <= dlstSupply.Items.Count - 1; i++)
            {

                CheckBox cbox = (CheckBox)dlstSupply.Items[i].FindControl("CheckBox1");
                if (cbox.Checked == true)
                {

                    int ID = Convert.ToInt32(dlstSupply.DataKeys[i]);
                    IFavorites RM = new RFavorites();
                    int m = RM.Delete(ID);
                }
            }
        }
        Bind();
    }

    public string cose(string strQQ)
    {
        if (strQQ != string.Empty)
            return "  <a target=\"blank\" href=\"http://wpa.qq.com/msgrd?V=1&Uin=" + strQQ + "&Exe=QQ&Site=im.qq.com&Menu=No\"><img style=\" border:0\" src=\"http://wpa.qq.com/pa?p=1:" + strQQ + ":3\" alt=\"给我发消息\" /></a>";
        else
            return string.Empty;
    }
}
