﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UserInfo;
using System.Data.SqlClient;
using SqlOperate;
using Base;

public partial class Member_Trade_MemberProductEdit : nspBase.MemberBasePge
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                Bind();
                return;
            }
        }
        else
        {
            Response.Redirect("../../login/login.aspx");
        }

    }

    private void Bind()
    {
        RUserInfo info = new RUserInfo();
        TUserInfo user = info.GateItem(Convert.ToInt32( Base.GetRequest.GetCookie("UserID")));
        if (user != null)
        {
            txtCompanyName.Text = user.CompanyName;
            txtLinkName.Text = user.LinkName;
            txtPhone.Text = user.MobilePhone;
        }
    }

    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (txtAsk.Text != "")
        {
            int productId = 0;
            if (Request["ProductId"] != null)
            {
                productId = int.Parse(Request["ProductId"]);
            }
            try
            {
                string updateStr = "update [U_UserInfo] SET [CompanyName]=@Name,[LinkName]=@user,[MobilePhone]=@phone WHERE UserID = @Id ";
                SqlParameter[] parm ={ 
                new SqlParameter("@Name",txtCompanyName.Text),
                new SqlParameter("@user",txtLinkName.Text),
                new SqlParameter("@phone",txtPhone.Text),
                new SqlParameter("@Id",Convert.ToInt32( Base.GetRequest.GetCookie("UserID")))
            };
                SqlHelper.ExecuteNonQuery(CommandType.Text, updateStr, parm);
                string insertStr = "update W_UsersProducts set Ask = @ask where ID=@productId";
                SqlParameter[] parms ={ 
                new SqlParameter("@ask",txtAsk.Text),
                new SqlParameter("@productId",productId)
            };                
                SqlHelper.ExecuteNonQuery(CommandType.Text, insertStr, parms);
                Messagess.ShowMessage("提交成功！", "MemberProductAdd.aspx");
            }
            catch (Exception ex)
            {
                Messagess.ShowMessage(ex.Message);
            }
        }

    }

    protected void btnReset_Click(object sender, EventArgs e)
    {
        Response.Redirect("MemberProductAdd.aspx");
    }
}
