﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using System.Data.SqlClient;
using SqlOperate;

public partial class Member_Trade_MemberProductList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                Bind();
            }
        }
        else
            Response.Redirect("../../login/login.aspx");
    }
    private void Bind()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "i.UserID=" + GetCookie("UserID");
        PageNo1.Strurl = strURl;
        PageNo1.Table = " U_UserInfo u inner join W_UsersProducts i on u.UserId=i.UserID inner join W_Products p on p.ID=i.ProductId  ";
        PageNo1.FldName = "i.Sort";
        PageNo1.StrGetFields = "i.ID,i.IsTop,i.Ask,i.LastDate,u.UserId,u.CompanyName,p.Name,i.Verify,i.sort,i.AddDate";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            DataTable table = PageNo1.BindView();
            gvProducts.DataSource = dt.DefaultView;
            gvProducts.DataBind();
        }
        else
        {
            if (GetRequest.GetQueryStringValue("V") != "")
            {
                switch (GetRequest.GetQueryStringValue("v"))
                {
                    case "1":
                        this.Label2.CssClass = "pl";
                        strWhere += " and i.Verify=1";
                        break;
                    case "2":
                        strWhere += " and i.Verify=3";
                        this.Label3.CssClass = "pl";
                        break;
                    case "3":
                        strWhere += " and i.IsTop=0 and i.Ask<>''";
                        this.Label4.CssClass = "pl";
                        break;
                    case "4":
                        strWhere += " and i.IsTop=1";
                        this.Label6.CssClass = "pl";
                        break;
                    default:
                        this.Label1.CssClass = "pl";
                        break;
                }
            }
            PageNo1.Pageindex = 1;
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindView();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            gvProducts.DataSource = dt.DefaultView;
            gvProducts.DataBind();
        }
        SetColor();
    }
    /// <summary>
    /// 设置颜色
    /// </summary>
    private void SetColor()
    {
        if (Request.QueryString["v"] != null)
        {
            if (Request.QueryString["v"] == "1")
                this.menu1.Attributes.Add("class", "MenuLiCheck");
            else if (Request.QueryString["v"] == "2")
                this.menu2.Attributes.Add("class", "MenuLiCheck");
            else if (Request.QueryString["v"] == "3")
                this.menu3.Attributes.Add("class", "MenuLiCheck");
            else if (Request.QueryString["v"] == "4")
                this.menu4.Attributes.Add("class", "MenuLiCheck");
            else
                this.menu5.Attributes.Add("class", "MenuLiCheck");
        }
        else
            this.menu5.Attributes.Add("class", "MenuLiCheck");
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < gvProducts.Rows.Count; i++)
        {
            CheckBox chk = (CheckBox)gvProducts.Rows[i].FindControl("CheckBox1");
            if (chk.Checked == true)
            {
                int ID = Convert.ToInt32(gvProducts.DataKeys[i].Value);
                try
                {
                    SqlParameter[] param = new SqlParameter[] 
                    {
                        new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                        new SqlParameter("@strTableName", "W_UsersProducts") 
                    };
                    SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
                }
                catch (Exception ex)
                {
                    ShowMessage(ex.Message);
                }

            }
        }
        Bind();
    }

    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int ID = int.Parse(e.CommandArgument.ToString());
        try
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_UsersProducts") 
            };
            SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
        Bind();
    }

    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
        {
            return Convert.ToDateTime(dateStr).ToShortDateString();
        }
        else
            return string.Empty;
    }
    protected void gvProducts_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this)");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }

    public static string ShowVerify(string strVerify)
    {
        if (strVerify == "1")
        {
            return "通过";
        }
        else if (strVerify == "2")
        {
            return "未通过";
        }
        else
        {
            return "未审";
        }
    }


}
