﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Solely;
using Product;
using Base;
using Corporation.Product;



public partial class member_Trade_Purchase : nspBase.MemberBasePge
{
    RProType ProType = new RProType();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                UnitBind();
                PersonInfoBind();
            }
            int userid = Convert.ToInt32(GetCookie("UserID").ToString());
            int gradeid = Convert.ToInt32(GetCookie("GradeID").ToString());
            if (!Other.CheckUserBussinessCount(gradeid, "purchase", userid))
            {
                Response.Redirect("../ErrorPage.aspx?griad=" + gradeid);
                return;
            }
        }
        else
        {
            Response.Redirect("../../login/login.aspx");
        }
    }
    private void UnitBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/UnitPrice.xml"));
        dropUnit.DataSource = ds.Tables[0];
        dropUnit.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropUnit.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropUnit.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string Restr = "";
            string myValue = "";
            if (Request.Form["ctl00$ContInfo$SortB"] != null && Request.Form["ctl00$ContInfo$SortB"] != "")
                myValue += Request.Form["ctl00$ContInfo$SortB"];
            if (Request.Form["ctl00$ContInfo$SortM"] != null && Request.Form["ctl00$ContInfo$SortM"] != "")
                myValue += "," + Request.Form["ctl00$ContInfo$SortM"];
            if (Request.Form["ctl00$ContInfo$SortS"] != null && Request.Form["ctl00$ContInfo$SortS"] != "")
                myValue += "," + Request.Form["ctl00$ContInfo$SortS"];
            int id = int.Parse(Base.BasePage.GetCookie("UserID"));
            TPurchase TPur = new TPurchase();
            TPur.UserID = id;
            TPur.IsUser = "1";
            TPur.IndType = myValue;
            if (txtName.Text.Trim().Equals(string.Empty))
                Restr += "产品名称，";
            else
                TPur.Name = Base.Common.RemoveHTML(this.txtName.Text);
            if (txtKey.Text.Trim().Equals(string.Empty))
                Restr += "关键字，";
            else {
                ArrayList array = new ArrayList();
                String newvalue = this.txtKey.Text;
                String oldvalue = newvalue.Replace("，", ",");
                String[] arry = oldvalue.Split(',');//拿逗号隔开后的字符串
                for (int i = 0; i < arry.Length; i++)
                {
                    if (array.Contains(arry[i]) == false)//判断 要拆分的字符串 中是否已经存在于这个ArrayList中   
                    {
                        array.Add(arry[i]);//不存在则添加进ArrayList   
                    }
                }
                TPur.Key = Server.HtmlEncode(String.Join(",", (string[])array.ToArray(typeof(string))));//在指定 String 数组的每个元素之间串联指定的分隔符 String，从而产生单个串联的字符串
            }
            string strContent = Base.GetRequest.RemoveHTMLForEditor(this.txtContent.Value);
            TPur.Info = Base.GetRequest.WipeScript(strContent);
            TPur.Picture_1 = this.ImgUrl1.Value;
            TPur.Thumbnail = this.ImgUrl1.Value;
            TPur.AddDate = Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TPur.StartDate = Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TPur.EndDate = DateTime.Now.AddDays(Convert.ToDouble(this.RadioTime.SelectedValue));
            TPur.Brand = this.txtBrand.Text;
            TPur.Model = this.txtModel.Text;
            TPur.Unit = dropUnit.SelectedValue;
            TPur.Count = int.Parse(txtCount.Text);
            TPur.Price =Convert.ToDouble(txtPrice.Text);
            IPurchase Rpur = new RPurchase();
            if (!Restr.Trim().Equals(string.Empty))
                Restr = Restr.Substring(0, Restr.Length - 1);
            int isEmail = 0;

            //读取指定节点下的value值
            string strFlag = Base.XMLProcess.Read("xml/EmailFlag.xml", "/Item/flag/mode[@type='purchase']", "value");
            if (strFlag == "")
                strFlag = "us_purchase";
            if (Restr.Trim().Equals(string.Empty)) //判断输入是否正确
            {
                Rpur.Insert(TPur, out isEmail);
                if (isEmail > 0)
                {
                    nspBase.Core.clsEmail.SendMail(strFlag, id);
                }
                ShowMessage("恭喜您，商机发布成功！", "Trade/PurchaseManage.aspx");
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }

    }

    /// <summary>
    /// 显示会员信息
    /// </summary>
    private void PersonInfoBind()
    {
        DataTable tbuserinfo = ProType.GetPersonInfoById(Convert.ToInt32(GetCookie("UserID").ToString()));
        if (tbuserinfo.Rows.Count != 0)
        {
            this.UserName.Text = tbuserinfo.Rows[0]["LinkName"].ToString() + "(" + tbuserinfo.Rows[0]["sex"].ToString() + ")";
            this.UserTelephone.Text = tbuserinfo.Rows[0]["Tel_International"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_DistrictNumber"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_Telephone"].ToString();
            this.UserChuanzhen.Text = tbuserinfo.Rows[0]["qq"].ToString();
            this.CompanyName.Text = tbuserinfo.Rows[0]["CompanyName"].ToString();
            this.Email.Text = tbuserinfo.Rows[0]["Email"].ToString();
        }
    }
}
