﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Product;
using Base;
using Corporation.Product;

public partial class member_Trade_PurchaseEdit : nspBase.MemberBasePge
{
    RProType ProType = new RProType();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                UnitBind();
                Bind();
                PersonInfoBind();
            }
        }
        else
        {
            Response.Redirect("../../login/login.aspx");
        }

    }

    private void UnitBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/UnitPrice.xml"));
        dropUnit.DataSource = ds.Tables[0];
        dropUnit.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropUnit.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropUnit.DataBind();
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"]);
        IPurchase RPur = new RPurchase();
        TPurchase TPur = RPur.GateItem(id);
        if (TPur != null)
        {
            this.txtName.Text = TPur.Name;
            this.txtKey.Text = TPur.Key;

            this.txtSortB.Value = TPur.IndType;
            this.txtContent.Value = TPur.Info;
            if (TPur.Picture_1 == "")
            {
                ImgUrl1.Value = "../../Images/System/wutu.gif";
                ImgUrl.Src = "../../Images/System/wutu.gif";
            }
            else
            {
                this.ImgUrl1.Value = TPur.Picture_1;
                this.ImgUrl.Src = TPur.Picture_1;
            }
            this.txtBrand.Text = TPur.Brand;
            this.txtModel.Text = TPur.Model;
            TimeSpan time = new TimeSpan(TPur.EndDate.Ticks - TPur.StartDate.Ticks);
            this.RadioTime.SelectedValue = time.Days.ToString();
            this.dropUnit.SelectedValue = TPur.Unit;
            this.txtCount.Text = TPur.Count.ToString();
            this.txtPrice.Text = TPur.Price.ToString();
        }
        if (TPur.IndType != null)
        {
            string[] str = TPur.IndType.Split(new char[] { ',' });
            for (int i = 0; i < str.Length; i++)
            {
                if (i == 0)
                    this.txtSortB.Value = str[i];
                else if (i == 1)
                    this.txtSortM.Value = str[i];
                else
                    this.txtSortS.Value = str[i];
            }
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string Restr = "";
            string myValue = "";
            if (Request.Form["ctl00$ContInfo$SortB"] != null && Request.Form["ctl00$ContInfo$SortB"] != "")
                myValue += Request.Form["ctl00$ContInfo$SortB"];
            if (Request.Form["ctl00$ContInfo$SortM"] != null && Request.Form["ctl00$ContInfo$SortM"] != "")
                myValue += "," + Request.Form["ctl00$ContInfo$SortM"];
            if (Request.Form["ctl00$ContInfo$SortS"] != null && Request.Form["ctl00$ContInfo$SortS"] != "")
                myValue += "," + Request.Form["ctl00$ContInfo$SortS"];
            int id = int.Parse(Request.QueryString["ID"].ToString());
            TPurchase TPur = new TPurchase();
            TPur.ID = id;
            TPur.IndType = myValue;
            if (txtName.Text.Trim().Equals(string.Empty))
                Restr += "产品名称，";
            else
                TPur.Name = Base.Common.RemoveHTML(this.txtName.Text);
            if (txtKey.Text.Trim().Equals(string.Empty))
                Restr += "关键字，";
            else
            {
                ArrayList array = new ArrayList();
                String newvalue = this.txtKey.Text;
                String oldvalue = newvalue.Replace("，", ",");
                String[] arry = oldvalue.Split(',');//拿逗号隔开后的字符串
                for (int i = 0; i < arry.Length; i++)
                {
                    if (array.Contains(arry[i]) == false)//判断 要拆分的字符串 中是否已经存在于这个ArrayList中   
                    {
                        array.Add(arry[i]);//不存在则添加进ArrayList   
                    }
                }
                TPur.Key = Server.HtmlEncode(String.Join(",", (string[])array.ToArray(typeof(string))));//在指定 String 数组的每个元素之间串联指定的分隔符 String，从而产生单个串联的字符串
            }
            string strContent = Base.GetRequest.RemoveHTMLForEditor(this.txtContent.Value);
            TPur.Info = Base.GetRequest.WipeScript(strContent);
            TPur.Thumbnail = this.ImgUrl1.Value;
            TPur.Picture_1 = this.ImgUrl1.Value;
            TPur.Brand = this.txtBrand.Text;
            TPur.Model = this.txtModel.Text;

            TPur.StartDate = Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TPur.EndDate = DateTime.Now.AddDays(Convert.ToDouble(this.RadioTime.SelectedValue));

            TPur.Unit = dropUnit.SelectedValue;
            if (txtCount.Text != string.Empty)
                TPur.Count = int.Parse(txtCount.Text);
            else
                TPur.Count = 0;
            if (txtPrice.Text != string.Empty)
                TPur.Price =Convert.ToDouble(txtPrice.Text);
            else
                TPur.Price = 0;
            IPurchase Rpur = new RPurchase();
            if (!Restr.Trim().Equals(string.Empty))
                Restr = Restr.Substring(0, Restr.Length - 1);
            if (Restr.Trim().Equals(string.Empty))
            {
                Rpur.Update(TPur);
                ShowMessage("恭喜您，商机发布成功！", "Trade/PurchaseManage.aspx");
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }

    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("PurchaseManage.aspx");
    }

    /// <summary>
    /// 显示会员信息
    /// </summary>
    private void PersonInfoBind()
    {
        DataTable tbuserinfo = ProType.GetPersonInfoById(Convert.ToInt32(GetCookie("UserID").ToString()));
        if (tbuserinfo.Rows.Count != 0)
        {
            this.UserName.Text = tbuserinfo.Rows[0]["LinkName"].ToString() + "(" + tbuserinfo.Rows[0]["sex"].ToString() + ")";
            this.UserTelephone.Text = tbuserinfo.Rows[0]["Tel_International"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_DistrictNumber"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_Telephone"].ToString();
            this.UserChuanzhen.Text = tbuserinfo.Rows[0]["qq"].ToString();
            this.CompanyName.Text = tbuserinfo.Rows[0]["CompanyName"].ToString();
            this.Email.Text = tbuserinfo.Rows[0]["Email"].ToString();
        }
    }
}
