﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Solely;
using Product;
using Base;
using Corporation.Product;
using System.Text.RegularExpressions;

public partial class Member_Trade_SupplyAdd : nspBase.MemberBasePge
{
    RProType ProType = new RProType();
    RSupply RSup = new RSupply();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                ProTypeBind();
                UnitBind();
                aload();
                PersonInfoBind();

            }
            int userid = Convert.ToInt32(GetCookie("UserID").ToString());
            int gradeid = Convert.ToInt32(GetCookie("GradeID").ToString());
            if (!Other.CheckUserBussinessCount(gradeid, "supply", userid))
            {
                Response.Redirect("../ErrorPage.aspx?err=1");
            }
        }
        else
            Response.Redirect("../../login/login.aspx");
    }
    private void ProTypeBind()
    {
        dropProType.Items.Add(new ListItem("--+所有类别+--", ""));
        TProType TPro = new TProType();
        TPro.UserID = Convert.ToInt32(GetCookie("UserID").ToString());
        DataTable dt = ProType.GetDataTable(TPro);
        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                dropProType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }

    }
    private void aload()
    {
        this.danwei.InnerHtml = "元/" + this.dropUnit.SelectedItem.ToString();
        this.gonghuo.InnerHtml = this.dropUnit.SelectedItem.ToString();
        this.zuixiaoqi.InnerHtml = this.dropUnit.SelectedItem.ToString();
    }
    private void UnitBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/UnitPrice.xml"));
        dropUnit.DataSource = ds.Tables[0];
        dropUnit.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropUnit.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropUnit.DataBind();

    }
    private void PersonInfoBind()
    {
        DataTable tbuserinfo = ProType.GetPersonInfoById(Convert.ToInt32(GetCookie("UserID").ToString()));
        if (tbuserinfo.Rows.Count != 0)
        {
            this.UserName.Text = tbuserinfo.Rows[0]["LinkName"].ToString() + "(" + tbuserinfo.Rows[0]["sex"].ToString() + ")";
            this.UserTelephone.Text = tbuserinfo.Rows[0]["Tel_International"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_DistrictNumber"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_Telephone"].ToString();
            this.UserChuanzhen.Text = tbuserinfo.Rows[0]["qq"].ToString();
            this.CompanyName.Text = tbuserinfo.Rows[0]["CompanyName"].ToString();
            this.Email.Text = tbuserinfo.Rows[0]["Email"].ToString();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        String error = "";
        int isEmail = 0;
        int id = 0;

        TSupply TSup = new TSupply();
        Base.Common comon = new Common();
        try
        {
            if (RSup.GetMessageExists(this.txtName.Text, Convert.ToInt32(GetCookie("UserID").ToString())))
            {
                error += "您发布的商品已经存在,请重新发布新的商品。<br/>";
            }
       
            string myValue = "";
            if (Request.Form["ctl00$ContInfo$SortB"] != null && Request.Form["ctl00$ContInfo$SortB"] != "")
                myValue += Request.Form["ctl00$ContInfo$SortB"];
            if (Request.Form["ctl00$ContInfo$SortM"] != null && Request.Form["ctl00$ContInfo$SortM"] != "")
                myValue += "," + Request.Form["ctl00$ContInfo$SortM"];
            if (Request.Form["ctl00$ContInfo$SortS"] != null && Request.Form["ctl00$ContInfo$SortS"] != "")
                myValue += "," + Request.Form["ctl00$ContInfo$SortS"];
            id = Convert.ToInt32(Base.BasePage.GetCookie("UserID"));
            TSup.UserID = id;
            if (String.IsNullOrEmpty(txtName.Text))
            {
                error += "产品名称不能为空<br/>";
            }
            else
            {

                TSup.Name = Server.HtmlEncode(Base.Common.RemoveHTML(this.txtName.Text)); //过滤字符串

            }
            if (string.IsNullOrEmpty(txtKey.Text))
            {
                error += "关键字不能为空<br/>";
            }
            else
            {
                ArrayList array = new ArrayList();
                String newvalue = this.txtKey.Text;
                String oldvalue = newvalue.Replace("，", ",");
                String[] arry = oldvalue.Split(',');//拿逗号隔开后的字符串
                for (int i = 0; i < arry.Length; i++)
                {
                    if (array.Contains(arry[i]) == false)//判断 要拆分的字符串 中是否已经存在于这个ArrayList中   
                    {
                        array.Add(arry[i]);//不存在则添加进ArrayList   
                    }
                }
                TSup.Key = Server.HtmlEncode(String.Join(",", (string[])array.ToArray(typeof(string))));//在指定 String 数组的每个元素之间串联指定的分隔符 String，从而产生单个串联的字符串
            }

            if (string.IsNullOrEmpty(myValue))
            {
                error += "产品所属类目不能为空<br/>";
            }
            else
            {
                TSup.IndType = myValue;
            }
            TSup.AddDate = Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TSup.StartDate =Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TSup.EndDate = DateTime.Now.AddDays(Convert.ToDouble(this.RadioTime.SelectedValue));
            TSup.Picture_1 = this.ImgUrl1.Value;
            TSup.Thumbnail = this.ImgUrl1.Value;
            if (dropProType.SelectedValue != "")
                TSup.ProType = int.Parse(dropProType.SelectedValue);
            TSup.Place = Server.HtmlEncode(this.txtPlace.Text);
            TSup.Brand = Server.HtmlEncode(this.txtBrand.Text);
            TSup.Model = Server.HtmlEncode(this.txtModel.Text);
            if (!String.IsNullOrEmpty(txtPrice.Text))
            {
                if (comon.IsValidPrice(txtPrice.Text))
                {
                    TSup.Price = Convert.ToDouble(this.txtPrice.Text);
                }
                else
                {
                    error += "价格格式不正确<br/>";
                }
            }
            else
            {
                TSup.Price = 1;
            }
            if (!String.IsNullOrEmpty(txtQuantity.Text))
            {
                if (Base.Common.CheckNum(txtQuantity.Text))
                {
                    if (Convert.ToInt32(txtQuantity.Text) > 1000000)
                    {
                        error += "供货总量最大值不能大于1000000<br/>";
                    }
                    else
                    {
                        TSup.Quantity = int.Parse(this.txtQuantity.Text);
                    }
                }
                else
                {
                    TSup.Quantity = 1;
                }
            }

            TSup.Units = this.dropUnit.SelectedValue;
            if (!String.IsNullOrEmpty(txtMinimum.Text))
            {
                if (Base.Common.CheckNum(txtMinimum.Text))
                {
                    if (Convert.ToInt32(txtMinimum.Text) > TSup.Quantity)
                    {
                        error += "最小起定量不能大于供货总量<br/>";
                    }
                    else
                    {
                        TSup.Minimum = int.Parse(this.txtMinimum.Text);
                    }
                }
                else
                {
                    TSup.Minimum = 1;
                }
            }
            TSup.Deadline = int.Parse(this.radlDeadline.SelectedValue);
            string strContent = Base.GetRequest.RemoveHTMLForEditor(this.txtContent.Value);
            TSup.Info = Base.GetRequest.WipeScript(strContent);

            if (error != "")
            {
                this.lblMessage.Text = error;
                return;
            }
            //读取指定节点下的value值
            String strFlag = Base.XMLProcess.Read("xml/EmailFlag.xml", "/Item/flag/mode[@type='supply']", "value");
            if (strFlag == "")
                strFlag = "us_supply";
            int num = RSup.Insert(TSup, out isEmail);
            if (isEmail > 0)
            {
                nspBase.Core.clsEmail.SendMail(strFlag, id);
            }
            if (num > 0)
            {
                ShowMessage("恭喜您，供应信息发布成功！", "Trade/SupplyManage.aspx?class=MenuLiCheck");
            }
        }
        catch (Exception ex)
        {
            this.lblMessage.Text = "服务器繁忙,请稍后再试！";
        }


    }
}
